/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.j2ee.clientproject.api.AppClientProjectGenerator;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectType;
import org.netbeans.modules.j2ee.earproject.ModuleType;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.j2ee.ejbjarproject.api.EjbJarProjectGenerator;
import org.netbeans.modules.web.project.api.WebProjectCreateData;
import org.netbeans.modules.web.project.api.WebProjectUtilities;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EarProjectGenerator {
    private static final String DEFAULT_DOC_BASE_FOLDER = "src/conf";
    private static final String DEFAULT_BUILD_DIR = "build";
    private static final String DEFAULT_RESOURCE_FOLDER = "setup";
    private static final String SOURCE_ROOT_REF = "${source.root}";
    private final File prjDir;
    private final String name;
    private final String j2eeLevel;
    private final String serverInstanceID;
    private final String sourceLevel;
    private FileObject prjDirFO;

    private EarProjectGenerator(File prjDir, String name, String j2eeLevel, String serverInstanceID, String sourceLevel) {
        this.prjDir = prjDir;
        this.name = name;
        this.j2eeLevel = j2eeLevel;
        this.serverInstanceID = serverInstanceID;
        this.sourceLevel = sourceLevel;
    }

    public static AntProjectHelper createProject(File prjDir, String name, String j2eeLevel, String serverInstanceId, String sourceLevel) throws IOException {
        EarProjectGenerator earGen = new EarProjectGenerator(prjDir, name, j2eeLevel, serverInstanceId, sourceLevel);
        return earGen.doCreateProject();
    }

    public static AntProjectHelper importProject(File pDir, File sDir, String name, String j2eeLevel, String serverInstanceID, String platformName, String sourceLevel, Map<FileObject, ModuleType> userModules) throws IOException {
        EarProjectGenerator earGen = new EarProjectGenerator(pDir, name, j2eeLevel, serverInstanceID, sourceLevel);
        return earGen.doImportProject(sDir, userModules, platformName);
    }

    private AntProjectHelper doCreateProject() throws IOException {
        this.doRefresh();
        AntProjectHelper h = this.setupProject();
        FileObject docBase = FileUtil.createFolder((FileObject)this.prjDirFO, (String)DEFAULT_DOC_BASE_FOLDER);
        FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-j2ee-earproject/MANIFEST.MF"), (FileObject)docBase, (String)"MANIFEST");
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.put((Object)"source.root", (Object)".");
        ep.setProperty("meta.inf", DEFAULT_DOC_BASE_FOLDER);
        ep.setProperty("resource.dir", DEFAULT_RESOURCE_FOLDER);
        h.putProperties("nbproject/project.properties", ep);
        Project p = ProjectManager.getDefault().findProject(h.getProjectDirectory());
        ProjectManager.getDefault().saveProject(p);
        EarProject earProject = (EarProject)p.getLookup().lookup(EarProject.class);
        assert (earProject != null);
        EarProjectGenerator.setupDD(this.j2eeLevel, docBase, earProject);
        return h;
    }

    private AntProjectHelper doImportProject(File srcPrjDir, Map<FileObject, ModuleType> userModules, String platformName) throws IOException {
        this.doRefresh();
        FileObject srcPrjDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)srcPrjDir));
        FileObject docBase = FileUtil.createFolder((FileObject)srcPrjDirFO, (String)DEFAULT_DOC_BASE_FOLDER);
        AntProjectHelper earHelper = this.setupProject();
        EditableProperties ep = earHelper.getProperties("nbproject/project.properties");
        ReferenceHelper referenceHelper = new ReferenceHelper(earHelper, earHelper.createAuxiliaryConfiguration(), earHelper.getStandardPropertyEvaluator());
        ep.setProperty("source.root", referenceHelper.createForeignFileReference(srcPrjDir, null));
        ep.setProperty("meta.inf", this.createFileReference(referenceHelper, srcPrjDirFO, docBase));
        earHelper.putProperties("nbproject/project.properties", ep);
        FileObject earDirFO = earHelper.getProjectDirectory();
        EarProject earProject = (EarProject)ProjectManager.getDefault().findProject(earDirFO).getLookup().lookup(EarProject.class);
        if (null != earProject) {
            Application app = null;
            try {
                FileObject appXml = earProject.getAppModule().getDeploymentDescriptor();
                FileObject fileBeingCopied = null;
                if (null != appXml) {
                    Enumeration filesToBackup = appXml.getParent().getChildren(false);
                    while (null != filesToBackup && filesToBackup.hasMoreElements()) {
                        fileBeingCopied = (FileObject)filesToBackup.nextElement();
                        if (!fileBeingCopied.isData() || !fileBeingCopied.canRead()) continue;
                        try {
                            FileUtil.copyFile((FileObject)fileBeingCopied, (FileObject)appXml.getParent(), (String)("original_" + fileBeingCopied.getName()), (String)fileBeingCopied.getExt());
                        }
                        catch (IOException ioe) {}
                    }
                    app = DDProvider.getDefault().getDDRoot(appXml);
                    Module[] m = app.getModule();
                    if (null != m && m.length > 0) {
                        earProject.getAppModule().getConfigSupport().ensureConfigurationReady();
                        for (int k = 0; k < m.length; ++k) {
                            app.removeModule(m[k]);
                        }
                        app.write(earProject.getAppModule().getDeploymentDescriptor());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(EarProjectGenerator.class, (String)"MESSAGE_CheckContextRoots"), 2));
                    }
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(ioe.getLocalizedMessage());
            }
        }
        EarProjectGenerator.setupDD(this.j2eeLevel, docBase, earProject);
        if (userModules == null || userModules.isEmpty()) {
            userModules = ModuleType.detectModules(srcPrjDirFO);
        }
        this.addUserModules(userModules, platformName, earHelper, earProject);
        ProjectManager.getDefault().saveProject((Project)earProject);
        earProject.getAppModule().getConfigSupport().createInitialConfiguration();
        if (this.sourceLevel != null) {
            EarProjectGenerator.setPlatformSourceLevel(earHelper, this.sourceLevel);
        }
        return earHelper;
    }

    private void doRefresh() throws FileStateInvalidException {
        this.prjDir.mkdirs();
        File rootF = this.prjDir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject rootFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)rootF));
        assert (rootFO != null) : "At least disk roots must be mounted! " + rootF;
        rootFO.getFileSystem().refresh(false);
        this.prjDirFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.prjDir));
        assert (this.prjDirFO != null) : "No such dir on disk: " + this.prjDir;
        assert (this.prjDirFO.isFolder()) : "Not really a dir: " + this.prjDir;
    }

    private void addUserModules(Map<FileObject, ModuleType> userModules, String platformName, AntProjectHelper h, EarProject earProject) throws IOException {
        AuxiliaryConfiguration aux = h.createAuxiliaryConfiguration();
        ReferenceHelper refHelper = new ReferenceHelper(h, aux, h.getStandardPropertyEvaluator());
        EarProjectProperties epp = new EarProjectProperties(earProject, refHelper, new EarProjectType());
        HashSet<Project> ejbs = new HashSet<Project>();
        HashSet<Project> webAndCars = new HashSet<Project>();
        block4: for (Map.Entry<FileObject, ModuleType> entry : userModules.entrySet()) {
            FileObject subprojectDir = entry.getKey();
            ModuleType type = entry.getValue();
            Project subProject = this.addModule(type, epp, platformName, subprojectDir);
            assert (subProject != null) : "Directory " + subprojectDir + " does not contain valid project";
            switch (type) {
                case EJB: {
                    ejbs.add(subProject);
                    continue block4;
                }
                case WEB: 
                case CLIENT: {
                    webAndCars.add(subProject);
                    continue block4;
                }
            }
            assert (false) : "Unknown module type: " + (Object)((Object)type);
        }
        Project[] webAndCarsArray = webAndCars.toArray(new Project[webAndCars.size()]);
        for (Project ejb : ejbs) {
            EarProjectGenerator.addEJBToClassPaths(ejb, webAndCarsArray);
        }
    }

    public static void addEJBToClassPaths(Project ejbJarProject, Project ... projects) throws IOException {
        AntArtifact[] ejbArtifacts;
        assert (ejbJarProject != null);
        for (AntArtifact artifact : ejbArtifacts = AntArtifactQuery.findArtifactsByType((Project)ejbJarProject, (String)"jar")) {
            for (Project project : projects) {
                if (project == null) continue;
                ProjectClassPathExtender pcpe = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
                URI[] locations = artifact.getArtifactLocations();
                if (pcpe == null || locations.length <= 0) continue;
                pcpe.addAntArtifact(artifact, locations[0].normalize());
            }
        }
    }

    private Project addModule(ModuleType type, EarProjectProperties epp, String platformName, FileObject subprojectRoot) throws IllegalArgumentException, IOException {
        FileObject javaRoot = this.getJavaRoot(subprojectRoot);
        File[] srcFolders = this.getSourceFolders(javaRoot);
        File subProjDir = FileUtil.normalizeFile((File)new File(this.prjDir, subprojectRoot.getNameExt()));
        AntProjectHelper subProjHelper = null;
        switch (type) {
            case WEB: {
                subProjHelper = this.addWebModule(subprojectRoot, srcFolders, subProjDir, platformName);
                break;
            }
            case EJB: {
                subProjHelper = this.addEJBModule(javaRoot, subprojectRoot, subProjDir, platformName);
                break;
            }
            case CLIENT: {
                subProjHelper = this.addAppClientModule(javaRoot, subprojectRoot, subProjDir, platformName);
                break;
            }
            default: {
                assert (false) : "Unknown module type: " + (Object)((Object)type);
                break;
            }
        }
        Project subProject = null;
        if (null != subProjHelper) {
            subProject = ProjectManager.getDefault().findProject(subProjHelper.getProjectDirectory());
            epp.addJ2eeSubprojects(new Project[]{subProject});
        }
        return subProject;
    }

    private AntProjectHelper addAppClientModule(FileObject javaRoot, FileObject subprojectRoot, File subProjDir, String platformName) throws IOException {
        FileObject docBaseFO = FileUtil.createFolder((FileObject)subprojectRoot, (String)DEFAULT_DOC_BASE_FOLDER);
        File docBase = FileUtil.toFile((FileObject)docBaseFO);
        AntProjectHelper subProjHelper = AppClientProjectGenerator.importProject((File)subProjDir, (String)subprojectRoot.getName(), (File[])new File[]{FileUtil.toFile((FileObject)javaRoot)}, (File[])new File[0], (File)docBase, null, (String)EarProjectGenerator.checkJ2eeVersion(this.j2eeLevel, this.serverInstanceID, J2eeModule.CLIENT), (String)this.serverInstanceID);
        if (platformName != null || this.sourceLevel != null) {
            AppClientProjectGenerator.setPlatform((AntProjectHelper)subProjHelper, (String)platformName, (String)this.sourceLevel);
        }
        return subProjHelper;
    }

    private AntProjectHelper addEJBModule(FileObject javaRoot, FileObject subprojectRoot, File subProjDir, String platformName) throws IOException {
        FileObject docBaseFO = FileUtil.createFolder((FileObject)subprojectRoot, (String)DEFAULT_DOC_BASE_FOLDER);
        File docBase = FileUtil.toFile((FileObject)docBaseFO);
        AntProjectHelper subProjHelper = EjbJarProjectGenerator.importProject((File)subProjDir, (String)subprojectRoot.getName(), (File[])new File[]{FileUtil.toFile((FileObject)javaRoot)}, (File[])new File[0], (File)docBase, null, (String)EarProjectGenerator.checkJ2eeVersion(this.j2eeLevel, this.serverInstanceID, J2eeModule.EJB), (String)this.serverInstanceID);
        if (platformName != null || this.sourceLevel != null) {
            EjbJarProjectGenerator.setPlatform((AntProjectHelper)subProjHelper, (String)platformName, (String)this.sourceLevel);
        }
        return subProjHelper;
    }

    private AntProjectHelper addWebModule(FileObject subprojectRoot, File[] srcFolders, File subProjDir, String platformName) throws IOException {
        WebProjectCreateData createData = new WebProjectCreateData();
        createData.setProjectDir(subProjDir);
        createData.setName(subprojectRoot.getName());
        createData.setWebModuleFO(subprojectRoot);
        createData.setSourceFolders(srcFolders);
        createData.setTestFolders(new File[0]);
        createData.setDocBase(FileUtil.createFolder((FileObject)subprojectRoot, (String)"web"));
        createData.setLibFolder(null);
        createData.setJavaEEVersion(EarProjectGenerator.checkJ2eeVersion(this.j2eeLevel, this.serverInstanceID, J2eeModule.WAR));
        createData.setServerInstanceID(this.serverInstanceID);
        createData.setBuildfile("build.xml");
        createData.setJavaPlatformName(platformName);
        createData.setSourceLevel(this.sourceLevel);
        return WebProjectUtilities.importProject((WebProjectCreateData)createData);
    }

    static FileObject setupDD(String j2eeLevel, FileObject docBase, EarProject earProject) throws IOException {
        FileObject dd = docBase.getFileObject("application.xml");
        if (dd != null) {
            return dd;
        }
        FileObject template = null;
        if ("1.4".equals(j2eeLevel)) {
            template = Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-j2ee-earproject/ear-1.4.xml");
        } else if ("1.5".equals(j2eeLevel)) {
            template = Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-modules-j2ee-earproject/ear-5.xml");
        } else assert (false) : "Unknown j2eeLevel: " + j2eeLevel;
        if (template != null) {
            dd = FileUtil.copyFile((FileObject)template, (FileObject)docBase, (String)"application");
            Application app = DDProvider.getDefault().getDDRoot(dd);
            app.setDisplayName(ProjectUtils.getInformation((Project)earProject).getDisplayName());
            EarProjectProperties epp = earProject.getProjectProperties();
            for (VisualClassPathItem vcpi : epp.getJarContentAdditional()) {
                epp.addItemToAppDD(app, vcpi);
            }
            app.write(dd);
        }
        return dd;
    }

    public static String checkJ2eeVersion(String requestedVersion, String serverInstanceID, Object moduleType) {
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        Set versions = platform.getSupportedSpecVersions(moduleType);
        if (!versions.contains(requestedVersion) && versions.contains("1.4")) {
            return "1.4";
        }
        return requestedVersion;
    }

    private static String relativePath(FileObject parent, FileObject child) {
        if (child.equals(parent)) {
            return "";
        }
        if (!FileUtil.isParentOf((FileObject)parent, (FileObject)child)) {
            throw new IllegalArgumentException("Cannot find relative path, " + parent + " is not parent of " + child);
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    private AntProjectHelper setupProject() throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)this.prjDirFO, (String)"org.netbeans.modules.j2ee.earproject");
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "name");
        nameEl.appendChild(doc.createTextNode(this.name));
        data.appendChild(nameEl);
        Element minant = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "minimum-ant-version");
        minant.appendChild(doc.createTextNode("1.6"));
        data.appendChild(minant);
        Element wmLibs = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "web-module-libraries");
        data.appendChild(wmLibs);
        Element addLibs = doc.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "web-module-additional-libraries");
        data.appendChild(addLibs);
        h.putPrimaryConfigurationData(data, true);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        ep.setProperty("dist.dir", "dist");
        ep.setProperty("dist.jar", "${dist.dir}/" + this.name + ".ear");
        ep.setProperty("j2ee.platform", this.j2eeLevel);
        ep.setProperty("jar.name", this.name + ".ear");
        ep.setProperty("jar.compress", "false");
        ep.setProperty("jar.content.additional", "");
        ep.setProperty("client.module.uri", "");
        ep.setProperty("client.urlPart", "");
        ep.setProperty("display.browser", "true");
        Deployment deployment = Deployment.getDefault();
        ep.setProperty("j2ee.server.type", deployment.getServerID(this.serverInstanceID));
        ep.setProperty("javac.source", "${default.javac.source}");
        ep.setProperty("javac.debug", "true");
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("javac.target", "${default.javac.target}");
        ep.setProperty("build.dir", DEFAULT_BUILD_DIR);
        ep.setProperty("build.archive.dir", "${build.dir}/jar");
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("build.classes.dir", "${build.archive.dir}");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form,**/.nbattrs");
        ep.setProperty("no.dependencies", "false");
        ep.setProperty("platform.active", "default_platform");
        ep.setProperty("debug.classpath", "${javac.classpath}:${build.classes.dir}:${jar.content.additional}:${run.classpath}");
        J2eePlatform j2eePlatform = deployment.getJ2eePlatform(this.serverInstanceID);
        EarProjectProperties.setACProperties(j2eePlatform, ep);
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("j2ee.server.instance", this.serverInstanceID);
        try {
            AntDeploymentHelper.writeDeploymentScript((File)new File(this.prjDir, "nbproject/ant-deploy.xml"), (Object)J2eeModule.EAR, (String)this.serverInstanceID);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)this.serverInstanceID);
        if (deployAntPropsFile != null) {
            ep.setProperty("deploy.ant.properties.file", deployAntPropsFile.getAbsolutePath());
        }
        EarProjectProperties.setACPrivateProperties(j2eePlatform, this.serverInstanceID, ep);
        h.putProperties("nbproject/private/private.properties", ep);
        Project p = ProjectManager.getDefault().findProject(this.prjDirFO);
        ProjectManager.getDefault().saveProject(p);
        return h;
    }

    private String createFileReference(ReferenceHelper refHelper, FileObject sourceprojectFO, FileObject referencedFO) {
        if (FileUtil.isParentOf((FileObject)this.prjDirFO, (FileObject)referencedFO)) {
            return EarProjectGenerator.relativePath(this.prjDirFO, referencedFO);
        }
        if (FileUtil.isParentOf((FileObject)sourceprojectFO, (FileObject)referencedFO)) {
            String s = EarProjectGenerator.relativePath(sourceprojectFO, referencedFO);
            return s.length() > 0 ? "${source.root}/" + s : SOURCE_ROOT_REF;
        }
        return refHelper.createForeignFileReference(FileUtil.toFile((FileObject)referencedFO), null);
    }

    public static void setPlatformSourceLevel(final AntProjectHelper helper, final String sourceLevel) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                    ep.setProperty("javac.source", sourceLevel);
                    ep.setProperty("javac.target", sourceLevel);
                    helper.putProperties("nbproject/project.properties", ep);
                    ProjectManager.getDefault().saveProject(ProjectManager.getDefault().findProject(helper.getProjectDirectory()));
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    public static String toClasspathString(File[] classpathEntries) {
        if (classpathEntries == null) {
            return "";
        }
        StringBuffer classpath = new StringBuffer();
        for (int i = 0; i < classpathEntries.length; ++i) {
            classpath.append(classpathEntries[i].getAbsolutePath());
            if (i + 1 >= classpathEntries.length) continue;
            classpath.append(':');
        }
        return classpath.toString();
    }

    private FileObject getJavaRoot(FileObject moduleRoot) throws IOException {
        FileObject javaRoot = moduleRoot.getFileObject("src/java");
        if (null == javaRoot) {
            FileObject srcDir = moduleRoot.getFileObject("src");
            if (null == srcDir) {
                srcDir = moduleRoot.createFolder("src");
            }
            javaRoot = srcDir.createFolder("java");
        }
        return javaRoot;
    }

    private File[] getSourceFolders(FileObject javaRoot) {
        File[] fileArray;
        if (null == javaRoot) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = FileUtil.toFile((FileObject)javaRoot);
        }
        return fileArray;
    }
}

