/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;

public class ListenersSupport {
    private final Object source;
    private HashSet listeners = new HashSet(1);

    public ListenersSupport(Object source) {
        this.source = source;
    }

    public synchronized void addListener(VersioningListener listener) {
        HashSet copy = (HashSet)this.listeners.clone();
        copy.add(listener);
        this.listeners = copy;
    }

    public synchronized void removeListener(VersioningListener listener) {
        HashSet copy = (HashSet)this.listeners.clone();
        copy.remove(listener);
        this.listeners = copy;
    }

    public void fireVersioningEvent(Object eventID) {
        this.fireVersioningEvent(new VersioningEvent(this.source, eventID, null));
    }

    public void fireVersioningEvent(Object eventID, Object param) {
        this.fireVersioningEvent(new VersioningEvent(this.source, eventID, new Object[]{param}));
    }

    public void fireVersioningEvent(Object eventID, Object[] params) {
        this.fireVersioningEvent(new VersioningEvent(this.source, eventID, params));
    }

    private void fireVersioningEvent(VersioningEvent event) {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            VersioningListener listener = (VersioningListener)i.next();
            listener.versioningEvent(event);
        }
    }
}

