/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.MessageSet;
import java.util.Vector;
import javax.mail.Message;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] messageArray, Condition condition) {
        Vector<MessageSet> vector = new Vector<MessageSet>(1);
        for (int i = 0; i < messageArray.length; ++i) {
            IMAPMessage iMAPMessage = (IMAPMessage)messageArray[i];
            if (iMAPMessage.isExpunged()) continue;
            int n = iMAPMessage.getSequenceNumber();
            if (condition != null && !condition.test(iMAPMessage)) continue;
            MessageSet messageSet = new MessageSet();
            messageSet.start = n;
            ++i;
            while (i < messageArray.length) {
                iMAPMessage = (IMAPMessage)messageArray[i];
                if (!iMAPMessage.isExpunged()) {
                    int n2 = iMAPMessage.getSequenceNumber();
                    if (condition == null || condition.test(iMAPMessage)) {
                        if (n2 == n + 1) {
                            n = n2;
                        } else {
                            --i;
                            break;
                        }
                    }
                }
                ++i;
            }
            messageSet.end = n;
            vector.addElement(messageSet);
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new MessageSet[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static interface Condition {
        public boolean test(IMAPMessage var1);
    }
}

