/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.hdr;
import javax.mail.internet.matchEnum;

public class InternetHeaders {
    private Vector headers = new Vector();

    public InternetHeaders() {
        this.headers.addElement(new hdr("Return-Path", null));
        this.headers.addElement(new hdr("Received", null));
        this.headers.addElement(new hdr("Message-Id", null));
        this.headers.addElement(new hdr("Resent-Date", null));
        this.headers.addElement(new hdr("Date", null));
        this.headers.addElement(new hdr("Resent-From", null));
        this.headers.addElement(new hdr("From", null));
        this.headers.addElement(new hdr("Reply-To", null));
        this.headers.addElement(new hdr("Sender", null));
        this.headers.addElement(new hdr("To", null));
        this.headers.addElement(new hdr("Subject", null));
        this.headers.addElement(new hdr("Cc", null));
        this.headers.addElement(new hdr("In-Reply-To", null));
        this.headers.addElement(new hdr("Resent-Message-Id", null));
        this.headers.addElement(new hdr("Errors-To", null));
        this.headers.addElement(new hdr("MIME-Version", null));
        this.headers.addElement(new hdr("Content-Type", null));
        this.headers.addElement(new hdr("Content-Transfer-Encoding", null));
        this.headers.addElement(new hdr("Content-MD5", null));
        this.headers.addElement(new hdr(":", null));
        this.headers.addElement(new hdr("Content-Length", null));
        this.headers.addElement(new hdr("Status", null));
    }

    public InternetHeaders(InputStream inputStream) throws MessagingException {
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws MessagingException {
        LineInputStream lineInputStream = new LineInputStream(inputStream);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            do {
                if ((string2 = lineInputStream.readLine()) != null && (string2.startsWith(" ") || string2.startsWith("\t"))) {
                    if (string != null) {
                        stringBuffer.append(string);
                        string = null;
                    }
                    stringBuffer.append("\r\n");
                    stringBuffer.append(string2);
                    continue;
                }
                if (string != null) {
                    this.addHeaderLine(string);
                } else if (stringBuffer.length() > 0) {
                    this.addHeaderLine(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                string = string2;
            } while (string2 != null && string2.length() > 0);
        }
        catch (IOException iOException) {
            throw new MessagingException("Error in input stream", iOException);
        }
    }

    public String[] getHeader(String string) {
        Object[] objectArray;
        Enumeration enumeration = this.headers.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!string.equalsIgnoreCase(objectArray.name) || objectArray.line == null) continue;
            vector.addElement(objectArray.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getHeader(String string, String string2) {
        String[] stringArray = this.getHeader(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 || string2 == null) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setHeader(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.headers.size(); ++i) {
            hdr hdr2 = (hdr)this.headers.elementAt(i);
            if (!string.equalsIgnoreCase(hdr2.name)) continue;
            if (!bl) {
                int n;
                hdr2.line = hdr2.line != null && (n = hdr2.line.indexOf(58)) >= 0 ? hdr2.line.substring(0, n + 1) + " " + string2 : string + ": " + string2;
                bl = true;
                continue;
            }
            this.headers.removeElementAt(i);
            --i;
        }
        if (!bl) {
            this.addHeader(string, string2);
        }
    }

    public void addHeader(String string, String string2) {
        int n = this.headers.size();
        boolean bl = string.equalsIgnoreCase("Received");
        if (bl) {
            n = 0;
        }
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            hdr hdr2 = (hdr)this.headers.elementAt(i);
            if (string.equalsIgnoreCase(hdr2.name)) {
                if (bl) {
                    n = i;
                } else {
                    this.headers.insertElementAt(new hdr(string, string2), i + 1);
                    return;
                }
            }
            if (!hdr2.name.equals(":")) continue;
            n = i;
        }
        this.headers.insertElementAt(new hdr(string, string2), n);
    }

    public void removeHeader(String string) {
        for (int i = 0; i < this.headers.size(); ++i) {
            hdr hdr2 = (hdr)this.headers.elementAt(i);
            if (!string.equalsIgnoreCase(hdr2.name)) continue;
            hdr2.line = null;
        }
    }

    public Enumeration getAllHeaders() {
        return new matchEnum(this.headers, null, false, false);
    }

    public Enumeration getMatchingHeaders(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, true, false);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, false, false);
    }

    public void addHeaderLine(String string) {
        try {
            char c = string.charAt(0);
            if (c == ' ' || c == '\t') {
                hdr hdr2 = (hdr)this.headers.lastElement();
                hdr2.line = hdr2.line + "\r\n" + string;
            } else {
                this.headers.addElement(new hdr(string));
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Enumeration getAllHeaderLines() {
        return this.getNonMatchingHeaderLines(null);
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, true, true);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, false, true);
    }
}

