/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.Collection;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EntityAndSessionGenerator;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Bean;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class EntityGenerator
extends EntityAndSessionGenerator {
    private boolean isCMP = false;
    private String primaryKeyFQN;
    private String primaryKeySimpleName;

    public EntityGenerator() {
    }

    public EntityGenerator(String primaryKeySimpleName) {
        this.primaryKeySimpleName = primaryKeySimpleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEntity(String ejbName, FileObject pkg, boolean hasRemote, boolean hasLocal, Project project, boolean isCMP, String primaryKeyClassName) throws IOException {
        String beanTemplate;
        this.isCMP = isCMP;
        DDProvider provider = DDProvider.getDefault();
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)pkg);
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = provider.getMergedDDRoot(ejbModule.getMetadataUnit());
        ClassPath cp = ClassPath.getClassPath((FileObject)pkg, (String)"classpath/source");
        this.primaryKeyFQN = primaryKeyClassName;
        this.primaryKeySimpleName = primaryKeyClassName;
        if (primaryKeyClassName.indexOf(".") == -1) {
            JavaClass jc;
            Collection classes = JMIUtils.getClassesBySimpleName((String)primaryKeyClassName, (ClassPath)cp);
            if (!classes.isEmpty()) {
                jc = (JavaClass)classes.toArray()[0];
                this.primaryKeyFQN = jc.getName();
                this.primaryKeySimpleName = jc.getSimpleName();
            } else {
                jc = (JavaClass)JMIUtils.resolveType((String)("java.lang." + primaryKeyClassName));
                if (!(jc instanceof UnresolvedClass)) {
                    this.primaryKeyFQN = jc.getName();
                    this.primaryKeySimpleName = jc.getSimpleName();
                }
            }
        } else {
            JavaClass jc = (JavaClass)JMIUtils.resolveType((String)primaryKeyClassName);
            if (!(jc instanceof UnresolvedClass)) {
                this.primaryKeyFQN = jc.getName();
                this.primaryKeySimpleName = jc.getSimpleName();
            }
        }
        ejbName = EjbGenerationUtil.uniqueSingleEjbName(ejbName, ejbJar);
        String pkgName = EjbGenerationUtil.getSelectedPackageName(pkg, project);
        Bean b = this.genUtil.getDefaultBean();
        b.setCommentDataEjbName(ejbName + "Bean");
        b.setClassname(true);
        b.setClassnameName(EjbGenerationUtil.getBeanClassName(ejbName));
        if (pkgName != null) {
            b.setClassnamePackage(pkgName);
        }
        b.setKey(true);
        b.setKeyFullname(this.primaryKeySimpleName);
        J2eeModuleProvider pwm = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        if (beans == null) {
            beans = ejbJar.newEnterpriseBeans();
            ejbJar.setEnterpriseBeans(beans);
        }
        Entity e = beans.newEntity();
        e.setEjbName(b.getCommentDataEjbName());
        e.setEjbClass(EjbGenerationUtil.getFullClassName(b.getClassnamePackage(), b.getClassnameName()));
        e.setPrimKeyClass(this.primaryKeyFQN);
        e.setReentrant(false);
        e.setDisplayName(EjbGenerationUtil.getEjbNameBase(e.getEjbName()) + "EB");
        if (isCMP) {
            beanTemplate = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/CMPBean.xml";
            this.populateCMP(b, e);
        } else {
            beanTemplate = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/BMPBean.xml";
            this.populateBMP(e);
        }
        String beanClass = this.genUtil.generateBeanClass(beanTemplate, b, pkgName, pkg, false);
        e.setEjbClass(beanClass);
        FileObject bFile = pkg.getFileObject(EjbGenerationUtil.getBaseName(beanClass), "java");
        String remoteBusinessIntfName = null;
        if (hasRemote) {
            String remoteName = this.generateRemote(pkgName, pkg, EjbGenerationUtil.getRemoteName(pkgName, ejbName), ejbName);
            e.setRemote(remoteName);
            String remoteHomeName = this.generateHome(pkgName, pkg, EjbGenerationUtil.getHomeName(pkgName, ejbName), remoteName, ejbName);
            e.setHome(remoteHomeName);
            remoteBusinessIntfName = EjbGenerationUtil.getBusinessInterfaceName(pkgName, ejbName);
            this.genUtil.generateBusinessInterfaces(pkgName, pkg, remoteBusinessIntfName, ejbName, beanClass, remoteName);
            EjbGenerationUtil.addPKGetter(e, cp.findResource(remoteBusinessIntfName.replace('.', '/') + ".java"), true);
        }
        String localBusinessIntfName = null;
        if (hasLocal) {
            String localName = this.generateLocal(pkgName, pkg, EjbGenerationUtil.getLocalName(pkgName, ejbName), ejbName);
            e.setLocal(localName);
            String localHomeName = this.generateLocalHome(pkgName, pkg, EjbGenerationUtil.getLocalHomeName(pkgName, ejbName), localName, ejbName);
            e.setLocalHome(localHomeName);
            localBusinessIntfName = EjbGenerationUtil.getLocalBusinessInterfaceName(pkgName, ejbName);
            this.genUtil.generateBusinessInterfaces(pkgName, pkg, localBusinessIntfName, ejbName, beanClass, localName);
            EjbGenerationUtil.addPKGetter(e, cp.findResource(localBusinessIntfName.replace('.', '/') + ".java"), false);
        }
        beans.addEntity(e);
        AssemblyDescriptor ad = ejbJar.getSingleAssemblyDescriptor();
        if (ad == null) {
            ad = ejbJar.newAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(ad);
        }
        ContainerTransaction ct = ad.newContainerTransaction();
        ct.setTransAttribute("Required");
        Method m = ct.newMethod();
        m.setEjbName(ejbName + "Bean");
        m.setMethodName("*");
        ct.addMethod(m);
        ad.addContainerTransaction(ct);
        ejbJar.write(ejbModule.getDeploymentDescriptor());
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            JavaMetamodel.getManager().setClassPath(bFile);
            JMIUtils.fixImports((String)e.getEjbClass());
            JMIUtils.fixImports((String)e.getLocal());
            JMIUtils.fixImports((String)e.getLocalHome());
            JMIUtils.fixImports((String)e.getRemote());
            JMIUtils.fixImports((String)e.getHome());
            JMIUtils.fixImports((String)remoteBusinessIntfName);
            JMIUtils.fixImports((String)localBusinessIntfName);
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        JMIUtils.saveClass((String)e.getEjbClass(), (FileObject)bFile);
        JMIUtils.saveClass((String)e.getLocal(), (FileObject)bFile);
        JMIUtils.saveClass((String)e.getLocalHome(), (FileObject)bFile);
        JMIUtils.saveClass((String)e.getRemote(), (FileObject)bFile);
        JMIUtils.saveClass((String)e.getHome(), (FileObject)bFile);
        JMIUtils.saveClass((String)remoteBusinessIntfName, (FileObject)bFile);
        JMIUtils.saveClass((String)localBusinessIntfName, (FileObject)bFile);
        DataObject dobj = DataObject.find((FileObject)bFile);
        EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        ec.open();
    }

    private void populateCMP(Bean genData, Entity e) {
        genData.addCmField(true);
        genData.setCmFieldMethodName(0, "Key");
        genData.setCmFieldClassname(0, this.primaryKeyFQN);
        genData.addCmFieldName("key");
        e.setPersistenceType("Container");
        CmpField f = e.newCmpField();
        f.setFieldName(genData.getCmFieldName(0));
        e.addCmpField(f);
        e.setPrimkeyField(genData.getCmFieldName(0));
        e.setAbstractSchemaName(EjbGenerationUtil.getEjbNameBase(e.getEjbName()));
    }

    private void populateBMP(Entity e) {
        e.setPersistenceType("Bean");
    }

    protected org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method[] getPrimaryMethods(String local, String remote) {
        org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method find = new org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method();
        find.setName("findByPrimaryKey");
        if (local != null) {
            find.setLocalReturn(local);
        }
        if (remote != null) {
            find.setRemoteReturn(remote);
        }
        find.addParam(true);
        find.addParamName("key");
        find.addParamType(this.primaryKeyFQN);
        find.addException(true);
        find.addExceptionType("javax.ejb.FinderException");
        if (this.isCMP) {
            org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method create = new org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method();
            create.setName("create");
            if (local != null) {
                create.setLocalReturn(local);
            }
            if (remote != null) {
                create.setRemoteReturn(remote);
            }
            create.addParam(true);
            create.addParamName("key");
            create.addParamType(this.primaryKeyFQN);
            create.addException(true);
            create.addExceptionType("javax.ejb.CreateException");
            return new org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method[]{find, create};
        }
        return new org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Method[]{find};
    }

    public void setCMP(boolean cmp) {
        this.isCMP = cmp;
    }
}

