/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.FieldCustomizer;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddCmpFieldAction
extends NodeAction {
    private static final String NAME = NbBundle.getMessage(AddCmpFieldAction.class, (String)"LBL_AddCmpFieldAction");

    public String getName() {
        return NAME;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] activatedNodes) {
        EjbMethodController c;
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        JavaClass jc = JMIUtils.getJavaClassFromNode((Node)activatedNodes[0]);
        if (jc == null || jc instanceof UnresolvedClass) {
            return false;
        }
        return activatedNodes.length == 1 && this.isCallable(activatedNodes[0]) && (c = EjbMethodController.create((Feature)jc)) != null && c instanceof EntityMethodController && ((EntityMethodController)c).isCMP();
    }

    protected void performAction(Node[] activatedNodes) {
        JavaClass jc = JMIUtils.getJavaClassFromNode((Node)activatedNodes[0]);
        Field fe = AddCmpFieldAction.createField(jc);
        FileObject ddFile = this.getDDFile((Element)jc);
        EntityMethodController emc = (EntityMethodController)EjbMethodController.create((Feature)jc);
        AddCmpFieldAction.addCmpField(emc, ddFile, fe);
    }

    public static boolean addCmpField(JavaClass beanClass, FileObject ddFile) {
        assert (beanClass != null);
        Field fe = AddCmpFieldAction.createField(beanClass);
        EntityMethodController emc = (EntityMethodController)EntityMethodController.createFromClass(beanClass);
        return AddCmpFieldAction.addCmpField(emc, ddFile, fe);
    }

    private static Field createField(JavaClass jc) {
        return JMIUtils.createField((JavaClass)jc, (String)"cmpField", (String)"String");
    }

    private static boolean addCmpField(EntityMethodController emc, FileObject ddFile, Field fe) {
        FieldCustomizer customizer = new FieldCustomizer(fe, "", emc.getLocal() != null, emc.getRemote() != null, true, true, false, false);
        while (AddCmpFieldAction.openAddCmpFieldDialog(customizer)) {
            try {
                emc.validateNewCmpFieldName(fe.getName());
                emc.addField(fe, ddFile, customizer.isLocalGetter(), customizer.isLocalSetter(), customizer.isRemoteGetter(), customizer.isRemoteSetter(), customizer.getDescription());
                return true;
            }
            catch (IllegalArgumentException ex) {
                Utils.notifyError(ex);
            }
            catch (IOException ioe) {
                Utils.notifyError(ioe);
                return false;
            }
        }
        return false;
    }

    private static boolean openAddCmpFieldDialog(FieldCustomizer fc) {
        NotifyDescriptor nd = new NotifyDescriptor((Object)fc, NAME, 2, -1, null, null);
        if (DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.OK_OPTION) {
            return fc.isOK();
        }
        return false;
    }

    protected FileObject getDDFile(Element me) {
        DataObject dobj = JavaMetamodel.getManager().getDataObject(me.getResource());
        assert (dobj != null);
        FileObject fo = dobj.getPrimaryFile();
        return EjbJar.getEjbJar((FileObject)fo).getDeploymentDescriptor();
    }

    private boolean isCallable(Node node) {
        return JMIUtils.getJavaClassFromNode((Node)node) != null;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        boolean enable = this.enable(actionContext.lookup(new Lookup.Template(Node.class)).allInstances().toArray(new Node[0]));
        return enable ? super.createContextAwareInstance(actionContext) : null;
    }
}

