/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.beans.PropertyChangeEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentUpdater;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xam.dom.ReadOnlyAccess;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xam.spi.DocumentModelAccessProvider;
import org.openide.util.Lookup;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentModel<T extends DocumentComponent<T>>
extends AbstractModel<T>
implements DocumentModel<T> {
    protected DocumentModelAccess access;
    private boolean needsSync;
    private DocumentListener docListener = new DocumentChangeListener();
    private Document swingDocument;
    private Set<String> elementNames = null;

    public AbstractDocumentModel(ModelSource source) {
        super(source);
    }

    public Document getBaseDocument() {
        return (Document)this.getModelSource().getLookup().lookup(Document.class);
    }

    public abstract T createRootComponent(Element var1);

    @Override
    public boolean areSameNodes(Node n1, Node n2) {
        return this.getAccess().areSameNodes(n1, n2);
    }

    public Set<QName> getQNames() {
        return Collections.emptySet();
    }

    @Override
    protected boolean needsSync() {
        Document lastDoc = this.swingDocument;
        Document currentDoc = (Document)this.getModelSource().getLookup().lookup(Document.class);
        if (currentDoc == null) {
            this.swingDocument = null;
            return false;
        }
        if (lastDoc == null || currentDoc != lastDoc) {
            this.swingDocument = currentDoc;
            currentDoc.addDocumentListener(new WeakDocumentListener(this.docListener, currentDoc));
        }
        return this.needsSync || !currentDoc.equals(lastDoc);
    }

    @Override
    protected void syncStarted() {
        this.needsSync = false;
        this.getAccess().unsetDirty();
    }

    @Override
    protected synchronized void syncCompleted() {
        super.syncCompleted();
    }

    private synchronized void documentChanged() {
        if (!this.isIntransaction()) {
            this.getAccess().setDirty();
            this.needsSync = true;
        }
    }

    protected abstract ComponentUpdater<T> getComponentUpdater();

    public Set<String> getElementNames() {
        if (this.elementNames == null) {
            this.elementNames = new HashSet<String>();
            Set<QName> qnames = this.getQNames();
            for (QName q : qnames) {
                this.elementNames.add(q.getLocalPart());
            }
        }
        return this.elementNames;
    }

    public ChangeInfo prepareChangeInfo(List<Node> pathToRoot) {
        int i;
        assert (pathToRoot.size() > 0);
        if (pathToRoot.get(pathToRoot.size() - 1) instanceof org.w3c.dom.Document) {
            pathToRoot.remove(pathToRoot.size() - 1);
        }
        assert (pathToRoot.size() > 1);
        Node current = null;
        Element parent = null;
        boolean changedIsDomainElement = true;
        Set<QName> qnames = this.getQNames();
        Set<String> enames = this.getElementNames();
        if (qnames != null && qnames.size() > 0) {
            for (i = 0; i < pathToRoot.size(); ++i) {
                Node n = pathToRoot.get(i);
                if (!(n instanceof Element)) {
                    changedIsDomainElement = false;
                    continue;
                }
                QName q = new QName(n.getNamespaceURI(), n.getLocalName());
                if (qnames.contains(q) || enames.contains(q.getLocalPart())) {
                    current = n;
                    if (i + 1 < pathToRoot.size()) {
                        parent = (Element)pathToRoot.get(i + 1);
                    }
                    break;
                }
                if (!changedIsDomainElement) continue;
                changedIsDomainElement = false;
            }
        } else {
            Node n = pathToRoot.get(0);
            if (n instanceof Element) {
                current = n;
                parent = (Element)pathToRoot.get(1);
            } else {
                current = pathToRoot.get(1);
                if (pathToRoot.size() > 2) {
                    parent = (Element)pathToRoot.get(2);
                }
                changedIsDomainElement = false;
            }
        }
        if (!changedIsDomainElement) {
            i = pathToRoot.indexOf(current);
            assert (i > 0);
            parent = (Element)current;
            current = pathToRoot.get(i - 1);
        }
        List<Element> rootToParent = Collections.emptyList();
        if (parent != null) {
            rootToParent = new ArrayList<Element>(pathToRoot.size() - pathToRoot.indexOf(parent));
            for (int i2 = pathToRoot.indexOf(parent); i2 < pathToRoot.size(); ++i2) {
                rootToParent.add(0, (Element)pathToRoot.get(i2));
            }
        }
        return new ChangeInfo(parent, current, changedIsDomainElement, rootToParent);
    }

    public SyncUnit prepareSyncUnit(ChangeInfo change, SyncUnit order) {
        assert (change.getChangedNode() != null);
        AbstractDocumentComponent parentComponent = (AbstractDocumentComponent)change.getParentComponent();
        if (parentComponent == null) {
            parentComponent = (AbstractDocumentComponent)this.findComponent(change.getRootToParentPath());
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException("Could not find parent component");
        }
        DocumentComponent toRemove = null;
        DocumentComponent toAdd = null;
        boolean changed = false;
        if (change.isDomainElement()) {
            if (change.isDomainElementAdded()) {
                toAdd = this.createChildComponent(parentComponent, change.getChangedElement());
            } else {
                toRemove = (DocumentComponent)parentComponent.findChildComponent(change.getChangedElement());
                if (toRemove == null) {
                    parentComponent.findChildComponentByIdentity(change.getChangedElement());
                }
            }
        } else {
            changed = true;
        }
        if (order == null) {
            order = new SyncUnit(parentComponent);
        }
        order.addChange(change);
        if (toRemove != null) {
            order.addToRemoveList(toRemove);
        }
        if (toAdd != null) {
            order.addToAddList(toAdd);
        }
        if (changed) {
            order.setComponentChanged(true);
        }
        return order;
    }

    protected void firePropertyChangedEvents(SyncUnit unit) {
        HashSet<String> propertyNames = new HashSet<String>(unit.getRemovedAttributes().keySet());
        propertyNames.addAll(unit.getAddedAttributes().keySet());
        for (String name : propertyNames) {
            Attr oldAttr = unit.getRemovedAttributes().get(name);
            Attr newAttr = unit.getAddedAttributes().get(name);
            super.firePropertyChangeEvent(new PropertyChangeEvent(unit.getTarget(), name, oldAttr == null ? null : oldAttr.getValue(), newAttr == null ? null : newAttr.getValue()));
        }
    }

    public void processSyncUnit(SyncUnit syncOrder) {
        AbstractDocumentComponent targetComponent = (AbstractDocumentComponent)syncOrder.getTarget();
        assert (targetComponent != null);
        if (!targetComponent.isInDocumentModel()) {
            return;
        }
        syncOrder.updateTargetReference();
        if (syncOrder.isComponentChanged()) {
            ComponentEvent.EventType changeType = ComponentEvent.EventType.VALUE_CHANGED;
            this.fireComponentChangedEvent(new ComponentEvent(targetComponent, changeType));
            this.firePropertyChangedEvents(syncOrder);
        }
        for (DocumentComponent c : syncOrder.getToRemoveList()) {
            this.removeChildComponent(c);
        }
        for (DocumentComponent c : syncOrder.getToAddList()) {
            Element childElement = ((AbstractDocumentComponent)c).getPeer();
            int index = targetComponent.findDomainIndex(childElement);
            this.addChildComponent(targetComponent, c, index);
        }
    }

    private DocumentComponent createChildComponent(DocumentComponent parent, Element e) {
        DocumentModel m = (DocumentModel)parent.getModel();
        assert (m != null) : "Cannot create child component from a deleted component.";
        return m.createComponent(parent, e);
    }

    @Override
    public void addChildComponent(Component target, Component child, int index) {
        AbstractDocumentModel m = (AbstractDocumentModel)target.getModel();
        if (m == null) {
            return;
        }
        m.getComponentUpdater().update(target, child, index, ComponentUpdater.Operation.ADD);
    }

    @Override
    public void removeChildComponent(Component child) {
        if (child.getParent() == null) {
            return;
        }
        AbstractDocumentModel m = (AbstractDocumentModel)child.getParent().getModel();
        if (m == null) {
            return;
        }
        m.getComponentUpdater().update(child.getParent(), child, ComponentUpdater.Operation.REMOVE);
    }

    public DocumentComponent findComponent(Element e) {
        return this.findComponent((AbstractDocumentComponent)this.getRootComponent(), e);
    }

    private DocumentComponent findComponent(DocumentComponent searchRoot, Element e) {
        if (searchRoot.referencesSameNode(e)) {
            return searchRoot;
        }
        for (Object o : searchRoot.getChildren()) {
            DocumentComponent found = this.findComponent((DocumentComponent)o, e);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public DocumentComponent findComponent(List<Element> pathFromRoot) {
        return this.findComponent((AbstractDocumentComponent)this.getRootComponent(), pathFromRoot, 0);
    }

    public AbstractDocumentComponent findComponent(AbstractDocumentComponent base, List<Element> pathFromRoot, int current) {
        if (pathFromRoot == null || pathFromRoot.size() <= current) {
            return null;
        }
        Element e = pathFromRoot.get(current);
        if (base.referencesSameNode(e)) {
            if (pathFromRoot.size() == current + 1) {
                base.getChildren();
                return base;
            }
            for (Object child : base.getChildren()) {
                AbstractDocumentComponent ac = (AbstractDocumentComponent)child;
                AbstractDocumentComponent found = this.findComponent(ac, pathFromRoot, current + 1);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public DocumentComponent findComponent(int position) {
        if (this.getState() != Model.State.VALID) {
            return this.getRootComponent();
        }
        Element e = this.getAccess().getContainingElement(position);
        if (e == null) {
            return this.getRootComponent();
        }
        List<Element> pathFromRoot = null;
        try {
            pathFromRoot = this.getAccess().getPathFromRoot(this.getDocument(), e);
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        if (pathFromRoot == null || pathFromRoot.isEmpty()) {
            return this.findComponent(e);
        }
        return this.findComponent(pathFromRoot);
    }

    @Override
    public String getXPathExpression(DocumentComponent component) {
        Element e = component.getPeer();
        return this.getAccess().getXPath(this.getDocument(), e);
    }

    @Override
    public org.w3c.dom.Document getDocument() {
        return this.getAccess().getDocumentRoot();
    }

    @Override
    public DocumentModelAccess getAccess() {
        if (this.access == null) {
            this.access = this.getEffectiveAccessProvider().createModelAccess(this);
            if (!(this.access instanceof ReadOnlyAccess)) {
                this.access.addUndoableEditListener(this);
                this.setIdentifyingAttributes();
            }
        }
        return this.access;
    }

    private DocumentModelAccessProvider getEffectiveAccessProvider() {
        DocumentModelAccessProvider p = (DocumentModelAccessProvider)this.getModelSource().getLookup().lookup(DocumentModelAccessProvider.class);
        return p == null ? AbstractDocumentModel.getAccessProvider() : p;
    }

    public static DocumentModelAccessProvider getAccessProvider() {
        DocumentModelAccessProvider provider = (DocumentModelAccessProvider)Lookup.getDefault().lookup(DocumentModelAccessProvider.class);
        if (provider == null) {
            return ReadOnlyAccess.Provider.getInstance();
        }
        return provider;
    }

    protected void setIdentifyingAttributes() {
        ElementIdentity eid = this.getAccess().getElementIdentity();
        eid.addIdentifier("id");
        eid.addIdentifier("name");
        eid.addIdentifier("ref");
    }

    protected boolean isDomainElement(Node e) {
        if (!(e instanceof Element)) {
            return false;
        }
        QName q = new QName(e.getNamespaceURI(), e.getLocalName());
        return this.getQNames().contains(q) || this.getElementNames().contains(q.getLocalPart());
    }

    @Override
    protected void refresh() {
        org.w3c.dom.Document lastStable = null;
        try {
            lastStable = this.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lastStable != null) {
            this.createRootComponent(lastStable.getDocumentElement());
            this.setState(Model.State.VALID);
        }
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        public void removeUpdate(DocumentEvent e) {
            AbstractDocumentModel.this.documentChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            AbstractDocumentModel.this.documentChanged();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private static class WeakDocumentListener
    implements DocumentListener {
        private Document source;
        private WeakReference<DocumentListener> delegate;

        public WeakDocumentListener(DocumentListener delegate, Document source) {
            this.source = source;
            this.delegate = new WeakReference<DocumentListener>(delegate);
        }

        private DocumentListener getDelegate() {
            DocumentListener l = (DocumentListener)this.delegate.get();
            if (l == null) {
                this.source.removeDocumentListener(this);
            }
            return l;
        }

        public void removeUpdate(DocumentEvent e) {
            DocumentListener l = this.getDelegate();
            if (l != null) {
                l.removeUpdate(e);
            }
        }

        public void changedUpdate(DocumentEvent e) {
            DocumentListener l = this.getDelegate();
            if (l != null) {
                l.changedUpdate(e);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            DocumentListener l = this.getDelegate();
            if (l != null) {
                l.insertUpdate(e);
            }
        }
    }
}

