/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class DimensionCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final long serialVersionUID = 3718340148720193844L;
    private JPanel insidePanel;
    private JLabel jLabel1;
    private JLabel widthLabel;
    private JTextField widthField;
    private JLabel heightLabel;
    private JTextField heightField;
    private DimensionEditor editor;

    public DimensionCustomEditor(DimensionEditor editor) {
        this.initComponents();
        this.editor = editor;
        Dimension dimension = (Dimension)editor.getValue();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        this.jLabel1.setText(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_Dimension"));
        this.widthLabel.setText(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_Width"));
        this.widthLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_Width_mnemonic").charAt(0));
        this.widthLabel.setLabelFor(this.widthField);
        this.heightLabel.setText(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_Height"));
        this.heightLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_Height_mnemonic").charAt(0));
        this.heightLabel.setLabelFor(this.heightField);
        this.widthField.setText("" + dimension.width);
        this.heightField.setText("" + dimension.height);
        this.widthField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"ACSD_CTL_Width"));
        this.heightField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"ACSD_CTL_Height"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"ACSD_DimensionCustomEditor"));
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            int width = Integer.parseInt(this.widthField.getText());
            int height = Integer.parseInt(this.heightField.getText());
            if (width < 0 || height < 0) {
                IllegalStateException ise = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)ise, 65536, null, NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_NegativeSize"), null, null);
                throw ise;
            }
            return new Dimension(width, height);
        }
        catch (NumberFormatException e) {
            IllegalStateException ise = new IllegalStateException();
            ErrorManager.getDefault().annotate((Throwable)ise, 65536, null, NbBundle.getMessage((Class)DimensionCustomEditor.class, (String)"CTL_InvalidValue"), null, null);
            throw ise;
        }
    }

    private void initComponents() {
        this.insidePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.insidePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("jLabel1");
        this.jLabel1.setLabelFor(this.insidePanel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(12, 12, 0, 0);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        this.insidePanel.add((Component)this.jLabel1, gridBagConstraints2);
        this.widthLabel.setText("jLabel2");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(12, 17, 0, 0);
        gridBagConstraints2.anchor = 18;
        this.insidePanel.add((Component)this.widthLabel, gridBagConstraints2);
        this.widthField.setColumns(5);
        this.widthField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DimensionCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(12, 5, 0, 12);
        gridBagConstraints2.anchor = 18;
        this.insidePanel.add((Component)this.widthField, gridBagConstraints2);
        this.heightLabel.setText("jLabel3");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 17, 0, 0);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weighty = 1.0;
        this.insidePanel.add((Component)this.heightLabel, gridBagConstraints2);
        this.heightField.setColumns(5);
        this.heightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DimensionCustomEditor.this.updateInsets(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 12);
        gridBagConstraints2.anchor = 18;
        this.insidePanel.add((Component)this.heightField, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.insidePanel, gridBagConstraints1);
    }

    private void updateInsets(ActionEvent evt) {
        try {
            int width = Integer.parseInt(this.widthField.getText());
            int height = Integer.parseInt(this.heightField.getText());
            this.editor.setValue(new Dimension(width, height));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

