/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.netbeans.modules.editor.settings.storage.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.FontColorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyBindingSettingsImpl;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.FontColorSettingsFactory;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class EditorSettingsImpl
extends EditorSettings {
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    static final String HIGHLIGHTING_FILE_NAME = "editorColoring.xml";
    static final String KEYBINDING_FILE_NAME = "keybindings.xml";
    static final String ALL_LANGUAGES_FILE_NAME = "defaultColoring.xml";
    static final String CURRENT_FONT_COLOR_PROFILE = "currentFontColorProfile";
    static final String CURRENT_KEYMAP_PROFILE = "currentKeymap";
    static final String KEYMAPS_FOLDER = "Keymaps";
    private Set systemFontColorProfiles;
    private String currentFontColorProfile;
    private Map defaultColors = new HashMap();
    private Map defaultColorDefaults = new HashMap();
    private Map highlightings = new HashMap();
    private Map highlightingDefaults = new HashMap();
    private Set systemKeymapProfiles;
    private String currentKeyMapProfile;
    private Map fontColorProfiles;
    private Map keyMapProfiles;
    private Map mimeToLanguage;
    private Map keyBindingsMap = new HashMap();
    private Map fontColorsMap = new HashMap();

    public Set getMimeTypes() {
        if (this.mimeToLanguage == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.mimeToLanguage.keySet());
    }

    public String getLanguageName(String mimeType) {
        if (this.mimeToLanguage == null) {
            this.init();
        }
        return (String)this.mimeToLanguage.get(mimeType);
    }

    public Set getFontColorProfiles() {
        if (this.fontColorProfiles == null) {
            this.init();
        }
        HashSet<String> result = new HashSet<String>();
        Iterator it = this.fontColorProfiles.keySet().iterator();
        while (it.hasNext()) {
            String profile = (String)it.next();
            if (profile.startsWith("test")) continue;
            result.add(profile);
        }
        return result;
    }

    public boolean isCustomFontColorProfile(String profile) {
        if (this.systemFontColorProfiles == null) {
            this.init();
        }
        return !this.systemFontColorProfiles.contains(profile);
    }

    public String getCurrentFontColorProfile() {
        if (this.currentFontColorProfile == null) {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource("Editors");
            this.currentFontColorProfile = (String)fo.getAttribute(CURRENT_FONT_COLOR_PROFILE);
            if (this.currentFontColorProfile == null) {
                this.currentFontColorProfile = "NetBeans";
            }
        }
        if (!this.getFontColorProfiles().contains(this.currentFontColorProfile)) {
            this.currentFontColorProfile = "NetBeans";
        }
        return this.currentFontColorProfile;
    }

    public void setCurrentFontColorProfile(String profile) {
        String oldProfile = this.getCurrentFontColorProfile();
        if (oldProfile.equals(profile)) {
            return;
        }
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Editors");
        try {
            fo.setAttribute(CURRENT_FONT_COLOR_PROFILE, (Object)profile);
            this.currentFontColorProfile = profile;
            this.pcs.firePropertyChange(CURRENT_FONT_COLOR_PROFILE, oldProfile, this.currentFontColorProfile);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public Collection getDefaultFontColors(String profile) {
        if (!this.defaultColors.containsKey(profile = this.getInternalFontColorProfile(profile))) {
            if (profile.startsWith("test")) {
                this.defaultColors.put(profile, this.getDefaultFontColors("NetBeans"));
            } else {
                Map m = ColoringStorage.loadColorings(new String[0], profile, ALL_LANGUAGES_FILE_NAME, false);
                if (m != null) {
                    Collection c = m.values();
                    this.defaultColors.put(profile, c);
                } else {
                    this.defaultColors.put(profile, null);
                }
            }
        }
        if (this.defaultColors.get(profile) == null) {
            return null;
        }
        return Collections.unmodifiableCollection((Collection)this.defaultColors.get(profile));
    }

    public Collection getDefaultFontColorDefaults(String profile) {
        if (!this.defaultColorDefaults.containsKey(profile = this.getInternalFontColorProfile(profile))) {
            Map m = ColoringStorage.loadColorings(new String[0], profile, ALL_LANGUAGES_FILE_NAME, true);
            if (m != null) {
                Collection c = m.values();
                this.defaultColorDefaults.put(profile, c);
            } else {
                this.defaultColorDefaults.put(profile, null);
            }
        }
        if (this.defaultColorDefaults.get(profile) == null) {
            return null;
        }
        return Collections.unmodifiableCollection((Collection)this.defaultColorDefaults.get(profile));
    }

    public void setDefaultFontColors(String profile, Collection fontColors) {
        String internalProfile = this.getInternalFontColorProfile(profile);
        if (fontColors == null) {
            ColoringStorage.deleteColorings(new String[0], internalProfile, ALL_LANGUAGES_FILE_NAME);
            this.defaultColors.remove(internalProfile);
            this.init();
            this.pcs.firePropertyChange("defaultFontColors", null, null);
            return;
        }
        if (((Object)fontColors).equals(this.defaultColors.get(internalProfile))) {
            return;
        }
        this.defaultColors.put(internalProfile, fontColors);
        if (!internalProfile.startsWith("test")) {
            ColoringStorage.saveColorings(new String[0], internalProfile, ALL_LANGUAGES_FILE_NAME, fontColors);
            if (this.fontColorProfiles.get(profile) == null) {
                this.fontColorProfiles.put(profile, profile);
            }
        }
        if (internalProfile.startsWith("test")) {
            this.pcs.firePropertyChange(internalProfile, null, null);
        } else {
            this.pcs.firePropertyChange("defaultFontColors", null, null);
        }
    }

    public Map getHighlightings(String profile) {
        if (!this.highlightings.containsKey(profile = this.getInternalFontColorProfile(profile))) {
            if (profile.startsWith("test")) {
                this.highlightings.put(profile, this.getHighlightings("NetBeans"));
            } else {
                Map m = ColoringStorage.loadColorings(new String[0], profile, HIGHLIGHTING_FILE_NAME, false);
                this.highlightings.put(profile, m);
            }
        }
        if (this.highlightings.get(profile) == null) {
            return null;
        }
        return Collections.unmodifiableMap((Map)this.highlightings.get(profile));
    }

    public Map getHighlightingDefaults(String profile) {
        if (!this.highlightingDefaults.containsKey(profile = this.getInternalFontColorProfile(profile))) {
            Map m = ColoringStorage.loadColorings(new String[0], profile, HIGHLIGHTING_FILE_NAME, true);
            this.highlightingDefaults.put(profile, m);
        }
        if (this.highlightingDefaults.get(profile) == null) {
            return null;
        }
        return Collections.unmodifiableMap((Map)this.highlightingDefaults.get(profile));
    }

    public void setHighlightings(String profile, Map fontColors) {
        String internalProfile = this.getInternalFontColorProfile(profile);
        if (fontColors == null) {
            ColoringStorage.deleteColorings(new String[0], internalProfile, HIGHLIGHTING_FILE_NAME);
            this.highlightings.remove(internalProfile);
            this.init();
            this.pcs.firePropertyChange("editorFontColors", null, null);
            return;
        }
        if (((Object)fontColors).equals(this.highlightings.get(internalProfile))) {
            return;
        }
        this.highlightings.put(internalProfile, fontColors);
        if (!internalProfile.startsWith("test")) {
            ColoringStorage.saveColorings(new String[0], internalProfile, HIGHLIGHTING_FILE_NAME, fontColors.values());
            if (this.fontColorProfiles.get(profile) == null) {
                this.fontColorProfiles.put(profile, profile);
            }
        }
        if (internalProfile.startsWith("test")) {
            this.pcs.firePropertyChange(internalProfile, null, null);
        } else {
            this.pcs.firePropertyChange("editorFontColors", null, null);
        }
    }

    public Set getKeyMapProfiles() {
        if (this.keyMapProfiles == null) {
            this.init();
        }
        return Collections.unmodifiableSet(this.keyMapProfiles.keySet());
    }

    public boolean isCustomKeymapProfile(String profile) {
        if (this.systemKeymapProfiles == null) {
            this.init();
        }
        return !this.systemKeymapProfiles.contains(profile);
    }

    public String getCurrentKeyMapProfile() {
        if (this.currentKeyMapProfile == null) {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(KEYMAPS_FOLDER);
            this.currentKeyMapProfile = (String)fo.getAttribute(CURRENT_KEYMAP_PROFILE);
            if (this.currentKeyMapProfile == null) {
                this.currentKeyMapProfile = "NetBeans";
            }
        }
        return this.currentKeyMapProfile;
    }

    public void setCurrentKeyMapProfile(String keyMapName) {
        String oldKeyMap = this.getCurrentKeyMapProfile();
        if (oldKeyMap.equals(keyMapName)) {
            return;
        }
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = fs.findResource(KEYMAPS_FOLDER);
            if (fo == null) {
                fo = fs.getRoot().createFolder(KEYMAPS_FOLDER);
            }
            fo.setAttribute(CURRENT_KEYMAP_PROFILE, (Object)keyMapName);
            this.currentKeyMapProfile = keyMapName;
            this.pcs.firePropertyChange("currentKeyMapProfile", oldKeyMap, this.currentKeyMapProfile);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    private void init() {
        this.fontColorProfiles = new HashMap();
        this.keyMapProfiles = new HashMap();
        this.keyMapProfiles.put("NetBeans", "NetBeans");
        this.mimeToLanguage = new HashMap();
        this.systemFontColorProfiles = new HashSet();
        this.systemKeymapProfiles = new HashSet();
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Editors");
        Enumeration e = fo.getFolders(false);
        while (e.hasMoreElements()) {
            this.init1((FileObject)e.nextElement());
        }
    }

    private void init1(FileObject fo) {
        Enumeration e = fo.getChildren(false);
        while (e.hasMoreElements()) {
            this.init2((FileObject)e.nextElement());
        }
    }

    private void init2(FileObject fo) {
        if (fo.getNameExt().equals("Defaults") && fo.isFolder() && fo.getFileObject(HIGHLIGHTING_FILE_NAME) != null) {
            this.addFontColorsProfile(fo, true);
        } else if (fo.getNameExt().equals(HIGHLIGHTING_FILE_NAME)) {
            this.addFontColorsProfile(fo, false);
        } else if (fo.getFileObject("NetBeans/Defaults/coloring.xml") != null) {
            this.addMimeType(fo);
        } else if (fo.getPath().endsWith("text/base") && fo.isFolder()) {
            if (fo.getFileObject("Defaults/keybindings.xml") != null) {
                this.addKeyMapProfile(fo, true);
            } else if (fo.getFileObject(KEYBINDING_FILE_NAME) != null) {
                this.addKeyMapProfile(fo, false);
            }
            Enumeration e = fo.getChildren(false);
            while (e.hasMoreElements()) {
                this.init3((FileObject)e.nextElement());
            }
        }
    }

    private void init3(FileObject fo) {
        if (fo.getFileObject("Defaults/keybindings.xml") != null) {
            this.addKeyMapProfile(fo, true);
        } else if (fo.getFileObject(KEYBINDING_FILE_NAME) != null) {
            this.addKeyMapProfile(fo, false);
        }
    }

    private void addMimeType(FileObject fo) {
        String mimeType = fo.getPath();
        mimeType = mimeType.substring(8);
        String bundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
        String languageName = mimeType;
        if (bundleName != null) {
            try {
                languageName = NbBundle.getBundle((String)bundleName).getString(mimeType);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        this.mimeToLanguage.put(mimeType, languageName);
    }

    private void addFontColorsProfile(FileObject fo, boolean systemProfile) {
        String profile = fo.getParent().getNameExt();
        String bundleName = (String)fo.getParent().getAttribute("SystemFileSystem.localizingBundle");
        String locProfile = profile;
        if (bundleName != null) {
            try {
                locProfile = NbBundle.getBundle((String)bundleName).getString(profile);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        if (systemProfile) {
            this.systemFontColorProfiles.add(locProfile);
        }
        this.fontColorProfiles.put(locProfile, profile);
    }

    private void addKeyMapProfile(FileObject fo, boolean systemProfile) {
        String profile = fo.getNameExt();
        if (profile.equals("base")) {
            profile = "NetBeans";
        }
        String bundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle");
        String locProfile = profile;
        if (bundleName != null) {
            try {
                locProfile = NbBundle.getBundle((String)bundleName).getString(profile);
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        if (systemProfile) {
            this.systemKeymapProfiles.add(locProfile);
        }
        this.keyMapProfiles.put(locProfile, profile);
    }

    String getInternalFontColorProfile(String profile) {
        String result;
        if (this.fontColorProfiles == null) {
            this.init();
        }
        if ((result = (String)this.fontColorProfiles.get(profile)) != null) {
            return result;
        }
        return profile;
    }

    String getInternalKeymapProfile(String profile) {
        String result;
        if (this.keyMapProfiles == null) {
            this.init();
        }
        if ((result = (String)this.keyMapProfiles.get(profile)) != null) {
            return result;
        }
        this.keyMapProfiles.put(profile, profile);
        return profile;
    }

    public KeyBindingSettingsFactory getKeyBindingSettings(String[] mimeTypes) {
        List<String> key = Arrays.asList(mimeTypes);
        WeakReference reference = (WeakReference)this.keyBindingsMap.get(key);
        KeyBindingSettingsImpl result = null;
        if (reference != null) {
            result = (KeyBindingSettingsImpl)reference.get();
        }
        if (result == null) {
            result = new KeyBindingSettingsImpl(mimeTypes);
            this.keyBindingsMap.put(key, new WeakReference<KeyBindingSettingsImpl>(result));
        }
        return result;
    }

    public FontColorSettingsFactory getFontColorSettings(String[] mimeTypes) {
        List<String> key = Arrays.asList(mimeTypes);
        WeakReference reference = (WeakReference)this.fontColorsMap.get(key);
        FontColorSettingsFactory result = null;
        if (reference != null) {
            result = (FontColorSettingsFactory)reference.get();
        }
        if (result == null) {
            result = new FontColorSettingsImpl(mimeTypes);
            this.fontColorsMap.put(key, new WeakReference<FontColorSettingsFactory>(result));
        }
        return result;
    }
}

