/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityAssociationResolver {
    private JavaClass entity;
    private List<JavaClass> allEntities;
    private static final List<String> ANNOTATIONS = Arrays.asList("OneToOne", "OneToMany", "ManyToOne", "ManyToMany");
    private static final String MAPPED_BY = "mappedBy";
    private static final String TARGET_ENTITY = "targetEntity";

    public EntityAssociationResolver(JavaClass entity, List<JavaClass> allEntities) {
        assert (entity != null);
        assert (allEntities != null);
        this.entity = entity;
        this.allEntities = allEntities;
    }

    public List<EntityAnnotationReference> getMappedByReferences(Feature property) {
        if (!(property instanceof Method) && !(property instanceof Field)) {
            return Collections.emptyList();
        }
        JavaClass reference = this.findReferencesOfType(this.resolveType(property));
        if (reference == null) {
            return Collections.emptyList();
        }
        return this.getReferences(reference, MAPPED_BY, Utility.getPropertyName(property.getName()));
    }

    private List<Annotation> getFeatureAnnotations(JavaClass javaClass) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Object elem : javaClass.getFeatures()) {
            Feature feature = (Feature)elem;
            for (Object elem2 : feature.getAnnotations()) {
                Annotation annotation = (Annotation)elem2;
                result.add(annotation);
            }
        }
        return result;
    }

    private String resolveType(Feature feature) {
        ParameterizedType parametrizedType;
        List list;
        Type returnType = null;
        if (feature instanceof Method) {
            Method method = (Method)feature;
            returnType = method.getType();
        } else if (feature instanceof Field) {
            Field field = (Field)feature;
            returnType = field.getType();
        }
        if (returnType instanceof ParameterizedType && !(list = (parametrizedType = (ParameterizedType)returnType).getParameters()).isEmpty()) {
            returnType = (Type)list.get(0);
        }
        return returnType != null ? returnType.getName() : null;
    }

    private List<EntityAnnotationReference> getReferences(JavaClass javaClass, String annotationElementName, String propertyName) {
        ArrayList<EntityAnnotationReference> result = new ArrayList<EntityAnnotationReference>();
        for (Object elem : javaClass.getFeatures()) {
            Feature feature = (Feature)elem;
            if (!this.entity.getName().equals(this.resolveType(feature))) continue;
            for (Object elem2 : feature.getAnnotations()) {
                Annotation annotation = (Annotation)elem2;
                if (!ANNOTATIONS.contains(annotation.getTypeName().getName())) continue;
                for (Object elem3 : annotation.getAttributeValues()) {
                    AttributeValue attributeValue = (AttributeValue)elem3;
                    if (!attributeValue.getName().equals(annotationElementName) || !propertyName.equals(this.getStringValue(attributeValue))) continue;
                    result.add(new EntityAnnotationReference(this.entity, javaClass, feature, annotation, attributeValue));
                }
            }
        }
        return result;
    }

    private String getStringValue(AttributeValue attributeValue) {
        return ((StringLiteral)attributeValue.getValue()).getValue();
    }

    private JavaClass findReferencesOfType(String clazz) {
        for (JavaClass each : this.allEntities) {
            if (!each.getName().equals(clazz)) continue;
            return each;
        }
        return null;
    }
}

