/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.safedelete.BaseRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbClassSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbCmpFieldSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbMethodSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EjbQueryMethodSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.EntitySafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.JaxWsXmlSafeDeleteRafactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.PersistenceXmlSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.SunJaxWsXmlSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.TldClassSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.WebXmlSafeDeleteRefactoring;
import org.netbeans.modules.j2ee.refactoring.safedelete.WebservicesXmlSafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class J2EESafeDeleteRefactoringPlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private static ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.safedelete");
    private List refactorings = new LinkedList();
    private SafeDeleteRefactoring safeDeleteRefactoring;
    private Taglib taglib = null;

    public J2EESafeDeleteRefactoringPlugin(AbstractRefactoring refactoring) {
        this.safeDeleteRefactoring = (SafeDeleteRefactoring)refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                Element elem;
                this.prepareRefactorings();
                for (J2EERefactoring refactoring : this.refactorings) {
                    problem = Utility.addProblemsToEnd(problem, refactoring.preCheck());
                }
                if (this.safeDeleteRefactoring.getElementsToDelete().length > 0 && Utility.isEjb30((RefObject)(elem = this.safeDeleteRefactoring.getElementsToDelete()[0])) && Utility.hasEjbJar((RefObject)elem)) {
                    Problem ejbJarProblem = new Problem(false, NbBundle.getMessage(J2EESafeDeleteRefactoringPlugin.class, (String)"TXT_EjbJarSafeDeleteWarning"));
                    problem = Utility.addProblemsToEnd(problem, ejbJarProblem);
                }
            }
            finally {
                semafor.set(null);
            }
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem fastCheckParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                for (J2EERefactoring refactoring : this.refactorings) {
                    problem = Utility.addProblemsToEnd(problem, refactoring.fastCheckParameters());
                }
            }
            finally {
                semafor.set(null);
            }
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                for (J2EERefactoring refactoring : this.refactorings) {
                    problem = Utility.addProblemsToEnd(problem, refactoring.checkParameters());
                }
            }
            finally {
                semafor.set(null);
            }
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (semafor.get() == null) {
            semafor.set(new Object());
            try {
                for (J2EERefactoring refactoring : this.refactorings) {
                    problem = Utility.addProblemsToEnd(problem, refactoring.prepare(refactoringElements));
                }
            }
            finally {
                semafor.set(null);
            }
        }
        return problem;
    }

    public void cancelRequest() {
    }

    private void prepareRefactorings() {
        this.refactorings.clear();
        Element[] elementsToDelete = this.safeDeleteRefactoring.getElementsToDelete();
        for (int i = 0; i < elementsToDelete.length; ++i) {
            Collection webModules;
            Iterator wmIter;
            Element element = elementsToDelete[i];
            this.preparePersistenceRefactoring(element);
            this.prepareJaxWsRefactoring(element);
            this.prepareSunJaxWsRefactoring(element);
            this.prepareEntityRefactoring(element);
            this.prepareWebXmlRefactoring(element);
            this.prepareWebservicesRefactoring(element);
            if (!Utility.isEjb30((RefObject)element)) {
                FileObject ejbJarFileObject = Utility.getEjbJarFileObject(element);
                EjbJar ejbJar = Utility.getEjbJar(Utility.getApiEjbJar(element));
                if (ejbJar != null) {
                    BaseRefactoring.EjbHelper helper = new BaseRefactoring.EjbHelper((AbstractRefactoring)this.safeDeleteRefactoring, ejbJarFileObject, ejbJar);
                    this.prepareRefactoring(helper, element);
                }
            }
            if ((wmIter = (webModules = Utility.getRelevantWebModules(element)).iterator()) == null) continue;
            while (wmIter.hasNext()) {
                WebModule wm = (WebModule)wmIter.next();
                if (wm == null) continue;
                FileObject webInf = wm.getWebInf();
                Enumeration e = null;
                if (webInf != null) {
                    e = webInf.getChildren(true);
                }
                if (e == null) continue;
                while (e.hasMoreElements()) {
                    FileObject tld = (FileObject)e.nextElement();
                    if (!this.isTld(tld)) continue;
                    DataObject tldData = null;
                    try {
                        tldData = DataObject.find((FileObject)tld);
                    }
                    catch (DataObjectNotFoundException dne) {
                        // empty catch block
                    }
                    if (tldData == null || !(tldData instanceof TLDDataObject)) continue;
                    try {
                        this.taglib = ((TLDDataObject)tldData).getTaglib();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (this.taglib == null) continue;
                    BaseRefactoring.TldHelper helper = new BaseRefactoring.TldHelper((AbstractRefactoring)this.safeDeleteRefactoring, tld, this.taglib);
                    this.prepareRefactoring(helper, element);
                }
            }
        }
    }

    private boolean isTld(FileObject fo) {
        String ext;
        boolean isTld = false;
        if (fo != null && "tld".equalsIgnoreCase(ext = fo.getExt())) {
            isTld = true;
        }
        return isTld;
    }

    private void prepareRefactoring(BaseRefactoring.EjbHelper helper, Element element) {
        if (element instanceof Method) {
            this.prepareMethodRefactoring(helper, (Method)element);
        } else if (element instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)element;
            Ejb ejb = Utility.getEjb(helper.getEjbJar(), (ClassDefinition)javaClass);
            if (ejb != null) {
                this.refactorings.add(new EjbClassSafeDeleteRefactoring(helper, ejb, javaClass));
            }
        } else {
            ErrorManager.getDefault().log(1, "Safe Delete - Unknown Element: " + element);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareRefactoring(BaseRefactoring.TldHelper helper, Element element) {
        if (element instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)element;
            if (this.taglib == null) return;
            this.refactorings.add(new TldClassSafeDeleteRefactoring(helper, this.taglib, javaClass));
            return;
        } else {
            if (element instanceof Resource) {
                List classes = ((Resource)element).getClassifiers();
                if (classes == null) return;
            }
            ErrorManager.getDefault().log(1, "Safe Delete - Unknown Element: " + element);
        }
    }

    private void prepareMethodRefactoring(BaseRefactoring.EjbHelper helper, Method method) {
        Ejb ejb = Utility.getEjb(helper.getEjbJar(), method.getDeclaringClass());
        if (ejb != null) {
            if (ejb instanceof Entity) {
                Entity entity = (Entity)ejb;
                if (this.checkCmpFields(helper, entity, method)) {
                    return;
                }
                if (this.checkQueries(helper, entity, method)) {
                    return;
                }
            }
            this.refactorings.add(new EjbMethodSafeDeleteRefactoring(helper, method));
        }
    }

    private void preparePersistenceRefactoring(Element element) {
        if (!(element instanceof JavaClass)) {
            return;
        }
        PersistenceXmlSafeDeleteRefactoring refactoring = new PersistenceXmlSafeDeleteRefactoring(element, this.safeDeleteRefactoring);
        this.refactorings.add(refactoring);
    }

    private void prepareWebservicesRefactoring(Element element) {
        if (!(element instanceof JavaClass)) {
            return;
        }
        WebservicesXmlSafeDeleteRefactoring refactoring = new WebservicesXmlSafeDeleteRefactoring(element, this.safeDeleteRefactoring);
        this.refactorings.add(refactoring);
    }

    private void prepareJaxWsRefactoring(Element element) {
        if (!(element instanceof JavaClass)) {
            return;
        }
        JaxWsXmlSafeDeleteRafactoring refactoring = new JaxWsXmlSafeDeleteRafactoring((JavaClass)element);
        this.refactorings.add(refactoring);
    }

    private void prepareSunJaxWsRefactoring(Element element) {
        if (!(element instanceof JavaClass)) {
            return;
        }
        SunJaxWsXmlSafeDeleteRefactoring refactoring = new SunJaxWsXmlSafeDeleteRefactoring((JavaClass)element);
        this.refactorings.add(refactoring);
    }

    private void prepareEntityRefactoring(Element element) {
        if (!(element instanceof Feature)) {
            return;
        }
        Feature feature = (Feature)element;
        JavaClass javaClass = (JavaClass)feature.getDeclaringClass();
        if (!PersistenceRefactoringUtil.isEntity((AnnotableElement)javaClass)) {
            return;
        }
        EntitySafeDeleteRefactoring refactoring = new EntitySafeDeleteRefactoring(javaClass, feature, this.safeDeleteRefactoring);
        this.refactorings.add(refactoring);
    }

    private void prepareWebXmlRefactoring(Element element) {
        if (!(element instanceof JavaClass)) {
            return;
        }
        WebXmlSafeDeleteRefactoring refactoring = new WebXmlSafeDeleteRefactoring(this.safeDeleteRefactoring, (JavaClass)element);
        this.refactorings.add(refactoring);
    }

    private boolean checkCmpFields(BaseRefactoring.EjbHelper helper, Entity entity, Method method) {
        String fieldName = Utility.getFieldName(method);
        if (fieldName != null) {
            CmpField[] cmpField = entity.getCmpField();
            for (int i = 0; i < cmpField.length; ++i) {
                CmpField field = cmpField[i];
                if (!fieldName.equals(field.getFieldName())) continue;
                Collection accessMethods = Utility.getAccessMethods(entity, fieldName);
                if (!accessMethods.remove(method)) break;
                Method[] additionalMethods = new Method[accessMethods.size()];
                accessMethods.toArray(additionalMethods);
                EjbCmpFieldSafeDeleteRefactoring refactoring = new EjbCmpFieldSafeDeleteRefactoring(helper, entity, field);
                refactoring.addChildRefactoring((AbstractRefactoring)new SafeDeleteRefactoring((Element[])additionalMethods));
                this.refactorings.add(refactoring);
                return true;
            }
        }
        return false;
    }

    private boolean checkQueries(BaseRefactoring.EjbHelper helper, Entity entity, Method method) {
        String methodName = method.getName();
        Query[] queries = entity.getQuery();
        for (int i = 0; i < queries.length; ++i) {
            Query query = queries[i];
            if (!methodName.equals(query.getQueryMethod().getMethodName())) continue;
            Collection queryMethods = Utility.getQueryMethods(entity, query);
            if (!queryMethods.remove(method)) break;
            Method[] additionalMethods = new Method[queryMethods.size()];
            queryMethods.toArray(additionalMethods);
            EjbQueryMethodSafeDeleteRefactoring refactoring = new EjbQueryMethodSafeDeleteRefactoring(helper, entity, query);
            refactoring.addChildRefactoring((AbstractRefactoring)new SafeDeleteRefactoring((Element[])additionalMethods));
            this.refactorings.add(refactoring);
            return true;
        }
        return false;
    }
}

