/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.rename;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class WebXmlRenameRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");

    public Problem precheck() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Problem prepare(AbstractRefactoring refactoring, RefObject refObject, String newName, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        if (!(refObject instanceof JavaClass)) return problem;
        JavaClass jClass = (JavaClass)refObject;
        String name = jClass.getName();
        err.log("name: " + name);
        newName = name.substring(0, name.lastIndexOf(46) + 1) + newName;
        err.log("newName: " + newName);
        Resource res = jClass.getResource();
        FileObject fo = JavaModel.getFileObject((Resource)res);
        Collection wmodules = Utility.getRelevantWebModules(fo);
        Iterator wmIter = null;
        if (wmodules != null) {
            wmIter = wmodules.iterator();
        }
        if (wmIter == null) return problem;
        while (wmIter.hasNext()) {
            WebModule wm = (WebModule)wmIter.next();
            if (wm == null) continue;
            FileObject webXmlFO = wm.getDeploymentDescriptor();
            WebApp webXmlDD = null;
            try {
                webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (webXmlDD != null && webXmlDD.getStatus() != 2) {
                EjbLocalRef[] localRefs;
                EjbRef[] refs;
                Filter[] filters;
                Listener[] listeners;
                Servlet[] servlets = webXmlDD.getServlet();
                if (servlets != null && servlets.length > 0) {
                    for (int s = 0; s < servlets.length; ++s) {
                        Servlet servlet = servlets[s];
                        err.log("Servlet: " + servlet);
                        String servletClass = servlet.getServletClass();
                        err.log("Servlet class: " + servletClass);
                        if (servletClass == null || !servletClass.equals(name)) continue;
                        WebXmlServletRenameRefactoringElement elem = new WebXmlServletRenameRefactoringElement(webXmlDD, name, newName, servlet, webXmlFO);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                        String servletName = servlet.getServletName();
                        String unqualifiedName = Utility.unqualify(name);
                        if (servletName == null || !servletName.equals(unqualifiedName)) continue;
                        WebXmlServletNameRenameRefactoringElement nameElem = new WebXmlServletNameRenameRefactoringElement(webXmlDD, unqualifiedName, Utility.unqualify(newName), servlet, webXmlFO);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)nameElem);
                    }
                }
                if ((listeners = webXmlDD.getListener()) != null && listeners.length > 0) {
                    for (int s = 0; s < listeners.length; ++s) {
                        Listener listener = listeners[s];
                        err.log("Listener: " + listener);
                        String listenerClass = listener.getListenerClass();
                        err.log("Listener class: " + listenerClass);
                        if (listenerClass == null || !listenerClass.equals(name)) continue;
                        WebXmlListenerRenameRefactoringElement elem = new WebXmlListenerRenameRefactoringElement(webXmlDD, name, newName, listener, webXmlFO);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                    }
                }
                if ((filters = webXmlDD.getFilter()) != null && filters.length > 0) {
                    for (int s = 0; s < filters.length; ++s) {
                        Filter filter = filters[s];
                        err.log("Filter: " + filter);
                        String filterClass = filter.getFilterClass();
                        err.log("Filter class: " + filterClass);
                        if (filterClass == null || !filterClass.equals(name)) continue;
                        WebXmlFilterRenameRefactoringElement elem = new WebXmlFilterRenameRefactoringElement(webXmlDD, name, newName, filter, webXmlFO);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                    }
                }
                if ((refs = webXmlDD.getEjbRef()) != null && refs.length > 0) {
                    for (int l = 0; l < refs.length; ++l) {
                        EjbRef ref = refs[l];
                        err.log("EJB ref: " + ref);
                        String refHome = ref.getHome();
                        err.log("home ref: " + refHome);
                        if (refHome != null && refHome.equals(name)) {
                            WebXmlRefHomeRenameRefactoringElement elem = new WebXmlRefHomeRenameRefactoringElement(webXmlDD, name, newName, ref, webXmlFO);
                            refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                        }
                        String refRemote = ref.getRemote();
                        err.log("localHome ref: " + refRemote);
                        if (refRemote == null || !refRemote.equals(name)) continue;
                        WebXmlRefRemoteRenameRefactoringElement webXmlRefRemoteRenameRefactoringElement = new WebXmlRefRemoteRenameRefactoringElement(webXmlDD, name, newName, ref, webXmlFO);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)webXmlRefRemoteRenameRefactoringElement);
                    }
                }
                if ((localRefs = webXmlDD.getEjbLocalRef()) == null || localRefs.length <= 0) continue;
                for (int l = 0; l < localRefs.length; ++l) {
                    EjbLocalRef localRef = localRefs[l];
                    err.log("EJB local ref: " + localRef);
                    String refLocal = localRef.getLocal();
                    err.log("local ref: " + refLocal);
                    if (refLocal != null && refLocal.equals(name)) {
                        WebXmlRefLocalRenameRefactoringElement webXmlRefLocalRenameRefactoringElement = new WebXmlRefLocalRenameRefactoringElement(webXmlDD, name, newName, localRef, webXmlFO);
                        refactoringElements.add(refactoring, (RefactoringElementImplementation)webXmlRefLocalRenameRefactoringElement);
                    }
                    String string = localRef.getLocalHome();
                    err.log("localHome ref: " + string);
                    if (string == null || !string.equals(name)) continue;
                    WebXmlRefLocalHomeRenameRefactoringElement elem = new WebXmlRefLocalHomeRenameRefactoringElement(webXmlDD, name, newName, localRef, webXmlFO);
                    refactoringElements.add(refactoring, (RefactoringElementImplementation)elem);
                }
                continue;
            }
            Problem newProblem = new Problem(false, NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlInvalidProblem"));
            problem = Utility.addProblemsToEnd(problem, newProblem);
        }
        return problem;
    }

    public final class WebXmlRefLocalHomeRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private EjbLocalRef ref;

        public WebXmlRefLocalHomeRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, EjbLocalRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlRefLocalHomeRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.ref.setLocalHome(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.ref.setLocalHome(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class WebXmlRefLocalRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private EjbLocalRef ref;

        public WebXmlRefLocalRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, EjbLocalRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlRefLocalRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.ref.setLocal(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.ref.setLocal(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class WebXmlRefRemoteRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private EjbRef ref;

        public WebXmlRefRemoteRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, EjbRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlRefRemoteRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.ref.setRemote(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.ref.setRemote(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class WebXmlRefHomeRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private EjbRef ref;

        public WebXmlRefHomeRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, EjbRef ref, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.ref = ref;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlRefHomeRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.ref.setHome(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.ref.setHome(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class WebXmlFilterRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private Filter filter;

        public WebXmlFilterRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Filter filter, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.filter = filter;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlFilterRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.filter.setFilterClass(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.filter.setFilterClass(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class WebXmlListenerRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private Listener listener;

        public WebXmlListenerRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Listener listener, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.listener = listener;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlListenerRename"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.listener.setListenerClass(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.listener.setListenerClass(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class WebXmlServletRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private Servlet servlet;

        public WebXmlServletRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Servlet servlet, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.servlet = servlet;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlServletRename"), args);
        }

        public void performExternalChange() {
            this.servlet.setServletClass(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.servlet.setServletClass(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }

    public final class WebXmlServletNameRenameRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        protected WebApp webXmlDD;
        private Servlet servlet;

        public WebXmlServletNameRenameRefactoringElement(WebApp webXmlDD, String oldName, String newName, Servlet servlet, FileObject parentFile) {
            this.webXmlDD = webXmlDD;
            this.oldName = oldName;
            this.newName = newName;
            this.servlet = servlet;
            this.parentFile = parentFile;
            this.enabled = false;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebXmlRenameRefactoring.class, (String)"TXT_WebXmlServletNameRename"), args);
        }

        public void performExternalChange() {
            this.servlet.setServletName(this.newName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            this.servlet.setServletName(this.oldName);
            try {
                this.webXmlDD.write(this.parentFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }
    }
}

