/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.java.LineSetAnnotation;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.cookies.SourceCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

class OverrideAnnotation
extends LineSetAnnotation {
    private static final String OVERRIDE_ANNOTATION_TYPE = "org-netbeans-modules-java-override_annotation";
    private static final String IMPLEMENT_ANNOTATION_TYPE = "org-netbeans-modules-java-implement_annotation";
    private Descriptor descriptor;
    private int attachedToLine = -1;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;

    private OverrideAnnotation(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getAnnotationType() {
        return this.descriptor.isOverriding() ? OVERRIDE_ANNOTATION_TYPE : IMPLEMENT_ANNOTATION_TYPE;
    }

    public String getShortDescription() {
        String bundleKey = this.descriptor.isOverriding() ? "TXT_Overrides" : "TXT_Implements";
        return MessageFormat.format(NbBundle.getMessage((Class)OverrideAnnotation.class, (String)bundleKey), this.descriptor.getMethodName(), this.descriptor.getOriginalClassQName());
    }

    public void attachToLineSet(Line.Set lines) {
        this.attachToLineSet(lines, this.descriptor.getLine());
    }

    private void attachToLineSet(Line.Set lines, int line) {
        if (line < 0) {
            return;
        }
        Line docline = lines.getCurrent(line);
        Line.Part part = docline.createPart(0, 0);
        this.attach((Annotatable)part);
        this.attachedToLine = line;
    }

    public void updateLine(Line.Set lines) {
        int line = this.descriptor.getLine();
        if (line != this.attachedToLine) {
            this.detach();
            this.attachToLineSet(lines, line);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof OverrideAnnotation) {
            OverrideAnnotation otherAnnotation = (OverrideAnnotation)((Object)other);
            return this.descriptor.equals(otherAnnotation.descriptor);
        }
        return false;
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    public static OverrideAnnotation forDescriptor(Descriptor desc) {
        return new OverrideAnnotation(desc);
    }

    public static class Descriptor {
        private final String overridenMethod;
        private final String originalMethod;
        private final boolean isImplementing;

        public Descriptor(Method originalMethod, Method overridenMethod) {
            this.originalMethod = originalMethod.refMofId();
            this.overridenMethod = overridenMethod.refMofId();
            JavaClass declaring = (JavaClass)originalMethod.getDeclaringClass();
            this.isImplementing = declaring != null && (declaring.isInterface() || Modifier.isAbstract(originalMethod.getModifiers()));
        }

        public final Method getOriginalMethod() {
            return (Method)JavaMetamodel.getDefaultRepository().getByMofId(this.originalMethod);
        }

        public final Method getOverridenMethod() {
            return (Method)JavaMetamodel.getDefaultRepository().getByMofId(this.overridenMethod);
        }

        public final boolean isOverriding() {
            return !this.isImplementing();
        }

        public final boolean isImplementing() {
            return this.isImplementing;
        }

        public final String getMethodName() {
            try {
                return this.getOverridenMethod().getName();
            }
            catch (NullPointerException e) {
                return "";
            }
        }

        public final String getOriginalClassQName() {
            try {
                return this.getOriginalMethod().getDeclaringClass().getName();
            }
            catch (NullPointerException e) {
                return "";
            }
        }

        public final boolean equals(Object other) {
            if (other instanceof Descriptor) {
                Descriptor oa = (Descriptor)other;
                return (this.originalMethod == null ? oa.originalMethod == null : this.originalMethod.equals(oa.originalMethod)) && (this.overridenMethod == null ? oa.overridenMethod == null : this.overridenMethod.equals(oa.overridenMethod));
            }
            return false;
        }

        public final int hashCode() {
            return this.overridenMethod == null ? 0 : this.originalMethod.hashCode();
        }

        final int getLine() {
            Method overridenMethod = this.getOverridenMethod();
            if (overridenMethod == null) {
                return -1;
            }
            DataObject dobj = JavaMetamodel.getManager().getDataObject(overridenMethod.getResource());
            if (dobj == null) {
                return -1;
            }
            SourceCookie.Editor seditor = (SourceCookie.Editor)dobj.getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = OverrideAnnotation.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            if (seditor == null) {
                return -1;
            }
            StyledDocument doc = seditor.getDocument();
            if (doc == null) {
                return -1;
            }
            int offset = JavaMetamodel.getManager().getElementPosition((Element)overridenMethod).getBegin().getOffset();
            return NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        }
    }
}

