/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Enumeration;
import javax.jmi.reflect.JmiException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.java.ui.nodes.editors.MethodParameterPanel;
import org.netbeans.modules.java.ui.nodes.editors.ObjectArrayPanel2;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementNode;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MethodParameterArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    MethodParameterArrayPanel panel;
    boolean ignoreEditor = false;
    boolean ignorePanel = false;
    private PropertyEnv env;
    private JavaModelPackage model;
    private boolean isWritable;

    public MethodParameterArrayEditor() {
        this(true);
    }

    public MethodParameterArrayEditor(boolean isWritable) {
        this.isWritable = isWritable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsText() {
        Parameter[] params = (Parameter[])this.getValue();
        String text = "";
        if (params != null) {
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    text = MethodParameterArrayEditor.params2String(params, ", ", false);
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
            catch (JmiException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return text;
    }

    public static String params2String(Parameter[] params, String delimiter, boolean listJustTypes) {
        StringBuffer buf = new StringBuffer(30);
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(delimiter);
            }
            buf.append(MethodParameterArrayEditor.param2String(params[i], listJustTypes));
        }
        return buf.toString();
    }

    private static String param2String(Parameter p, boolean listJustTypes) {
        StringBuffer sb = new StringBuffer(30);
        if (!listJustTypes && p.isFinal()) {
            sb.append("final");
            sb.append(' ');
        }
        sb.append(ElementFormat.elementName((NamedElement)p.getType()));
        if (p.isVarArg()) {
            sb.append("...");
        }
        if (!listJustTypes) {
            sb.append(' ');
            sb.append(p.getName());
        }
        return sb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException("Use refactoring action instead");
    }

    public void setValue(Object o) {
        this.ignoreEditor = true;
        boolean saveIgnorePanel = this.ignorePanel;
        this.ignorePanel = false;
        super.setValue(o);
        if (this.panel != null & !saveIgnorePanel) {
            this.panel.setMethodParameters((Parameter[])o);
        }
        this.ignoreEditor = false;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.panel == null) {
            this.panel = new MethodParameterArrayPanel(this.model, this.isWritable);
            this.panel.setMnemonics(this.env);
            this.panel.setMethodParameters((Parameter[])this.getValue());
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (!MethodParameterArrayEditor.this.ignoreEditor && "methodParameters".equals(evt.getPropertyName())) {
                        MethodParameterArrayEditor.this.ignorePanel = true;
                        MethodParameterArrayEditor.this.setValue(evt.getNewValue());
                        MethodParameterArrayEditor.this.ignorePanel = false;
                    }
                }
            });
        }
        return this.panel;
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
        this.model = ElementNode.getModel(env.getFeatureDescriptor());
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)MethodParameterArrayEditor.class, (String)key);
    }

    static class MethodParameterArrayPanel
    extends ObjectArrayPanel2
    implements EnhancedCustomPropertyEditor {
        public static final String PROP_METHOD_PARAMETERS = "methodParameters";
        Parameter[] prevValue;
        final JavaModelPackage javaModel;

        public MethodParameterArrayPanel(JavaModelPackage javaModel, boolean isWritable) {
            super(isWritable);
            this.javaModel = javaModel;
            this.prevValue = new Parameter[0];
            this.getListComponent().setCellRenderer(new DefaultListCellRenderer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (comp == this) {
                        try {
                            JavaMetamodel.getDefaultRepository().beginTrans(false);
                            try {
                                this.setText(MethodParameterArrayEditor.param2String((Parameter)value, false));
                            }
                            finally {
                                JavaMetamodel.getDefaultRepository().endTrans();
                            }
                        }
                        catch (JmiException ex) {
                            ErrorManager.getDefault().notify((Throwable)ex);
                        }
                    }
                    return comp;
                }
            });
        }

        public Parameter[] getMethodParameters() {
            Object[] ret = new Parameter[this.model.size()];
            this.model.copyInto(ret);
            return ret;
        }

        public void setMethodParameters(Parameter[] data) {
            this.model = new DefaultListModel();
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    this.model.addElement(data[i]);
                }
            }
            this.getListComponent().setModel(this.model);
            this.modelChanged();
        }

        protected void modelChanged() {
            super.modelChanged();
            Parameter[] newValue = this.getMethodParameters();
            this.firePropertyChange(PROP_METHOD_PARAMETERS, this.prevValue, newValue);
            this.prevValue = newValue;
        }

        protected Object insertNewValue() {
            return this.openInputDialog(null);
        }

        protected Object editValue(Object oldValue) {
            return this.openInputDialog((Parameter)oldValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Parameter openInputDialog(Parameter origValue) {
            Object ret;
            MethodParameterPanel panel = new MethodParameterPanel();
            NotifyDescriptor desriptor = new NotifyDescriptor((Object)panel, MethodParameterArrayEditor.getString("LAB_EnterParameter"), 2, -1, null, null);
            if (origValue != null) {
                String origTypeName = origValue.getType().getName();
                if (origValue.isVarArg()) {
                    origTypeName = origTypeName + "...";
                }
                panel.nameTextField.setText(origValue.getName());
                panel.typeCombo.setSelectedItem(origTypeName);
                panel.finalCheckBox.setSelected(origValue.isFinal());
            }
            while ((ret = DialogDisplayer.getDefault().notify(desriptor)) == NotifyDescriptor.OK_OPTION) {
                String errMsg = null;
                String name = panel.nameTextField.getText().trim();
                String typeName = panel.typeCombo.getSelectedItem().toString().trim();
                if (!Utilities.isJavaIdentifier((String)name)) {
                    errMsg = "MSG_NotValidID";
                } else if (typeName.length() == 0) {
                    errMsg = "MSG_NotValidType";
                } else {
                    try {
                        JavaMetamodel.getDefaultRepository().beginTrans(false);
                        try {
                            boolean isFinal = panel.finalCheckBox.isSelected();
                            Enumeration methodEnum = this.model.elements();
                            while (methodEnum.hasMoreElements()) {
                                Parameter oldPar = (Parameter)methodEnum.nextElement();
                                if (origValue != null && oldPar.equals(origValue) || !name.equals(oldPar.getName())) continue;
                                errMsg = "MSG_DuplicateName";
                                break;
                            }
                            if (errMsg == null) {
                                boolean isVarArg = typeName.endsWith("...");
                                typeName = isVarArg ? typeName.substring(0, typeName.length() - 3) : typeName;
                                MultipartId typeID = this.javaModel.getMultipartId().createMultipartId(typeName, null, null);
                                Parameter p = this.javaModel.getParameter().createParameter();
                                p.setName(name);
                                p.setFinal(isFinal);
                                p.setTypeName((TypeReference)typeID);
                                p.setVarArg(isVarArg);
                                Parameter parameter = p;
                                return parameter;
                            }
                        }
                        finally {
                            JavaMetamodel.getDefaultRepository().endTrans();
                        }
                    }
                    catch (JmiException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                        return null;
                    }
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MethodParameterArrayEditor.getString(errMsg)));
            }
            return null;
        }

        public Object getPropertyValue() throws IllegalStateException {
            return this.getMethodParameters();
        }
    }
}

