/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.swing.Action;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.GenericElement;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.TypedElement;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.java.ui.nodes.editors.IdentifierArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.MethodParameterArrayEditor;
import org.netbeans.modules.java.ui.nodes.editors.ModifierEditor;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.editors.TypeParameterArrayEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.ElementProperties2;
import org.netbeans.modules.java.ui.nodes.elements.IconStrings;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.java.ui.nodes.elements.SourceOptions;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public abstract class ElementNode
extends AbstractNode
implements IconStrings,
ElementProperties2 {
    private static ElementFormat invalidFormat;
    private static final String[] ICON_AFFECTING_PROPERTIES;
    protected Element element;
    protected ElementFormat elementFormat = new ElementFormat("");
    protected boolean writeable;
    private SystemAction preferredAction;
    private JMIElementListener wElementL;
    private final InstanceContent lkpContent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$Parameter;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$MultipartId;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Type;
    static /* synthetic */ Class class$org$netbeans$modules$java$ui$nodes$elements$FieldNode;
    static /* synthetic */ Class array$Lorg$netbeans$jmi$javamodel$TypeParameter;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$java$JavaEditor;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;

    public ElementNode(Element element, Children children, boolean writeable) {
        this(element, children, writeable, new InstanceContent());
    }

    private ElementNode(Element element, Children children, boolean writeable, InstanceContent ic) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        this.element = element;
        this.writeable = writeable;
        this.lkpContent = ic;
        this.setIconBase(this.resolveIconBase());
        this.setDisplayName(this.getElementFormat().format(element));
        this.setShortDescription(this.getHintElementFormat().format(element));
        if (element instanceof MDRChangeSource) {
            this.wElementL = (JMIElementListener)this.createJMIElementListener();
            ((MDRChangeSource)element).addListener((MDRChangeListener)this.wElementL);
        }
        this.displayFormat = null;
        ic.add((Object)new OpenCookieImpl(this));
        ic.add((Object)element);
        Resource r = this.element.getResource();
        DataObject dobj = JavaMetamodel.getManager().getDataObject(r);
        if (dobj != null) {
            ic.add((Object)dobj);
            dobj.addPropertyChangeListener((PropertyChangeListener)new DOListener(this, dobj));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        boolean fail = true;
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(true);
            try {
                this.element.refDelete();
                fail = false;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans(fail);
            }
        }
        catch (JmiException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        super.destroy();
    }

    protected abstract String resolveIconBase();

    protected String[] getIconAffectingProperties() {
        return ICON_AFFECTING_PROPERTIES;
    }

    public final ElementFormat getElementFormat() {
        return this.elementFormat;
    }

    public final void setElementFormat(ElementFormat elementFormat) {
        this.setDisplayName(elementFormat.format(this.element));
        this.elementFormat = elementFormat;
    }

    protected abstract ElementFormat getElementFormatProperty();

    final void setElementFormat0(ElementFormat elementFormat) {
        try {
            this.setElementFormat(elementFormat);
        }
        catch (IllegalArgumentException iae) {
            this.setElementFormat(ElementNode.getInvalidFormat());
        }
    }

    static ElementFormat getInvalidFormat() {
        if (invalidFormat != null) {
            return invalidFormat;
        }
        invalidFormat = new ElementFormat(ElementNode.getString("FMT_InvalidFormat"));
        return invalidFormat;
    }

    protected abstract ElementFormat getHintElementFormat();

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return this.isWriteable();
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public void setActions(SystemAction[] actions, SystemAction preferred) {
        this.systemActions = actions;
        this.preferredAction = preferred;
    }

    public Action getPreferredAction() {
        Object a = this.preferredAction;
        if (a == null) {
            a = super.getPreferredAction();
        }
        return a;
    }

    void superFireCookieChange() {
        this.fireCookieChange();
    }

    public boolean equals(Object o) {
        return o instanceof ElementNode && this.element.equals(((ElementNode)o).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    boolean isWriteable() {
        return this.writeable && SourceEditSupport.isWriteable(this.element);
    }

    void superSetName(String name) {
        super.setName(name);
    }

    void superPropertyChange(String name, Object o, Object n) {
        super.firePropertyChange(name, o, n);
    }

    void superShortDescriptionChange(String o, String n) {
        super.fireShortDescriptionChange(o, n);
    }

    MDRChangeListener createJMIElementListener() {
        JMIElementListener l = new JMIElementListener(this);
        return l;
    }

    protected ChangeDescriptor handleAttributeChange(AttributeEvent ae) {
        Object src = ae.getSource();
        ChangeDescriptor cd = new ChangeDescriptor();
        if (src != this.element || !((Element)src).isValid()) {
            return cd;
        }
        String attrName = ae.getAttributeName();
        String propName = this.mapAttributeName(attrName);
        if (propName == null) {
            cd.displayName = this.getElementFormat().format(this.element);
            cd.shortDescription = this.getHintElementFormat().format(this.element);
            cd.iconBase = this.resolveIconBase();
        } else {
            if (this.getElementFormat().dependsOnProperty(propName)) {
                cd.displayName = this.getElementFormat().format(this.element);
            }
            String[] iconProps = this.getIconAffectingProperties();
            for (int i = 0; i < iconProps.length; ++i) {
                if (!iconProps[i].equals(propName)) continue;
                cd.iconBase = this.resolveIconBase();
                break;
            }
            if (propName.equals("name")) {
                cd.name = ((NamedElement)this.element).getName();
            }
            if (this.getHintElementFormat().dependsOnProperty(propName)) {
                cd.shortDescription = this.getHintElementFormat().format(this.element);
            }
        }
        return cd;
    }

    protected void processChange(ChangeDescriptor desc) {
        if (desc.displayName != null) {
            this.setDisplayName(desc.displayName);
        }
        if (desc.iconBase != null) {
            this.setIconBase(desc.iconBase);
        }
        if (desc.name != null) {
            this.superSetName(desc.name);
        }
        if (desc.shortDescription != null) {
            this.setShortDescription(desc.shortDescription);
        }
        if (desc.sheet != null) {
            this.setSheet(desc.sheet);
        }
    }

    protected abstract Map getAttributeNameMap();

    final String mapAttributeName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        String property = (String)this.getAttributeNameMap().get(name);
        return property == null ? name : property;
    }

    static String getString(String key) {
        return NbBundle.getMessage((Class)ElementNode.class, (String)key);
    }

    private static void fireChangesInAWTThread(final ElementNode n, final ChangeDescriptor cd) {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                n.processChange(cd);
            }
        });
    }

    private DataObject getDataObject() {
        return (DataObject)this.getCookie(DataObject.class);
    }

    public static Node.Property createNameProperty(NamedElement element) {
        NameProperty prop = new NameProperty(element);
        return prop;
    }

    public static Node.Property createParametersProperty(CallableFeature element, boolean canW) {
        ParametersProperty prop = new ParametersProperty(element, canW);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    public static Node.Property createExceptionsProperty(CallableFeature element, boolean canW) {
        ExceptionsProperty prop = new ExceptionsProperty(element, canW);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    public static Node.Property createTypeProperty(String name, TypedElement element, boolean canW) {
        TypeProperty prop = new TypeProperty(name, element, canW);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    public static Node.Property createTypeParametersProperty(String name, GenericElement element, boolean canW) {
        TypeParametersProperty prop = new TypeParametersProperty(name, element, canW);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    public static Node.Property createModifiersProperty(ClassMember element, boolean canW) {
        int mask;
        try {
            mask = SourceEditSupport.getModifiersMask(element);
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
            mask = 65535;
        }
        return ElementNode.createModifiersProperty(element, canW, mask);
    }

    public static Node.Property createModifiersProperty(ClassMember element, boolean canW, int mask) {
        ModifiersProperty prop = new ModifiersProperty(element, canW, mask);
        ElementNode.setModel((Element)element, (FeatureDescriptor)((Object)prop));
        return prop;
    }

    public static void setModel(Element el, FeatureDescriptor fd) {
        JavaModelPackage model = JavaMetamodel.getManager().getJavaExtent(el);
        fd.setValue("JavaModelPackage", model);
    }

    public static JavaModelPackage getModel(FeatureDescriptor fd) {
        JavaModelPackage model = (JavaModelPackage)fd.getValue("JavaModelPackage");
        if (model == null) {
            model = JavaMetamodel.getManager().getDefaultExtent();
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("missing JavaModelPackage"));
        }
        return model;
    }

    protected Node.Property createModifiersProperty(boolean canW) {
        Node.Property p = ElementNode.createModifiersProperty((ClassMember)this.element, canW);
        p.setValue("changeImmediate", (Object)Boolean.FALSE);
        return p;
    }

    protected static SourceOptions getSourceOptions() {
        return SourceOptions.getInstance();
    }

    static {
        $assertionsDisabled = !ElementNode.class.desiredAssertionStatus();
        ICON_AFFECTING_PROPERTIES = new String[]{"modifiers"};
    }

    private static final class DOListener
    extends WeakReference
    implements PropertyChangeListener,
    Runnable {
        private DataObject dobj;

        public DOListener(ElementNode referent, DataObject dobj) {
            super(referent, Utilities.activeReferenceQueue());
            this.dobj = dobj;
            DOListener.updateCookies(dobj, referent);
        }

        public void initialize() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String pname = evt.getPropertyName();
            ElementNode en = (ElementNode)this.get();
            if (en == null) {
                return;
            }
            if (pname == null || "cookie".equals(pname)) {
                DOListener.updateCookies(this.dobj, en);
            }
        }

        private static void updateCookies(DataObject dobj, ElementNode en) {
            SaveCookie nsc;
            SaveCookie dsc = (SaveCookie)dobj.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ElementNode.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (dsc != (nsc = (SaveCookie)en.getLookup().lookup(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = ElementNode.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie))) {
                if (nsc != null) {
                    en.lkpContent.remove((Object)nsc);
                }
                if (dsc != null) {
                    en.lkpContent.add((Object)dsc);
                }
            }
        }

        public void run() {
            this.dobj.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private static final class OpenCookieImpl
    implements OpenCookie {
        private final ElementNode node;

        public OpenCookieImpl(ElementNode node) {
            this.node = node;
        }

        public void open() {
            try {
                DataObject d = this.node.getDataObject();
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition(this.node.element);
                if (bounds == null) {
                    return;
                }
                ((JavaEditor)d.getCookie(class$org$netbeans$modules$java$JavaEditor == null ? (class$org$netbeans$modules$java$JavaEditor = ElementNode.class$("org.netbeans.modules.java.JavaEditor")) : class$org$netbeans$modules$java$JavaEditor)).openAt(bounds.getBegin());
            }
            catch (InvalidObjectException invalidObjectException) {
                // empty catch block
            }
        }
    }

    private static final class NameProperty
    extends ElementProp {
        private final NamedElement element;

        public NameProperty(NamedElement element) {
            super("name", class$java$lang$String == null ? (class$java$lang$String = ElementNode.class$("java.lang.String")) : class$java$lang$String, false);
            this.element = element;
        }

        public Object getValue() {
            return this.element.getName();
        }
    }

    private static final class ModifiersProperty
    extends ElementProp {
        private final ClassMember element;
        private final int mask;

        private ModifiersProperty(ClassMember element, boolean canW, int mask) {
            super("modifiers", class$java$lang$Integer == null ? (class$java$lang$Integer = ElementNode.class$("java.lang.Integer")) : class$java$lang$Integer, canW);
            this.element = element;
            this.mask = mask;
        }

        public Object getValue() {
            return new Integer(this.element.getModifiers());
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof Integer)) {
                throw new IllegalArgumentException();
            }
            int m = (Integer)val;
            int oldVal = this.element.getModifiers();
            int newVal = (m & this.mask) + (oldVal & ~this.mask);
            this.element.setModifiers(newVal);
        }

        public PropertyEditor createPropertyEditor() {
            return new ModifierEditor(this.mask);
        }
    }

    private static final class TypeParametersProperty
    extends ElementProp {
        private final GenericElement element;

        public TypeParametersProperty(String name, GenericElement element, boolean canW) {
            super(name, array$Lorg$netbeans$jmi$javamodel$TypeParameter == null ? (array$Lorg$netbeans$jmi$javamodel$TypeParameter = ElementNode.class$("[Lorg.netbeans.jmi.javamodel.TypeParameter;")) : array$Lorg$netbeans$jmi$javamodel$TypeParameter, false);
            this.element = element;
        }

        protected PropertyEditor createPropertyEditor() {
            return new TypeParameterArrayEditor();
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getTypeParameters().toArray(new TypeParameter[0]);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            throw new InvocationTargetException(new UnsupportedOperationException());
        }
    }

    private static final class TypeProperty
    extends ElementProp {
        private final TypedElement element;

        public TypeProperty(String propName, TypedElement element, boolean canW) {
            super(propName, class$org$netbeans$jmi$javamodel$Type == null ? (class$org$netbeans$jmi$javamodel$Type = ElementNode.class$("org.netbeans.jmi.javamodel.Type")) : class$org$netbeans$jmi$javamodel$Type, canW);
            this.element = element;
        }

        public PropertyEditor createPropertyEditor() {
            return new TypeEditor();
        }

        public Object getValue() {
            return this.element.getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof Type)) {
                throw new IllegalArgumentException();
            }
            Type type = (Type)val;
            boolean fail = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    this.element.setType(type);
                    fail = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                }
            }
            catch (JmiException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                ErrorManager.getDefault().annotate((Throwable)iae, 256, null, NbBundle.getMessage((Class)(class$org$netbeans$modules$java$ui$nodes$elements$FieldNode == null ? (class$org$netbeans$modules$java$ui$nodes$elements$FieldNode = ElementNode.class$("org.netbeans.modules.java.ui.nodes.elements.FieldNode")) : class$org$netbeans$modules$java$ui$nodes$elements$FieldNode), (String)"MSG_InvalidTypeDecl"), null, null);
                throw iae;
            }
        }
    }

    private static final class ExceptionsProperty
    extends ElementProp {
        private final CallableFeature element;

        public ExceptionsProperty(CallableFeature element, boolean canW) {
            super("exceptions", array$Lorg$netbeans$jmi$javamodel$MultipartId == null ? (array$Lorg$netbeans$jmi$javamodel$MultipartId = ElementNode.class$("[Lorg.netbeans.jmi.javamodel.MultipartId;")) : array$Lorg$netbeans$jmi$javamodel$MultipartId, canW);
            this.element = element;
        }

        protected PropertyEditor createPropertyEditor() {
            return new IdentifierArrayEditor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() {
            MultipartId[] ret = null;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    if (this.element.isValid()) {
                        List l = this.element.getExceptionNames();
                        ret = l.toArray(new MultipartId[l.size()]);
                    }
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans();
                }
            }
            catch (JmiException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof MultipartId[])) {
                throw new IllegalArgumentException();
            }
            boolean fail = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List exs = this.element.getExceptionNames();
                    exs.clear();
                    exs.addAll(Arrays.asList((MultipartId[])val));
                    fail = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                }
            }
            catch (JmiException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                throw iae;
            }
        }
    }

    private static final class ParametersProperty
    extends ElementProp {
        private final CallableFeature element;

        private ParametersProperty(CallableFeature element, boolean canW) {
            super("parameters", array$Lorg$netbeans$jmi$javamodel$Parameter == null ? (array$Lorg$netbeans$jmi$javamodel$Parameter = ElementNode.class$("[Lorg.netbeans.jmi.javamodel.Parameter;")) : array$Lorg$netbeans$jmi$javamodel$Parameter, canW);
            this.element = element;
        }

        public Object getValue() {
            List l = this.element.getParameters();
            return l.toArray(new Parameter[l.size()]);
        }

        public PropertyEditor createPropertyEditor() {
            return new MethodParameterArrayEditor(this.canWrite());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            super.setValue(val);
            if (!(val instanceof Parameter[])) {
                throw new IllegalArgumentException();
            }
            boolean fail = true;
            try {
                JavaMetamodel.getDefaultRepository().beginTrans(true);
                try {
                    List l = this.element.getParameters();
                    l.clear();
                    l.addAll(Arrays.asList((Parameter[])val));
                    fail = false;
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(fail);
                }
            }
            catch (JmiException e) {
                IllegalArgumentException iae = new IllegalArgumentException();
                iae.initCause(e);
                throw iae;
            }
        }
    }

    static abstract class ElementProp
    extends PropertySupport {
        private Reference editor = null;

        public ElementProp(String name, Class type, boolean canW) {
            super(name, type, ElementNode.getString("PROP_" + name), ElementNode.getString("HINT_" + name), true, canW);
        }

        public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.canWrite()) {
                throw new IllegalAccessException(ElementNode.getString("MSG_Cannot_Write"));
            }
        }

        public final PropertyEditor getPropertyEditor() {
            PropertyEditor pe;
            if (this.editor == null || (pe = (PropertyEditor)this.editor.get()) == null) {
                pe = this.createPropertyEditor();
                this.editor = new SoftReference<PropertyEditor>(pe);
            }
            return pe;
        }

        protected PropertyEditor createPropertyEditor() {
            return super.getPropertyEditor();
        }
    }

    static final class ChangeDescriptor {
        String displayName;
        String name;
        String iconBase;
        String shortDescription;
        Sheet sheet;

        public ChangeDescriptor(String displayName, String iconBase, String name, String shortDescription) {
            this.displayName = displayName;
            this.iconBase = iconBase;
            this.name = name;
            this.shortDescription = shortDescription;
            this.sheet = null;
        }

        public ChangeDescriptor() {
        }
    }

    static final class JMIElementListener
    extends WeakReference
    implements MDRChangeListener,
    Runnable {
        private final Element element;
        static final /* synthetic */ boolean $assertionsDisabled;

        public JMIElementListener(ElementNode referent) {
            super(referent, Utilities.activeReferenceQueue());
            this.element = referent.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void change(MDRChangeEvent e) {
            ElementNode n = (ElementNode)this.get();
            if (n == null) {
                return;
            }
            if (!e.isOfType(0x101FFFF)) {
                return;
            }
            AttributeEvent ae = (AttributeEvent)e;
            String attrName = ae.getAttributeName();
            try {
                ChangeDescriptor cd;
                JavaMetamodel.getDefaultRepository().beginTrans(false);
                try {
                    cd = n.handleAttributeChange(ae);
                }
                finally {
                    JavaMetamodel.getDefaultRepository().endTrans(false);
                }
                if (!$assertionsDisabled && cd == null) {
                    throw new AssertionError();
                }
                ElementNode.fireChangesInAWTThread(n, cd);
                this.fireRegisteredProperties(attrName);
            }
            catch (JmiException ex) {
                ErrorManager.getDefault().notify(16, (Throwable)ex);
            }
        }

        public void run() {
            ((MDRChangeSource)this.element).removeListener((MDRChangeListener)this);
        }

        private void fireRegisteredProperties(String name) {
            ElementNode n = (ElementNode)this.get();
            if (n == null) {
                return;
            }
            if (name == null || (name = (String)n.getAttributeNameMap().get(name)) != null) {
                n.superPropertyChange(name, null, null);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$java$ui$nodes$elements$ElementNode == null ? (class$org$netbeans$modules$java$ui$nodes$elements$ElementNode = ElementNode.class$("org.netbeans.modules.java.ui.nodes.elements.ElementNode")) : class$org$netbeans$modules$java$ui$nodes$elements$ElementNode).desiredAssertionStatus();
        }
    }
}

