/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.InstanceEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.JavaSourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.SourceNodeFactory;
import org.netbeans.modules.java.ui.nodes.elements.ChildrenProvider;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.java.ui.nodes.elements.SourceElementFilter;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.cookies.FilterCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class SourceChildren
extends Children.Keys
implements FilterCookie,
ChildrenProvider.KeyHandler {
    static final Object NOT_KEY;
    static final Object ERROR_KEY;
    private static int PPP_MASK;
    protected Resource element;
    protected SourceElementFilter filter;
    protected SourceNodeFactory factory;
    private JMIListener wElementL;
    private boolean nodesInited = false;
    private final ChildrenProvider chprovider = new ChildrenProvider(this);
    private final ClassesListener CLS_LISTENER = new ClassesListener(this);
    private DataObject resourceHolder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SourceChildren() {
        this(JavaSourceNodeFactory.getDefault(), null);
    }

    public SourceChildren(Resource resource) {
        this(JavaSourceNodeFactory.getDefault(), resource);
    }

    public SourceChildren(SourceNodeFactory factory) {
        this(factory, null);
    }

    public SourceChildren(SourceNodeFactory factory, Resource resource) {
        this.element = resource;
        this.factory = factory;
        this.filter = new SourceElementFilter();
        this.resourceHolder = resource != null ? JavaMetamodel.getManager().getDataObject(resource) : null;
    }

    public Class getFilterClass() {
        return SourceElementFilter.class;
    }

    public Object getFilter() {
        return this.filter;
    }

    public void setFilter(Object filter) {
        if (!(filter instanceof SourceElementFilter)) {
            throw new IllegalArgumentException();
        }
        this.filter = (SourceElementFilter)filter;
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    protected Resource createResource() {
        return null;
    }

    protected void addNotify() {
        this.setKeys(Collections.singletonList(NOT_KEY));
        ChildrenProvider.RP.post(new Runnable(){

            public void run() {
                Resource element = SourceChildren.this.element == null ? SourceChildren.this.createResource() : null;
                SourceChildren.this.setElementImpl(element);
                if (element != null) {
                    if (SourceChildren.this.wElementL == null) {
                        SourceChildren.this.wElementL = new JMIListener(SourceChildren.this, (MDRChangeSource)element);
                    }
                    ((MDRChangeSource)element).addListener((MDRChangeListener)SourceChildren.this.wElementL);
                }
                SourceChildren.this.refreshAllKeys();
                SourceChildren.this.nodesInited = true;
            }
        });
    }

    protected void removeNotify() {
        ChildrenProvider.RP.post(new Runnable(){

            public void run() {
                Resource element = SourceChildren.this.element;
                if (element != null) {
                    ((MDRChangeSource)element).removeListener((MDRChangeListener)SourceChildren.this.wElementL);
                }
                SourceChildren.this.CLS_LISTENER.updateClasses(Collections.EMPTY_LIST);
                SourceChildren.this.chprovider.clear();
                SourceChildren.this.nodesInited = false;
            }
        });
    }

    protected Node[] createNodes(Object key) {
        Node[] nodes;
        if (NOT_KEY.equals(key)) {
            nodes = new Node[]{this.factory.createWaitNode()};
        } else if (key instanceof Node) {
            nodes = new Node[]{new FilterNode((Node)key)};
        } else if (key instanceof Node[]) {
            Node[] ns = (Node[])key;
            nodes = new Node[ns.length];
            for (int i = 0; i < ns.length; ++i) {
                Node orig = ns[i];
                nodes[i] = orig == null ? orig : new FilterNode(orig);
            }
        } else if (ERROR_KEY.equals(key)) {
            nodes = new Node[]{this.factory.createWaitNode()};
        } else {
            nodes = new Node[]{this.factory.createErrorNode()};
            ErrorManager.getDefault().notify(16, (Throwable)new IllegalStateException("key: " + key));
        }
        return nodes;
    }

    private Node[] createNodesImpl(Object key) throws JmiException {
        Node n = key instanceof JavaEnum ? this.factory.createEnumNode((JavaEnum)key) : (key instanceof AnnotationType ? this.factory.createAnnotationTypeNode((AnnotationType)key) : (key instanceof JavaClass ? this.factory.createClassNode((JavaClass)key) : (NOT_KEY.equals(key) ? this.factory.createWaitNode() : this.factory.createErrorNode())));
        return new Node[]{n};
    }

    public Node[] getNodes(boolean optimalResult) {
        if (!optimalResult || this.element == null) {
            return this.getNodes();
        }
        this.chprovider.waitFinished();
        return this.getNodes();
    }

    public Node findChild(String name) {
        Node n = super.findChild(name);
        if (n == null) {
            this.chprovider.waitFinished();
            n = super.findChild(name);
        }
        return n;
    }

    public Resource getElement() {
        return this.element;
    }

    public void setElement(final Resource element) {
        ChildrenProvider.RP.post(new Runnable(){

            public void run() {
                SourceChildren.this.setElementImpl(element);
            }
        });
    }

    private void setElementImpl(Resource element) {
        if (this.element != null) {
            ((MDRChangeSource)this.element).removeListener((MDRChangeListener)this.wElementL);
        }
        this.element = element;
        this.CLS_LISTENER.updateClasses(Collections.EMPTY_LIST);
        if (element != null) {
            if (this.resourceHolder == null) {
                this.resourceHolder = JavaMetamodel.getManager().getDataObject(element);
            }
            if (this.wElementL == null) {
                this.wElementL = new JMIListener(this, (MDRChangeSource)element);
            } else {
                this.wElementL.source = (MDRChangeSource)element;
            }
            ((MDRChangeSource)element).addListener((MDRChangeListener)this.wElementL);
        }
        if (this.nodesInited) {
            this.refreshAllKeys();
        }
    }

    private void refreshAllKeys() {
        if (!$assertionsDisabled && !ChildrenProvider.RP.isRequestProcessorThread()) {
            throw new AssertionError();
        }
        if (this.element == null) {
            List<Object> keys = Collections.singletonList(ERROR_KEY);
            this.setKeys(keys);
        } else {
            if (!this.nodesInited) {
                List<Object> keys = Collections.singletonList(NOT_KEY);
                this.setKeys(keys);
            }
            this.chprovider.recomputeChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List collectKeysImpl() {
        Resource element = this.element;
        if (element == null) {
            return Collections.EMPTY_LIST;
        }
        int[] order = this.filter == null || this.filter.getOrder() == null ? SourceElementFilter.DEFAULT_ORDER : this.filter.getOrder();
        LinkedList<Object> keys = new LinkedList<Object>();
        try {
            JavaMetamodel.getDefaultRepository().beginTrans(false);
            try {
                if (!element.isValid()) {
                    keys.add(ERROR_KEY);
                    LinkedList<Object> linkedList = keys;
                    return linkedList;
                }
                int i = 0;
                while (i < order.length) {
                    this.addKeysOfType(element, keys, order[i]);
                    ++i;
                }
                return keys;
            }
            finally {
                JavaMetamodel.getDefaultRepository().endTrans();
            }
        }
        catch (InvalidObjectException ex) {
            keys.clear();
            keys.add(ERROR_KEY);
            return keys;
        }
        catch (JmiException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        return keys;
    }

    private void addKeysOfType(Resource element, Collection keys, int elementType) {
        List cls;
        if (elementType == 1) {
            return;
        }
        if (this.filter != null && this.filter.isAllClasses()) {
            cls = SourceEditSupport.getAllClasses(element);
            this.CLS_LISTENER.updateClasses(cls);
        } else {
            cls = element.getClassifiers();
        }
        Iterator it = cls.iterator();
        while (it.hasNext()) {
            JavaClass classElement = (JavaClass)it.next();
            int modifiers = classElement.getModifiers();
            if ((modifiers & PPP_MASK) == 0) {
                modifiers += 65536;
            }
            if ((this.filter.getModifiers() & modifiers) == 0) continue;
            if (classElement instanceof JavaEnum) {
                if ((elementType & 0x10) == 0) continue;
                keys.add(classElement);
                continue;
            }
            if (classElement.isInterface()) {
                if ((elementType & 4) == 0) continue;
                keys.add(classElement);
                continue;
            }
            if ((elementType & 2) == 0) continue;
            keys.add(classElement);
        }
    }

    public List collectKeys() {
        return this.collectKeysImpl();
    }

    public Node[] prepareNodes(Object key) {
        return this.createNodesImpl(key);
    }

    public void presentKeys(List keys, List nodes) {
        this.setKeys(nodes);
    }

    static {
        $assertionsDisabled = !SourceChildren.class.desiredAssertionStatus();
        NOT_KEY = new Object();
        ERROR_KEY = new Object();
        PPP_MASK = 7;
    }

    private static final class ClassesListener
    implements MDRChangeListener {
        private SourceChildren sc;
        private List classes;

        public ClassesListener(SourceChildren sc) {
            this.sc = sc;
            this.classes = Collections.EMPTY_LIST;
        }

        public void updateClasses(List classes) {
            ArrayList toAdd = new ArrayList(classes);
            toAdd.removeAll(this.classes);
            this.classes.removeAll(classes);
            this.addListeners(toAdd);
            this.removeListeners(this.classes);
            this.classes = new ArrayList(classes);
        }

        public void change(final MDRChangeEvent e) {
            ChildrenProvider.RP.post(new Runnable(){

                public void run() {
                    ClassesListener.this.processChange(e, ClassesListener.this.sc);
                }
            });
        }

        private void processChange(MDRChangeEvent e, SourceChildren sc) {
            if (e instanceof AttributeEvent) {
                if (sc.element == null) {
                    return;
                }
                AttributeEvent ae = (AttributeEvent)e;
                if ("contents".equals(ae.getAttributeName()) && sc.nodesInited) {
                    Element cm = (Element)ae.getOldElement();
                    Element element = cm = cm == null ? (Element)ae.getNewElement() : cm;
                    if (cm != null && cm instanceof JavaClass) {
                        sc.refreshAllKeys();
                    }
                }
            }
        }

        private void addListeners(List c) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof MDRChangeSource)) continue;
                MDRChangeSource el = (MDRChangeSource)o;
                el.addListener((MDRChangeListener)this);
            }
        }

        private void removeListeners(List c) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof MDRChangeSource)) continue;
                MDRChangeSource el = (MDRChangeSource)o;
                el.removeListener((MDRChangeListener)this);
            }
        }
    }

    private static final class JMIListener
    extends WeakReference
    implements MDRChangeListener,
    Runnable {
        private MDRChangeSource source;

        public JMIListener(SourceChildren referent, MDRChangeSource source) {
            super(referent, Utilities.activeReferenceQueue());
            this.source = source;
        }

        public void change(final MDRChangeEvent e) {
            final SourceChildren sc = (SourceChildren)this.get();
            if (sc == null) {
                return;
            }
            ChildrenProvider.RP.post(new Runnable(){

                public void run() {
                    JMIListener.this.processChange(e, sc);
                }
            });
        }

        private void processChange(MDRChangeEvent e, SourceChildren sc) {
            InstanceEvent ie;
            RefObject o;
            if (e instanceof AttributeEvent) {
                if (sc.element == null || !sc.element.isValid()) {
                    return;
                }
                AttributeEvent ae = (AttributeEvent)e;
                if ("classifiers".equals(ae.getAttributeName()) && sc.nodesInited) {
                    sc.refreshAllKeys();
                }
            } else if (e instanceof InstanceEvent && (o = (ie = (InstanceEvent)e).getInstance()) == sc.element && !sc.element.isValid()) {
                DataObject dobj = sc.resourceHolder;
                if (dobj != null && dobj.isValid()) {
                    Resource newRes = JavaMetamodel.getManager().getResource(dobj.getPrimaryFile());
                    sc.setElement(newRes);
                } else {
                    sc.setElement(null);
                }
            }
        }

        public void run() {
            this.source.removeListener((MDRChangeListener)this);
        }
    }
}

