/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.gjast;

import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Diagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import org.netbeans.lib.java.parser.ErrConsumer;
import org.openide.ErrorManager;

public final class ASLog
extends Log {
    private static final boolean logErrors = Boolean.getBoolean("gjast.log.errors");
    private ErrConsumer errConsumer;
    private static PrintWriter devNull = new PrintWriter(new DevNullWriter());
    private HashMap<Name, char[]> sources = new HashMap();
    private static final ErrConsumer defaultErrConsumer = new ErrConsumer(){

        public void pushError(Object severity, String errorFileName, int line, int column, String message, String key, String[] args) {
            String msg;
            int level;
            if (severity == ErrConsumer.ERROR) {
                level = 65536;
                msg = "error: ";
            } else {
                level = 16;
                msg = "warning: ";
            }
            msg = msg + errorFileName + ":" + line + "," + column + ": " + message;
            ErrorManager.getDefault().log(level, msg);
        }
    };

    public static void register(final Context context) {
        context.put(logKey, new Context.Factory<Log>(){

            @Override
            public Log make() {
                return new ASLog(context);
            }

            @Override
            public /* synthetic */ Object make() {
                return this.make();
            }
        });
    }

    public static ASLog instance(Context context) {
        ASLog instance = (ASLog)context.get(logKey);
        if (instance == null) {
            instance = new ASLog(context);
        }
        return instance;
    }

    void errConsumer(ErrConsumer ec) {
        this.errConsumer = ec;
    }

    protected ASLog(Context context) {
        super(context, devNull);
        this.errConsumer = defaultErrConsumer;
    }

    public Name useSource(Name name) {
        Name prev = super.useSource(name);
        if (this.buf == null) {
            this.setBuf(this.sources.get(name));
        }
        return prev;
    }

    void addSource(Name name, char[] src) {
        this.sources.put(name, src);
        if (name.equals(this.currentSource())) {
            this.setBuf(src);
        }
    }

    void releaseSources() {
        this.sources = null;
    }

    public void flush() {
    }

    public void error(int pos, String key, Object[] args) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(pos)) {
            this.forwardLogMessage(ErrConsumer.ERROR, pos, key, args);
            ++this.nerrors;
        }
    }

    public void warning(int pos, String key, Object[] args) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.forwardLogMessage(ErrConsumer.WARNING, pos, key, args);
            ++this.nwarnings;
        }
    }

    public void note(String key, Object[] args) {
    }

    public void rawError(int pos, String msg) {
        this.forwardLogMessage(ErrConsumer.ERROR, pos, "", new Object[]{msg});
    }

    public void rawWarning(int pos, String msg) {
        this.forwardLogMessage(ErrConsumer.WARNING, pos, "", new Object[]{msg});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void forwardLogMessage(Object severity, int pos, String key, Object[] args) {
        String msg;
        String errorFile = this.currentSource().toString();
        int line = this.getLineNumber(pos);
        int column = this.getColumnNumber(pos);
        if (key.length() > 0) {
            if (severity == ErrConsumer.ERROR) {
                msg = (pos == -1 ? ASLog.getText("compiler.err.error", new Object[0]) : "") + ASLog.getText("compiler.err." + key, args);
            } else {
                if (severity != ErrConsumer.WARNING) throw new IllegalArgumentException("Unknown severity " + severity);
                msg = ASLog.getText("compiler.warn.warning", new Object[0]) + ASLog.getText("compiler.warn." + key, args);
            }
        } else {
            msg = (String)args[0];
        }
        if (this.errConsumer != null) {
            String[] stringArgs = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                Object arg = args[i];
                if (arg instanceof Diagnostic) {
                    Diagnostic diag = (Diagnostic)arg;
                    stringArgs[i] = diag.key;
                    continue;
                }
                stringArgs[i] = args[i].toString();
            }
            this.errConsumer.pushError(severity, errorFile, line, column, msg, key, stringArgs);
        }
        if (!logErrors) return;
        defaultErrConsumer.pushError(severity, errorFile, line, column, msg, null, null);
    }

    private static class DevNullWriter
    extends Writer {
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

