/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.customization.model.BindingCustomization;
import org.netbeans.modules.websvc.customization.model.BindingOperationCustomization;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.WeakListeners;

public class BindingOperationPanel
extends SaveableSectionInnerPanel {
    private BindingOperation bindingOperation;
    private WSDLModel model;
    private boolean wsdlDirty;
    private ModelChangeListener modelListener;
    private ModelChangeListener primaryModelListener;
    private Definitions primaryDefinitions;
    private WSDLModel primaryModel;
    private JLabel bindingLabel;
    private JLabel bindingName;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableMIMEContentCB;

    public BindingOperationPanel(SectionView view, BindingOperation bindingOperation, Definitions primaryDefinitions) {
        super(view);
        this.bindingOperation = bindingOperation;
        this.primaryDefinitions = primaryDefinitions;
        this.model = this.bindingOperation.getModel();
        this.primaryModel = this.primaryDefinitions.getModel();
        this.initComponents();
        this.enableMIMEContentCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.bindingLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.bindingName.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.bindingName.setText(this.getParentOfBindingOperation(bindingOperation));
        this.sync();
        this.addModifier(this.enableMIMEContentCB);
        this.modelListener = new ModelChangeListener();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)this.model);
        this.model.addPropertyChangeListener(pcl);
        if (this.primaryModel != this.model) {
            this.primaryModelListener = new ModelChangeListener();
            PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this.primaryModelListener, (Object)this.primaryModel);
            this.primaryModel.addPropertyChangeListener(l);
        }
    }

    private String getParentOfBindingOperation(BindingOperation op) {
        Binding binding = (Binding)op.getParent();
        return binding.getName();
    }

    private void sync() {
        List ee = this.bindingOperation.getExtensibilityElements(BindingOperationCustomization.class);
        if (ee.size() == 1) {
            BindingOperationCustomization boc = (BindingOperationCustomization)ee.get(0);
            EnableMIMEContent emc = boc.getEnableMIMEContent();
            if (emc != null) {
                this.setEnableMIMEContent(emc.isEnabled());
            } else {
                this.setEnableMIMEContent(this.getMIMEContentOfParent());
            }
        } else {
            this.setEnableMIMEContent(this.getMIMEContentOfParent());
        }
    }

    private boolean getMIMEContentOfParent() {
        BindingCustomization bc;
        EnableMIMEContent mimeContent;
        boolean isMIMEContent = false;
        Binding binding = (Binding)this.bindingOperation.getParent();
        List bcs = binding.getExtensibilityElements(BindingCustomization.class);
        isMIMEContent = bcs.size() > 0 ? ((mimeContent = (bc = (BindingCustomization)bcs.get(0)).getEnableMIMEContent()) != null ? mimeContent.isEnabled() : this.getMIMEContentFromDefinitions(this.primaryDefinitions)) : this.getMIMEContentFromDefinitions(this.primaryDefinitions);
        return isMIMEContent;
    }

    private boolean getMIMEContentFromDefinitions(Definitions definitions) {
        DefinitionsCustomization dc;
        EnableMIMEContent mimeContent;
        List dcs = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (mimeContent = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableMIMEContent()) != null) {
            return mimeContent.isEnabled();
        }
        return false;
    }

    public void setEnableMIMEContent(boolean enable) {
        this.enableMIMEContentCB.setSelected(enable);
    }

    public Boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.bindingOperation.getExtensibilityElements(BindingOperationCustomization.class);
        CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.enableMIMEContentCB) {
            if (ee.size() > 0) {
                BindingOperationCustomization boc = (BindingOperationCustomization)ee.get(0);
                EnableMIMEContent emc = boc.getEnableMIMEContent();
                if (emc == null) {
                    try {
                        this.model.startTransaction();
                        emc = factory.createEnableMIMEContent(this.model);
                        emc.setEnabled(this.getEnableMIMEContent());
                        boc.setEnableMIMEContent(emc);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        emc.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                BindingOperationCustomization boc = factory.createBindingOperationCustomization(this.model);
                EnableMIMEContent emc = factory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    emc.setEnabled(this.getEnableMIMEContent());
                    boc.setEnableMIMEContent(emc);
                    this.bindingOperation.addExtensibilityElement((ExtensibilityElement)boc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.emcButtonGroup = new ButtonGroup();
        this.enableMIMEContentCB = new JCheckBox();
        this.bindingLabel = new JLabel();
        this.bindingName = new JLabel();
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("TOOLTIP_ENABLE_MIME"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setLabel(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENABLE_MIME_CONTENT"));
        this.bindingLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENCLOSING_BINDING"));
        this.bindingLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENCLOSING_BINDING"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.bindingLabel).add(22, 22, 22).add((Component)this.bindingName, -2, 139, -2)).add((Component)this.enableMIMEContentCB)).addContainerGap(201, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.bindingLabel).add((Component)this.bindingName)).addPreferredGap(0, 21, Short.MAX_VALUE).add((Component)this.enableMIMEContentCB).addContainerGap()));
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            EnableMIMEContent emc;
            WSDLComponent parent;
            Object source = evt.getSource();
            if (source instanceof EnableMIMEContent && ((parent = (WSDLComponent)(emc = (EnableMIMEContent)source).getParent()) instanceof DefinitionsCustomization || parent instanceof BindingCustomization)) {
                BindingOperationPanel.this.sync();
            }
        }
    }
}

