/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Properties;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Property;
import org.netbeans.modules.j2ee.persistence.provider.DefaultProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.AddEntityDialog;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.unit.PersistenceValidator;
import org.netbeans.modules.j2ee.persistence.util.PersistenceProviderComboboxHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.unit.JdbcListCellRenderer;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PersistenceUnitPanel
extends SectionInnerPanel {
    private final PersistenceUnit persistenceUnit;
    private PUDataObject dObj;
    private Project project;
    private boolean isContainerManaged;
    private JButton addClassButton;
    private ButtonGroup buttonGroup2;
    private JLabel datasourceLabel;
    private JRadioButton ddCreate;
    private JRadioButton ddDropCreate;
    private JRadioButton ddUnknown;
    private JComboBox dsCombo;
    private JList entityList;
    private JCheckBox includeAllEntities;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane2;
    private JComboBox jdbcComboBox;
    private JLabel jdbcLabel;
    private JCheckBox jtaCheckBox;
    private JComboBox libraryComboBox;
    private JLabel libraryLabel;
    private JTextField nameTextField;
    private JComboBox providerCombo;
    private JButton removeClassButton;
    private JLabel tableGenerationLabel;

    public PersistenceUnitPanel(SectionView view, PUDataObject dObj, PersistenceUnit persistenceUnit) {
        super(view);
        this.dObj = dObj;
        this.persistenceUnit = persistenceUnit;
        this.project = FileOwnerQuery.getOwner((FileObject)this.dObj.getPrimaryFile());
        assert (this.project != null) : "Could not resolve project for " + dObj.getPrimaryFile();
        this.isContainerManaged = ProviderUtil.getLibrary(persistenceUnit) != null && ProviderUtil.getConnection(persistenceUnit) != null ? false : (persistenceUnit.getJtaDataSource() != null || persistenceUnit.getNonJtaDataSource() != null ? true : Util.isSupportedJavaEEVersion(this.project));
        this.initComponents();
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (this.isContainerManaged) {
            PersistenceProviderComboboxHelper.connect(j2eeModuleProvider, this.providerCombo);
            Provider provider = ProviderUtil.getProvider(persistenceUnit);
            this.providerCombo.setSelectedItem(provider);
        } else {
            PersistenceProviderComboboxHelper.connect(j2eeModuleProvider, this.libraryComboBox);
            this.setSelectedLibrary();
        }
        this.setVisiblePanel();
        this.initIncludeAllEntities();
        this.initEntityList();
        this.initDataSource();
        this.initJdbcComboBox();
        this.nameTextField.setText(persistenceUnit.getName());
        this.setTableGeneration();
        this.handleCmAmSelection();
        this.registerModifiers();
    }

    private void registerModifiers() {
        if (this.isContainerManaged) {
            this.addImmediateModifier(this.dsCombo);
            this.addImmediateModifier(this.providerCombo);
            this.addImmediateModifier(this.jtaCheckBox);
        } else {
            this.addImmediateModifier(this.jdbcComboBox);
            this.addImmediateModifier(this.libraryComboBox);
        }
        this.addImmediateModifier(this.nameTextField);
        this.addImmediateModifier(this.ddDropCreate);
        this.addImmediateModifier(this.ddCreate);
        this.addImmediateModifier(this.ddUnknown);
        this.addImmediateModifier(this.includeAllEntities);
    }

    private void setVisiblePanel() {
        String panelName = this.isContainerManaged ? "container" : "application";
        ((CardLayout)this.jPanel3.getLayout()).show(this.jPanel3, panelName);
    }

    private void initDataSource() {
        this.jtaCheckBox.setEnabled(!Util.isJavaSE(this.project));
        if (this.isContainerManaged && ProviderUtil.isValidServerInstanceOrNone(this.project)) {
            String jtaDataSource = this.persistenceUnit.getJtaDataSource();
            String nonJtaDataSource = this.persistenceUnit.getNonJtaDataSource();
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null) {
                DatasourceUIHelper.connect((J2eeModuleProvider)j2eeModuleProvider, (JComboBox)this.dsCombo);
                this.addModifier((JTextComponent)this.dsCombo.getEditor().getEditorComponent(), false);
            }
            String jndiName = jtaDataSource != null ? jtaDataSource : nonJtaDataSource;
            this.selectDatasource(jndiName);
            this.jtaCheckBox.setSelected(jtaDataSource != null);
            String provider = this.persistenceUnit.getProvider();
            for (int i = 0; i < this.providerCombo.getItemCount(); ++i) {
                Object item = this.providerCombo.getItemAt(i);
                if (!(item instanceof Provider) || !((Provider)item).getProviderClass().equals(provider)) continue;
                this.providerCombo.setSelectedIndex(i);
                break;
            }
        } else if (!this.isContainerManaged) {
            this.setSelectedConnection();
            this.setSelectedLibrary();
            this.jtaCheckBox.setSelected(false);
        }
    }

    private void initJdbcComboBox() {
        DatabaseConnection[] connections = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < connections.length; ++i) {
            this.jdbcComboBox.addItem(connections[i]);
        }
        this.setSelectedConnection();
    }

    private void initIncludeAllEntities() {
        boolean javaSE = Util.isJavaSE(this.project);
        this.includeAllEntities.setEnabled(!javaSE);
        this.includeAllEntities.setSelected(!javaSE && !this.persistenceUnit.isExcludeUnlistedClasses());
        this.includeAllEntities.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_IncludeAllEntities", (Object[])new Object[]{ProjectUtils.getInformation((Project)this.project).getDisplayName()}));
    }

    private void initEntityList() {
        DefaultListModel<String> listedClassesModel = new DefaultListModel<String>();
        for (String elem : this.persistenceUnit.getClass2()) {
            listedClassesModel.addElement(elem);
        }
        this.entityList.setModel(listedClassesModel);
    }

    private void setSelectedLibrary() {
        Provider selected = ProviderUtil.getProvider(this.persistenceUnit);
        if (selected == null) {
            return;
        }
        for (int i = 0; i < this.libraryComboBox.getItemCount(); ++i) {
            Object item = this.libraryComboBox.getItemAt(i);
            Provider provider = (Provider)(item instanceof Provider ? item : null);
            if (provider == null || !provider.equals(selected)) continue;
            this.libraryComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Provider getSelectedProvider() {
        if (this.isContainerManaged) {
            return (Provider)this.providerCombo.getSelectedItem();
        }
        Object selectedItem = this.libraryComboBox.getSelectedItem();
        Provider provider = (Provider)(selectedItem instanceof Provider ? selectedItem : null);
        if (provider != null) {
            return provider;
        }
        return ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project);
    }

    private void setTableGeneration() {
        Provider provider = this.getSelectedProvider();
        Property tableGeneration = ProviderUtil.getProperty(this.persistenceUnit, provider.getTableGenerationPropertyName());
        if (tableGeneration != null) {
            if (provider.getTableGenerationCreateValue().equals(tableGeneration.getValue())) {
                this.ddCreate.setSelected(true);
            } else if (provider.getTableGenerationDropCreateValue().equals(tableGeneration.getValue())) {
                this.ddDropCreate.setSelected(true);
            }
        } else {
            this.ddUnknown.setSelected(true);
        }
        boolean toggle = provider.supportsTableGeneration();
        this.ddCreate.setEnabled(toggle);
        this.ddDropCreate.setEnabled(toggle);
        this.ddUnknown.setEnabled(toggle);
    }

    private void setSelectedConnection() {
        DatabaseConnection connection = ProviderUtil.getConnection(this.persistenceUnit);
        if (connection != null) {
            this.jdbcComboBox.setSelectedItem(connection);
        } else {
            Properties props = this.persistenceUnit.getProperties();
            if (props != null) {
                Property[] properties = props.getProperty2();
                String url = "custom";
                Provider provider = ProviderUtil.getProvider(this.persistenceUnit);
                for (int i = 0; i < properties.length; ++i) {
                    String key = properties[i].getName();
                    if (!key.equals(provider.getJdbcUrl())) continue;
                    url = properties[i].getValue();
                    break;
                }
                this.jdbcComboBox.addItem(url);
                this.jdbcComboBox.setSelectedItem(url);
            }
        }
    }

    public void setValue(JComponent source, Object value) {
        if (source == this.nameTextField) {
            this.persistenceUnit.setName((String)value);
        } else if (source == this.dsCombo) {
            this.setDataSource();
        } else if (source == this.dsCombo.getEditor().getEditorComponent()) {
            this.setDataSource((String)value);
        } else if (source == this.jdbcComboBox) {
            if (value instanceof DatabaseConnection) {
                ProviderUtil.setDatabaseConnection(this.persistenceUnit, (DatabaseConnection)value);
            }
        } else if (source == this.libraryComboBox) {
            this.setProvider();
            this.setTableGeneration();
        } else if (this.providerCombo == source) {
            this.setProvider();
            this.setDataSource();
        } else if (source == this.ddCreate || source == this.ddDropCreate || source == this.ddUnknown) {
            ProviderUtil.setTableGeneration(this.persistenceUnit, this.getTableGeneration(), ProviderUtil.getProvider(this.persistenceUnit.getProvider(), this.project));
        } else if (source == this.includeAllEntities) {
            this.persistenceUnit.setExcludeUnlistedClasses(!this.includeAllEntities.isSelected());
        } else if (source == this.jtaCheckBox) {
            this.setDataSource();
        }
        this.performValidation();
    }

    private void performValidation() {
        PersistenceValidator validator = new PersistenceValidator(this.dObj);
        List<Error> result = validator.validate();
        if (!result.isEmpty()) {
            this.getSectionView().getErrorPanel().setError(result.get(0));
        } else {
            this.getSectionView().getErrorPanel().clearError();
        }
    }

    private void setDataSource() {
        this.setDataSource(null);
    }

    private void setProvider() {
        if (this.isContainerManaged && this.providerCombo.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.providerCombo.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                this.persistenceUnit.setProvider(provider.getProviderClass());
                this.setTableGeneration();
            }
            ProviderUtil.makePortableIfPossible(this.project, this.persistenceUnit);
        } else if (this.libraryComboBox.getSelectedItem() instanceof Provider) {
            Provider provider = (Provider)this.libraryComboBox.getSelectedItem();
            ProviderUtil.removeProviderProperties(this.persistenceUnit);
            if (!(provider instanceof DefaultProvider)) {
                ProviderUtil.setProvider(this.persistenceUnit, provider, this.getSelectedConnection(), this.getTableGeneration());
            }
        }
    }

    private void setDataSource(String name) {
        String jndiName = name;
        if (jndiName == null) {
            int itemIndex = this.dsCombo.getSelectedIndex();
            Object item = this.dsCombo.getSelectedItem();
            if (item instanceof Datasource) {
                jndiName = ((Datasource)item).getJndiName();
            } else if (itemIndex == -1 && item != null) {
                jndiName = item.toString();
            }
        }
        if (jndiName == null) {
            return;
        }
        if (this.isJta()) {
            this.persistenceUnit.setJtaDataSource(jndiName);
            this.persistenceUnit.setNonJtaDataSource(null);
        } else {
            this.persistenceUnit.setJtaDataSource(null);
            this.persistenceUnit.setNonJtaDataSource(jndiName);
        }
    }

    private boolean isJta() {
        return this.jtaCheckBox.isEnabled() && this.jtaCheckBox.isSelected();
    }

    private String getTableGeneration() {
        if (this.ddCreate.isSelected()) {
            return "tableGenerationCreate";
        }
        if (this.ddDropCreate.isSelected()) {
            return "tableGenerationDropCreate";
        }
        return "tableGenerationUnknown";
    }

    private DatabaseConnection getSelectedConnection() {
        DatabaseConnection connection = null;
        if (this.jdbcComboBox.getSelectedItem() instanceof DatabaseConnection) {
            connection = (DatabaseConnection)this.jdbcComboBox.getSelectedItem();
        }
        return connection;
    }

    public void rollbackValue(JTextComponent source) {
        if (this.nameTextField == source) {
            this.nameTextField.setText(this.persistenceUnit.getName());
        } else if (this.dsCombo.getEditor().getEditorComponent() == source) {
            String jndiName = this.isJta() ? this.persistenceUnit.getJtaDataSource() : this.persistenceUnit.getNonJtaDataSource();
            this.selectDatasource(jndiName);
        }
    }

    private void selectDatasource(String jndiName) {
        Object item = this.findDatasource(jndiName);
        this.dsCombo.setSelectedItem(item);
        if (this.dsCombo.getEditor() != null) {
            this.dsCombo.configureEditor(this.dsCombo.getEditor(), item);
        }
    }

    private Object findDatasource(String jndiName) {
        if (jndiName != null) {
            int nItems = this.dsCombo.getItemCount();
            for (int i = 0; i < nItems; ++i) {
                Object item = this.dsCombo.getItemAt(i);
                if (!(item instanceof Datasource) || !jndiName.equals(((Datasource)item).getJndiName())) continue;
                return (Datasource)item;
            }
        }
        return jndiName;
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        if ("name".equals(errorId)) {
            return this.nameTextField;
        }
        return null;
    }

    private void handleCmAmSelection() {
        boolean isCm = this.isContainerManaged;
        this.datasourceLabel.setEnabled(isCm);
        this.dsCombo.setEnabled(isCm);
        this.jtaCheckBox.setEnabled(isCm && !Util.isJavaSE(this.project));
        this.libraryLabel.setEnabled(!isCm);
        this.libraryComboBox.setEnabled(!isCm);
        this.jdbcLabel.setEnabled(!isCm);
        this.jdbcComboBox.setEnabled(!isCm);
        this.setTableGeneration();
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.includeAllEntities = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.entityList = new JList();
        this.addClassButton = new JButton();
        this.removeClassButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jPanel7 = new JPanel();
        this.jLabel2 = new JLabel();
        this.nameTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jPanel6 = new JPanel();
        this.datasourceLabel = new JLabel();
        this.jtaCheckBox = new JCheckBox();
        this.dsCombo = new JComboBox();
        this.providerCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jPanel5 = new JPanel();
        this.libraryLabel = new JLabel();
        this.jdbcLabel = new JLabel();
        this.libraryComboBox = new JComboBox();
        this.jdbcComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.tableGenerationLabel = new JLabel();
        this.ddCreate = new JRadioButton();
        this.ddDropCreate = new JRadioButton();
        this.ddUnknown = new JRadioButton();
        this.jPanel2.setOpaque(false);
        this.includeAllEntities.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_IncludeAllEntities"));
        this.includeAllEntities.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.includeAllEntities.setMargin(new Insets(0, 0, 0, 0));
        this.includeAllEntities.setOpaque(false);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.includeAllEntities).addContainerGap(395, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.includeAllEntities).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setOpaque(false);
        this.jScrollPane2.setViewportView(this.entityList);
        this.addClassButton.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_AddClasses"));
        this.addClassButton.setOpaque(false);
        this.addClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.addClassButtonActionPerformed(evt);
            }
        });
        this.removeClassButton.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_RemoveClass"));
        this.removeClassButton.setOpaque(false);
        this.removeClassButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.removeClassButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_IncludeEntityClasses"));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jScrollPane2, -2, 449, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1, false).add((Component)this.addClassButton, -1, -1, Short.MAX_VALUE).add((Component)this.removeClassButton, -1, 125, Short.MAX_VALUE)).addPreferredGap(0, 20, Short.MAX_VALUE)).add(2, (Component)this.jLabel1, -1, 600, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.jLabel1, -2, 17, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add((Component)this.addClassButton, -2, 23, -2).addPreferredGap(0).add((Component)this.removeClassButton)).add((Component)this.jScrollPane2, -2, 96, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel7.setOpaque(false);
        this.jLabel2.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_UnitName"));
        GroupLayout jPanel7Layout = new GroupLayout((Container)this.jPanel7);
        this.jPanel7.setLayout((LayoutManager)jPanel7Layout);
        jPanel7Layout.setHorizontalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).add(32, 32, 32).add((Component)this.nameTextField, -2, 440, -2).addContainerGap(27, Short.MAX_VALUE)));
        jPanel7Layout.setVerticalGroup((GroupLayout.Group)jPanel7Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel7Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel7Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.nameTextField, -2, -1, -2)).addContainerGap()));
        this.jPanel3.setLayout(new CardLayout());
        this.jPanel3.setOpaque(false);
        this.jPanel6.setOpaque(false);
        this.datasourceLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_DatasourceName"));
        this.jtaCheckBox.setSelected(true);
        this.jtaCheckBox.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JTA"));
        this.jtaCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jtaCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jtaCheckBox.setOpaque(false);
        this.dsCombo.setEditable(true);
        this.providerCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/unit/Bundle").getString("LBL_Provider"));
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().add((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.datasourceLabel)).add(43, 43, 43).add((GroupLayout.Group)jPanel6Layout.createParallelGroup(1, false).add((Component)this.providerCombo, 0, -1, Short.MAX_VALUE).add((Component)this.dsCombo, 0, 436, Short.MAX_VALUE))).add((Component)this.jtaCheckBox)).add(79, 79, 79)));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel6Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.providerCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel6Layout.createParallelGroup(3).add((Component)this.datasourceLabel).add((Component)this.dsCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.jtaCheckBox).add(48, 48, 48)));
        this.jPanel3.add((Component)this.jPanel6, "container");
        this.jPanel5.setOpaque(false);
        this.libraryLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_PersistenceLibrary"));
        this.jdbcLabel.setText(NbBundle.getMessage(PersistenceUnitPanel.class, (String)"LBL_JdbcConnection"));
        this.libraryComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceUnitPanel.this.libraryComboBoxActionPerformed(evt);
            }
        });
        this.jdbcComboBox.setRenderer(new JdbcListCellRenderer());
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.libraryLabel).add((Component)this.jdbcLabel)).add(47, 47, 47).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1, false).add((Component)this.jdbcComboBox, 0, -1, Short.MAX_VALUE).add((Component)this.libraryComboBox, 0, 442, Short.MAX_VALUE)).addContainerGap(26, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.libraryLabel).add((Component)this.libraryComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel5Layout.createParallelGroup(3).add((Component)this.jdbcLabel).add((Component)this.jdbcComboBox, -2, -1, -2)).addContainerGap(37, Short.MAX_VALUE)));
        this.jPanel3.add((Component)this.jPanel5, "application");
        this.jPanel1.setOpaque(false);
        this.tableGenerationLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_TableGeneration"));
        this.buttonGroup2.add(this.ddCreate);
        this.ddCreate.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_Create"));
        this.ddCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddCreate.setMargin(new Insets(0, 0, 0, 0));
        this.ddCreate.setOpaque(false);
        this.buttonGroup2.add(this.ddDropCreate);
        this.ddDropCreate.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_DropCreate"));
        this.ddDropCreate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddDropCreate.setMargin(new Insets(0, 0, 0, 0));
        this.ddDropCreate.setOpaque(false);
        this.buttonGroup2.add(this.ddUnknown);
        this.ddUnknown.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/unit/Bundle").getString("LBL_None"));
        this.ddUnknown.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.ddUnknown.setMargin(new Insets(0, 0, 0, 0));
        this.ddUnknown.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.tableGenerationLabel).addPreferredGap(0).add((Component)this.ddCreate).addPreferredGap(0).add((Component)this.ddDropCreate).addPreferredGap(0).add((Component)this.ddUnknown).addContainerGap(272, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.ddCreate).add((Component)this.ddDropCreate).add((Component)this.ddUnknown).add((Component)this.tableGenerationLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel3, -1, 620, Short.MAX_VALUE).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel7, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel4, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel7, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, 98, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void removeClassButtonActionPerformed(ActionEvent evt) {
        Object[] values;
        for (Object value : values = this.entityList.getSelectedValues()) {
            this.dObj.removeClass(this.persistenceUnit, (String)value);
            ((DefaultListModel)this.entityList.getModel()).removeElement(value);
        }
    }

    private void addClassButtonActionPerformed(ActionEvent evt) {
        String[] existingClasses = this.persistenceUnit.getClass2();
        AddEntityDialog dialog = new AddEntityDialog(this.project, existingClasses);
        for (String entityClass : dialog.open()) {
            if (!this.dObj.addClass(this.persistenceUnit, entityClass)) continue;
            ((DefaultListModel)this.entityList.getModel()).addElement(entityClass);
        }
    }

    private void libraryComboBoxActionPerformed(ActionEvent evt) {
    }
}

