/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginProperties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "jboss-deployer:";
    private static final String DISCONNECTED_URI = "jboss-deployer:http://localhost:8080&";
    private static JBDeploymentFactory instance;
    private HashMap jbossFactories = new HashMap();
    private static final String INSTALL_ROOT_PROP_NAME = "org.netbeans.modules.j2ee.jboss4.installRoot";

    public static synchronized DeploymentFactory create() {
        if (instance == null) {
            instance = new JBDeploymentFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
            JBDeploymentFactory.registerDefaultServerInstance();
        }
        return instance;
    }

    public static URLClassLoader getJBClassLoader(String serverRoot) {
        try {
            URL[] urls = new URL[]{new File(serverRoot + "/client/jbossall-client.jar").toURI().toURL(), new File(serverRoot + "/client/jboss-common-client.jar").toURI().toURL(), new File(serverRoot + "/client/jboss-deployment.jar").toURI().toURL(), new File(serverRoot + "/client/jnp-client.jar").toURI().toURL(), new File(serverRoot + "/lib/dom4j.jar").toURI().toURL()};
            JBClassLoader loader = new JBClassLoader(urls, JBDeploymentFactory.class.getClassLoader());
            return loader;
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
    }

    public DeploymentFactory getFactory(String instanceURL) {
        DeploymentFactory jbossFactory = null;
        try {
            String jbossRoot = InstanceProperties.getInstanceProperties((String)instanceURL).getProperty("root-dir");
            if (jbossRoot == null) {
                jbossRoot = JBPluginProperties.getInstance().getInstallLocation();
            }
            if ((jbossFactory = (DeploymentFactory)this.jbossFactories.get(jbossRoot)) == null) {
                URLClassLoader loader = JBDeploymentFactory.getJBClassLoader(jbossRoot);
                jbossFactory = (DeploymentFactory)loader.loadClass("org.jboss.deployment.spi.factories.DeploymentFactoryImpl").newInstance();
                this.jbossFactories.put(jbossRoot, jbossFactory);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return jbossFactory;
    }

    public boolean handlesURI(String uri) {
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        DeploymentFactory df = this.getFactory(uri);
        if (df == null) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)uri));
        }
        String jbURI = uri;
        try {
            jbURI = uri.substring(0, uri.indexOf("&"));
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return new JBDeploymentManager(df.getDeploymentManager(jbURI, uname, passwd), uri, uname, passwd);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        DeploymentFactory df = null;
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        if (ip == null) {
            if (!DISCONNECTED_URI.equals(uri)) {
                throw new DeploymentManagerCreationException("JBoss instance " + uri + " is not registered in the IDE.");
            }
        } else {
            df = this.getFactory(uri);
            if (df == null) {
                throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)uri));
            }
        }
        String jbURI = uri;
        try {
            jbURI = uri.substring(0, uri.indexOf("&"));
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return new JBDeploymentManager(df != null ? df.getDisconnectedDeploymentManager(jbURI) : null, uri, null, null);
    }

    public String getProductVersion() {
        return NbBundle.getMessage(JBDeploymentFactory.class, (String)"LBL_JBossFactoryVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JBDeploymentFactory.class, (String)"SERVER_NAME");
    }

    private static void registerDefaultServerInstance() {
        try {
            FileObject serverInstanceDir = JBDeploymentFactory.getServerInstanceDir();
            String serverLocation = JBDeploymentFactory.getDefaultInstallLocation();
            String domainLocation = serverLocation + File.separator + "server" + File.separator + "default";
            JBDeploymentFactory.setRemovability(serverInstanceDir, domainLocation);
            if (JBPluginUtils.isGoodJBServerLocation(new File(serverLocation)) && JBPluginUtils.isGoodJBInstanceLocation(new File(domainLocation)) && !JBDeploymentFactory.isAlreadyRegistered(serverInstanceDir, domainLocation)) {
                String host = "localhost";
                String port = JBPluginUtils.getHTTPConnectorPort(domainLocation);
                JBDeploymentFactory.register(serverInstanceDir, serverLocation, domainLocation, host, port);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(4096, ioe.getMessage());
        }
    }

    private static String getDefaultInstallLocation() {
        String installRoot = System.getProperty(INSTALL_ROOT_PROP_NAME);
        if (installRoot != null && new File(installRoot).exists()) {
            return installRoot;
        }
        return "";
    }

    private static boolean isAlreadyRegistered(FileObject serverInstanceDir, String domainLocation) throws IOException {
        String domainLocationCan = new File(domainLocation).getCanonicalPath();
        for (FileObject instanceFO : serverInstanceDir.getChildren()) {
            String installedLocationCan;
            String installedLocation = (String)instanceFO.getAttribute("server-dir");
            if (installedLocation == null || !domainLocationCan.equals(installedLocationCan = new File(installedLocation).getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    private static void setRemovability(FileObject serverInstanceDir, String domainLocation) throws IOException {
        String domainLocationCan = new File(domainLocation).getCanonicalPath();
        for (FileObject instanceFO : serverInstanceDir.getChildren()) {
            String url = (String)instanceFO.getAttribute("url");
            if (!url.startsWith(URI_PREFIX)) continue;
            String installedLocation = (String)instanceFO.getAttribute("server-dir");
            String installedLocationCan = new File(installedLocation).getCanonicalPath();
            if (domainLocationCan.equals(installedLocationCan)) {
                instanceFO.setAttribute("removeForbidden", (Object)Boolean.TRUE);
                continue;
            }
            if (instanceFO.getAttribute("removeForbidden") == null) continue;
            instanceFO.setAttribute("removeForbidden", (Object)Boolean.FALSE);
        }
    }

    private static void register(FileObject serverInstanceDir, String serverLocation, String domainLocation, String host, String port) throws IOException {
        String displayName = JBDeploymentFactory.generateDisplayName(serverInstanceDir);
        String url = URI_PREFIX + host + ":" + port + "#default&" + serverLocation;
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"instance", null);
        FileObject instanceFO = serverInstanceDir.createData(name);
        instanceFO.setAttribute("url", (Object)url);
        instanceFO.setAttribute("username", (Object)"");
        instanceFO.setAttribute("password", (Object)"");
        instanceFO.setAttribute("displayName", (Object)displayName);
        instanceFO.setAttribute("removeForbidden", (Object)"true");
        instanceFO.setAttribute("server", (Object)"default");
        String deployDir = JBPluginUtils.getDeployDir(domainLocation);
        instanceFO.setAttribute("deploy-dir", (Object)deployDir);
        instanceFO.setAttribute("server-dir", (Object)domainLocation);
        instanceFO.setAttribute("root-dir", (Object)serverLocation);
        instanceFO.setAttribute("host", (Object)host);
        instanceFO.setAttribute("port", (Object)port);
    }

    private static FileObject getServerInstanceDir() {
        Repository rep = (Repository)Lookup.getDefault().lookup(Repository.class);
        FileObject dir = rep.getDefaultFileSystem().findResource("/J2EE/InstalledServers");
        return dir;
    }

    private static String generateDisplayName(FileObject serverInstanceDir) {
        String serverName;
        String instanceName = serverName = NbBundle.getMessage(JBDeploymentFactory.class, (String)"SERVER_NAME");
        int counter = 1;
        Set<String> registeredInstances = JBDeploymentFactory.getServerInstancesNames(serverInstanceDir);
        while (registeredInstances.contains(instanceName.toUpperCase())) {
            instanceName = serverName + " (" + String.valueOf(counter++) + ")";
        }
        return instanceName;
    }

    private static Set<String> getServerInstancesNames(FileObject serverInstanceDir) {
        HashSet<String> names = new HashSet<String>();
        for (FileObject instanceFO : serverInstanceDir.getChildren()) {
            String instanceName = (String)instanceFO.getAttribute("displayName");
            names.add(instanceName.toUpperCase());
        }
        return names;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JBClassLoader
    extends URLClassLoader {
        public JBClassLoader(URL[] urls, ClassLoader parent) throws MalformedURLException, RuntimeException {
            super(urls, parent);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions p = new Permissions();
            p.add(new AllPermission());
            return p;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.indexOf("jndi.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }
    }
}

