/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.api.DatasourceManager;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.gen.Datasources;
import org.netbeans.modules.j2ee.jboss4.config.gen.LocalTxDatasource;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JBossDatasourceManager
implements DatasourceManager {
    private static final String DSdotXML = "-ds.xml";
    private static final String JBossDSdotXML = "jboss-ds.xml";
    private FileObject serverDir;

    public JBossDatasourceManager(String serverUrl) {
        String serverDirPath = InstanceProperties.getInstanceProperties((String)serverUrl).getProperty("deploy-dir");
        this.serverDir = FileUtil.toFileObject((File)new File(serverDirPath));
    }

    public Set<Datasource> getDatasources() {
        HashSet<Datasource> datasources = new HashSet<Datasource>();
        if (!(this.serverDir != null && this.serverDir.isValid() && this.serverDir.isFolder() && this.serverDir.canRead())) {
            ErrorManager.getDefault().log(256, NbBundle.getMessage(JBossDatasourceManager.class, (String)"ERR_WRONG_DEPLOY_DIR"));
            return datasources;
        }
        Enumeration files = this.serverDir.getChildren(true);
        LinkedList<FileObject> confs = new LinkedList<FileObject>();
        while (files.hasMoreElements()) {
            FileObject file = (FileObject)files.nextElement();
            if (file.isFolder() || !file.getNameExt().endsWith(DSdotXML) || !file.canRead()) continue;
            confs.add(file);
        }
        if (confs.size() == 0) {
            return datasources;
        }
        Iterator it = confs.iterator();
        while (it.hasNext()) {
            try {
                FileObject dsFO = (FileObject)it.next();
                File dsFile = FileUtil.toFile((FileObject)dsFO);
                Datasources ds = Datasources.createGraph(dsFile);
                LocalTxDatasource[] ltxds = ds.getLocalTxDatasource();
                for (int i = 0; i < ltxds.length; ++i) {
                    if (ltxds[i].getJndiName().length() <= 0) continue;
                    datasources.add(new JBossDatasource(ltxds[i].getJndiName(), ltxds[i].getConnectionUrl(), ltxds[i].getUserName(), ltxds[i].getPassword(), ltxds[i].getDriverClass()));
                }
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
            catch (RuntimeException re) {
            }
        }
        return datasources;
    }

    public void deployDatasources(Set<Datasource> datasources) throws ConfigurationException, DatasourceAlreadyExistsException {
        Set<Datasource> deployedDS = this.getDatasources();
        Map<String, Datasource> ddsMap = this.transform(deployedDS);
        HashMap<String, JBossDatasource> newDS = new HashMap<String, JBossDatasource>();
        LinkedList<Datasource> conflictDS = new LinkedList<Datasource>();
        for (Datasource o : datasources) {
            if (!(o instanceof JBossDatasource)) continue;
            JBossDatasource ds = (JBossDatasource)o;
            String jndiName = ds.getJndiName();
            if (ddsMap.keySet().contains(jndiName)) {
                if (ddsMap.get(jndiName).equals(ds)) continue;
                conflictDS.add(ddsMap.get(jndiName));
                continue;
            }
            if (jndiName == null) continue;
            newDS.put(jndiName, ds);
        }
        if (conflictDS.size() > 0) {
            throw new DatasourceAlreadyExistsException(conflictDS);
        }
        FileObject dsXmlFo = this.serverDir.getFileObject(JBossDSdotXML);
        File dsXMLFile = dsXmlFo != null ? FileUtil.toFile((FileObject)dsXmlFo) : null;
        Datasources deployedDSGraph = null;
        try {
            deployedDSGraph = dsXMLFile != null ? Datasources.createGraph(dsXMLFile) : new Datasources();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().annotate((Throwable)ioe, NbBundle.getMessage(this.getClass(), (String)"ERR_CannotReadDSdotXml"));
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
            return;
        }
        LocalTxDatasource[] ltxds = deployedDSGraph.getLocalTxDatasource();
        for (int i = 0; i < ltxds.length; ++i) {
            String jndiName = ltxds[i].getJndiName();
            if (!newDS.keySet().contains(jndiName)) continue;
            deployedDSGraph.removeLocalTxDatasource(ltxds[i]);
        }
        for (JBossDatasource ds : newDS.values()) {
            LocalTxDatasource lds = new LocalTxDatasource();
            lds.setJndiName(ds.getJndiName());
            lds.setConnectionUrl(ds.getUrl());
            lds.setDriverClass(ds.getDriverClassName());
            lds.setUserName(ds.getUsername());
            lds.setPassword(ds.getPassword());
            lds.setMinPoolSize(ds.getMinPoolSize());
            lds.setMaxPoolSize(ds.getMaxPoolSize());
            lds.setIdleTimeoutMinutes(ds.getIdleTimeoutMinutes());
            deployedDSGraph.addLocalTxDatasource(lds);
        }
        if (newDS.size() > 0) {
            if (dsXMLFile == null) {
                try {
                    dsXmlFo = this.serverDir.createData(JBossDSdotXML);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().annotate((Throwable)ioe, NbBundle.getMessage(this.getClass(), (String)"ERR_CannotCreateDSdotXml"));
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    return;
                }
                dsXMLFile = FileUtil.toFile((FileObject)dsXmlFo);
            }
            this.writeFile(dsXMLFile, deployedDSGraph);
        }
    }

    private Map<String, Datasource> transform(Set<Datasource> datasources) {
        HashMap<String, Datasource> map = new HashMap<String, Datasource>();
        for (JBossDatasource jBossDatasource : datasources) {
            if (jBossDatasource.getJndiName() == null) continue;
            map.put(jBossDatasource.getJndiName(), jBossDatasource);
        }
        return map;
    }

    private void writeFile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileSystem fs = this.serverDir.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream os = null;
                    FileLock lock = null;
                    try {
                        String name = file.getName();
                        FileObject configFO = JBossDatasourceManager.this.serverDir.getFileObject(name);
                        if (configFO == null) {
                            configFO = JBossDatasourceManager.this.serverDir.createData(name);
                        }
                        lock = configFO.lock();
                        os = new BufferedOutputStream(configFO.getOutputStream(lock), 4096);
                        if (bean != null) {
                            bean.write(os);
                        }
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getLocalizedMessage());
        }
    }
}

