/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openide.ErrorManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBPluginUtils {
    public static final String SERVER_XML = File.separator + "deploy" + File.separator + "jbossweb-tomcat55.sar" + File.separator + "server.xml";
    private static Collection serverFileColl = new ArrayList();
    private static Collection fileColl;

    public static Hashtable getRegisteredDomains(String serverLocation) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (JBPluginUtils.isGoodJBServerLocation(new File(serverLocation))) {
            File file = new File(serverLocation + File.separator + "server");
            String[] files = file.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return new File(dir.getAbsolutePath() + File.separator + name).isDirectory();
                }
            });
            for (int i = 0; i < files.length; ++i) {
                String path = file.getAbsolutePath() + File.separator + files[i];
                if (!JBPluginUtils.isGoodJBInstanceLocation(new File(path))) continue;
                result.put(files[i], path);
            }
        }
        return result;
    }

    public static boolean isGoodJBInstanceLocation(File candidate) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && JBPluginUtils.hasRequiredChildren(candidate, serverFileColl);
    }

    public static boolean isGoodJBServerLocation(File candidate) {
        return null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && JBPluginUtils.hasRequiredChildren(candidate, fileColl);
    }

    private static boolean hasRequiredChildren(File candidate, Collection requiredChildren) {
        if (null == candidate) {
            return false;
        }
        String[] children = candidate.list();
        if (null == children) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        for (String next : requiredChildren) {
            File test = new File(candidate.getPath() + File.separator + next);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    public static String getDeployDir(String domainDir) {
        String result = "";
        result = domainDir + File.separator + "deploy";
        return result;
    }

    public static String getHTTPConnectorPort(String domainDir) {
        String defaultPort = "8080";
        String serverXml = domainDir + SERVER_XML;
        File serverXmlFile = new File(serverXml);
        if (!serverXmlFile.exists()) {
            return defaultPort;
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(serverXmlFile);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("Service")) continue;
                NodeList nl = child.getChildNodes();
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("Connector")) continue;
                    return ch.getAttributes().getNamedItem("port").getNodeValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultPort;
    }

    public static String getJnpPort(String domainDir) {
        String serviceXml = domainDir + File.separator + "conf" + File.separator + "jboss-service.xml";
        File xmlFile = new File(serviceXml);
        if (!xmlFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("mbean")) continue;
                NodeList nl = child.getChildNodes();
                if (!child.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=Naming")) continue;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("attribute") || !ch.getAttributes().getNamedItem("name").getNodeValue().equals("Port")) continue;
                    return ch.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return "";
    }

    public static String getRMINamingServicePort(String domainDir) {
        String serviceXml = domainDir + File.separator + "conf" + File.separator + "jboss-service.xml";
        File xmlFile = new File(serviceXml);
        if (!xmlFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("mbean")) continue;
                NodeList nl = child.getChildNodes();
                if (!child.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=Naming")) continue;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("attribute") || !ch.getAttributes().getNamedItem("name").getNodeValue().equals("RmiPort")) continue;
                    return ch.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return "";
    }

    public static String getRMIInvokerPort(String domainDir) {
        String serviceXml = domainDir + File.separator + "conf" + File.separator + "jboss-service.xml";
        File xmlFile = new File(serviceXml);
        if (!xmlFile.exists()) {
            return "";
        }
        FileInputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new FileInputStream(xmlFile);
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().equals("mbean")) continue;
                NodeList nl = child.getChildNodes();
                if (!child.getAttributes().getNamedItem("name").getNodeValue().equals("jboss:service=invoker,type=jrmp")) continue;
                for (int j = 0; j < nl.getLength(); ++j) {
                    Node ch = nl.item(j);
                    if (!ch.getNodeName().equals("attribute") || !ch.getAttributes().getNamedItem("name").getNodeValue().equals("RMIObjectPort")) continue;
                    return ch.getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortFree(int port) {
        ServerSocket soc = null;
        try {
            soc = new ServerSocket(port);
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (soc != null) {
                try {
                    soc.close();
                }
                catch (IOException ex) {}
            }
        }
        return true;
    }

    static {
        serverFileColl.add("conf");
        serverFileColl.add("deploy");
        serverFileColl.add("lib");
        serverFileColl.add("conf/jboss-service.xml");
        serverFileColl.add("lib/jboss-j2ee.jar");
        serverFileColl.add("lib/jboss.jar");
        serverFileColl.add("lib/jbosssx.jar");
        serverFileColl.add("lib/jboss-transaction.jar");
        serverFileColl.add("lib/jmx-adaptor-plugin.jar");
        serverFileColl.add("lib/jnpserver.jar");
        serverFileColl.add("lib/log4j.jar");
        serverFileColl.add("lib/xmlentitymgr.jar");
        serverFileColl.add("deploy/jmx-invoker-service.xml");
        fileColl = new ArrayList();
        fileColl.add("bin");
        fileColl.add("client");
        fileColl.add("lib");
        fileColl.add("server");
        fileColl.add("lib/jboss-common.jar");
        fileColl.add("lib/endorsed/resolver.jar");
    }
}

