/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class I18nWizardDescriptor
extends WizardDescriptor {
    public static final Dimension PREFERRED_DIMENSION = new Dimension(500, 300);
    private final WizardDescriptor.Iterator panels;
    private final Settings settings;
    private final JButton nextButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton();
    private PropertyChangeListener rootListener;
    static /* synthetic */ Class class$java$awt$Dialog;

    private I18nWizardDescriptor(WizardDescriptor.Iterator panels, Settings settings) {
        super(panels, (Object)settings);
        Listener listener = new Listener();
        this.nextButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Next"));
        this.nextButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_NEXT"));
        this.previousButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Previous"));
        this.previousButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_PREVIOUS"));
        this.finishButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Finish"));
        this.finishButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_FINISH"));
        this.cancelButton.setText(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("ACSD_CANCEL"));
        this.nextButton.addActionListener(listener);
        this.previousButton.addActionListener(listener);
        this.finishButton.addActionListener(listener);
        this.cancelButton.addActionListener(listener);
        this.nextButton.setMnemonic(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Next_Mnem").charAt(0));
        this.previousButton.setMnemonic(NbBundle.getBundle((Class)I18nWizardDescriptor.class).getString("CTL_Previous_Mnem").charAt(0));
        this.setOptions(new Object[]{this.previousButton, this.nextButton, this.finishButton, this.cancelButton});
        this.setClosingOptions(new Object[]{this.cancelButton});
        this.panels = panels;
        this.settings = settings;
    }

    static WizardDescriptor createI18nWizardDescriptor(WizardDescriptor.Iterator panels, Settings settings) {
        return new I18nWizardDescriptor(panels, settings);
    }

    protected synchronized void updateState() {
        super.updateState();
        WizardDescriptor.Panel current = this.panels.current();
        boolean next = this.panels.hasNext();
        boolean prev = this.panels.hasPrevious();
        boolean valid = current.isValid();
        this.nextButton.setEnabled(next && valid);
        this.previousButton.setEnabled(prev);
        this.finishButton.setEnabled(valid && (!next || current instanceof WizardDescriptor.FinishablePanel && ((WizardDescriptor.FinishablePanel)current).isFinishPanel()));
        if (next) {
            this.setValue(this.nextButton);
        } else {
            this.setValue(this.finishButton);
        }
        this.setHelpCtx(current.getHelp());
        this.updateDefaultButton();
    }

    private void updateDefaultButton() {
        JRootPane root = this.getRootPane();
        if (root == null) {
            return;
        }
        WizardDescriptor.Panel panel = this.panels.current();
        if (panel instanceof WizardDescriptor.FinishablePanel && ((WizardDescriptor.FinishablePanel)panel).isFinishPanel()) {
            root.setDefaultButton(this.finishButton);
        } else {
            root.setDefaultButton(this.nextButton);
        }
    }

    private JRootPane getRootPane() {
        JRootPane rootPane = null;
        Component comp = this.panels.current().getComponent();
        if (comp instanceof JComponent) {
            rootPane = ((JComponent)comp).getRootPane();
        }
        if (rootPane != null && this.rootListener == null) {
            this.rootListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    Object newValue;
                    if ("defaultButton".equals(evt.getPropertyName()) && (newValue = evt.getNewValue()) != I18nWizardDescriptor.this.nextButton && newValue != I18nWizardDescriptor.this.finishButton) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                I18nWizardDescriptor.this.updateDefaultButton();
                            }
                        });
                    }
                }
            };
            rootPane.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.rootListener, (Object)rootPane));
        }
        return rootPane;
    }

    public static class Settings {
        public Map map;
        public Project project;

        public Settings(Map map, Project project) {
            this.map = map;
            this.project = project;
        }
    }

    public static abstract class Panel
    implements WizardDescriptor.Panel {
        private Component component;
        private ChangeListener changeListener;
        private Settings settings = null;

        public final synchronized Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
            }
            return this.component;
        }

        protected abstract Component createComponent();

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object settings) {
            this.settings = (Settings)settings;
        }

        public void storeSettings(Object settings) {
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeListener = listener;
        }

        public void removeChangeListener(ChangeListener listener) {
            if (this.changeListener != null && this.changeListener == listener) {
                this.changeListener = null;
            }
        }

        public final void fireStateChanged() {
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Project getProject() {
            return this.settings.project;
        }

        public Map getMap() {
            return this.settings.map;
        }
    }

    public static interface ProgressMonitor {
        public void doLongTimeChanges();

        public void reset();
    }

    private abstract class ProgressThread
    implements Runnable {
        private ProgressMonitor progressMonitor;

        public ProgressThread(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                I18nWizardDescriptor.this.previousButton.setEnabled(false);
                I18nWizardDescriptor.this.nextButton.setEnabled(false);
                I18nWizardDescriptor.this.finishButton.setEnabled(false);
                I18nWizardDescriptor.this.cancelButton.setEnabled(false);
                this.progressMonitor.doLongTimeChanges();
                this.handleAction();
            }
            finally {
                this.progressMonitor.reset();
                I18nWizardDescriptor.this.cancelButton.setEnabled(true);
            }
        }

        public abstract void handleAction();
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == I18nWizardDescriptor.this.nextButton) {
                WizardDescriptor.Panel current = I18nWizardDescriptor.this.panels.current();
                if (current instanceof ProgressMonitor) {
                    RequestProcessor.getDefault().post((Runnable)new ProgressThread((ProgressMonitor)current){

                        public void handleAction() {
                            Listener.this.handleNextButton();
                        }
                    });
                } else {
                    this.handleNextButton();
                }
            } else if (evt.getSource() == I18nWizardDescriptor.this.previousButton) {
                I18nWizardDescriptor.this.panels.previousPanel();
                I18nWizardDescriptor.this.updateState();
            } else if (evt.getSource() == I18nWizardDescriptor.this.finishButton) {
                final WizardDescriptor.Panel current = I18nWizardDescriptor.this.panels.current();
                current.storeSettings((Object)I18nWizardDescriptor.this.settings);
                I18nWizardDescriptor.this.setValue(NotifyDescriptor.OK_OPTION);
                if (current instanceof ProgressMonitor) {
                    RequestProcessor.getDefault().post((Runnable)new ProgressThread((ProgressMonitor)current){

                        public void handleAction() {
                            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = I18nWizardDescriptor.class$("java.awt.Dialog")) : class$java$awt$Dialog, current.getComponent());
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                }
            } else if (evt.getSource() == I18nWizardDescriptor.this.cancelButton) {
                I18nWizardDescriptor.this.panels.current().storeSettings((Object)I18nWizardDescriptor.this.settings);
                I18nWizardDescriptor.this.setValue(NotifyDescriptor.CANCEL_OPTION);
            }
        }

        private void handleNextButton() {
            Runnable performer = new Runnable(){

                public void run() {
                    I18nWizardDescriptor.this.panels.nextPanel();
                    try {
                        I18nWizardDescriptor.this.updateState();
                    }
                    catch (IllegalStateException ise) {
                        I18nWizardDescriptor.this.panels.previousPanel();
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ise.getMessage()));
                        I18nWizardDescriptor.this.updateState();
                    }
                    WizardDescriptor.Panel current = I18nWizardDescriptor.this.panels.current();
                    current.getComponent().requestFocus();
                }
            };
            Mutex.EVENT.writeAccess(performer);
        }
    }
}

