/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

final class SourceWizardPanel
extends JPanel {
    private final Map sourceMap = Util.createWizardSourceMap();
    private final Panel descPanel;
    private boolean testRole = false;
    private JButton addButton;
    private JTextArea descTextArea;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JList sourcesList;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    private SourceWizardPanel(Panel descPanel, boolean testRole) {
        this.descPanel = descPanel;
        this.testRole = testRole;
        this.initComponents();
        this.initAccessibility();
        this.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
        this.initList();
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
        if (testRole) {
            this.setName(Util.getString("TXT_SelecTestSources"));
        } else {
            this.setName(Util.getString("TXT_SelectSources"));
        }
    }

    public Map getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.sourcesList.setListData(sourceMap.keySet().toArray());
        this.descPanel.fireStateChanged();
    }

    private String getPanelDescription() {
        if (!this.testRole) {
            return Util.getString("MSG_SourcesPanel_desc");
        }
        return Util.getString("MSG_SourcesPanel_test_desc");
    }

    private String getAccessibleListDescription() {
        if (!this.testRole) {
            return Util.getString("ACSD_sourcesList");
        }
        return Util.getString("ACSD_sourcesList_test");
    }

    private void initList() {
        this.sourcesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                SourceWizardPanel.this.removeButton.setEnabled(!SourceWizardPanel.this.sourcesList.isSelectionEmpty());
            }
        });
        this.removeButton.setEnabled(!this.sourcesList.isSelectionEmpty());
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.getPanelDescription());
        this.addButton.setToolTipText(Util.getString("CTL_AddSource_desc"));
        this.addButton.setMnemonic(Util.getChar("CTL_AddSource_Mnem"));
        this.removeButton.setToolTipText(Util.getString("CTL_RemoveSource_desc"));
        this.removeButton.setMnemonic(Util.getChar("CTL_RemoveSource_Mnem"));
        this.sourcesList.getAccessibleContext().setAccessibleName(Util.getString("ACSN_sourcesList"));
        this.sourcesList.getAccessibleContext().setAccessibleDescription(this.getAccessibleListDescription());
    }

    private void initComponents() {
        this.descTextArea = new JTextArea();
        this.jScrollPane1 = new JScrollPane();
        this.sourcesList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.descTextArea.setEditable(false);
        this.descTextArea.setLineWrap(true);
        this.descTextArea.setText(this.getPanelDescription());
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setDisabledTextColor(new JLabel().getForeground());
        this.descTextArea.setEnabled(false);
        this.descTextArea.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.descTextArea, gridBagConstraints);
        this.sourcesList.setCellRenderer(new DataObjectListCellRenderer());
        this.jScrollPane1.setViewportView(this.sourcesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText(NbBundle.getBundle((Class)SourceWizardPanel.class).getString("CTL_AddSource"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceWizardPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getBundle((Class)SourceWizardPanel.class).getString("CTL_RemoveSource"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceWizardPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object[] selected = this.sourcesList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            this.sourceMap.remove(selected[i]);
        }
        this.sourcesList.setListData(this.sourceMap.keySet().toArray());
        this.descPanel.fireStateChanged();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        Project prj = this.descPanel.getProject();
        try {
            Node[] selectedNodes = NodeOperation.getDefault().select(Util.getString("LBL_SelectSources"), Util.getString("LBL_Filesystems"), SelectorUtils.sourcesNode(prj, SelectorUtils.ALL_FILTER), new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes == null || nodes.length == 0) {
                        return false;
                    }
                    for (int i = 0; i < nodes.length; ++i) {
                        Node.Cookie dataObject = nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SourceWizardPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                        if (dataObject == null) {
                            return false;
                        }
                        if (!(dataObject instanceof DataFolder ? I18nUtil.containsAcceptedDataObject((DataFolder)dataObject) : FactoryRegistry.hasFactory(dataObject.getClass()))) continue;
                        return true;
                    }
                    return false;
                }
            });
            for (int i = 0; i < selectedNodes.length; ++i) {
                DataObject dataObject = (DataObject)selectedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? SourceWizardPanel.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject instanceof DataFolder) {
                    Iterator it = I18nUtil.getAcceptedDataObjects((DataObject.Container)((DataFolder)dataObject)).iterator();
                    while (it.hasNext()) {
                        Util.addSource(this.sourceMap, (DataObject)it.next());
                    }
                    continue;
                }
                Util.addSource(this.sourceMap, dataObject);
            }
            this.sourcesList.setListData(this.sourceMap.keySet().toArray());
            this.descPanel.fireStateChanged();
        }
        catch (UserCancelException userCancelException) {
            // empty catch block
        }
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel {
        private final boolean testWizard;

        public Panel() {
            this(false);
        }

        public Panel(boolean testWizard) {
            this.testWizard = testWizard;
        }

        protected Component createComponent() {
            SourceWizardPanel component = new SourceWizardPanel(this, this.testWizard);
            return component;
        }

        public boolean isValid() {
            return !((SourceWizardPanel)this.getComponent()).getSourceMap().isEmpty();
        }

        public void readSettings(Object settings) {
            super.readSettings(settings);
            ((SourceWizardPanel)this.getComponent()).setSourceMap(this.getMap());
        }

        public void storeSettings(Object settings) {
            super.storeSettings(settings);
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(((SourceWizardPanel)this.getComponent()).getSourceMap());
        }

        public HelpCtx getHelp() {
            if (this.testWizard) {
                return new HelpCtx("internation.testing");
            }
            return new HelpCtx("internation.wizard");
        }
    }

    public static class DataObjectListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DataObject dataObject = (DataObject)value;
            if (dataObject != null) {
                ClassPath cp = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                label.setText(cp.getResourceName(dataObject.getPrimaryFile(), '.', false));
                label.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
            } else {
                label.setText("");
                label.setIcon(null);
            }
            return label;
        }
    }
}

