/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever;

import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.xml.retriever.CertificationPanel;
import org.netbeans.modules.xml.retriever.ResourceRetriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLResourceRetriever
implements ResourceRetriever {
    private static Set<X509Certificate> acceptedCertificates;
    private static final String URI_SCHEME = "http";
    long streamLength = 0L;

    @Override
    public boolean accept(String baseAddr, String currentAddr) throws URISyntaxException {
        URI baseURI;
        URI currURI = new URI(currentAddr);
        if (currURI.isAbsolute() && currURI.getScheme().equalsIgnoreCase(URI_SCHEME)) {
            return true;
        }
        return baseAddr != null && !currURI.isAbsolute() && (baseURI = new URI(baseAddr)).getScheme().toLowerCase().startsWith(URI_SCHEME);
    }

    @Override
    public HashMap<String, InputStream> retrieveDocument(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        String effAddr = this.getEffectiveAddress(baseAddress, documentAddress);
        if (effAddr == null) {
            return null;
        }
        URI currURI = new URI(effAddr);
        HashMap<String, InputStream> result = null;
        if (currURI.toASCIIString().startsWith("https")) {
            if (acceptedCertificates == null) {
                acceptedCertificates = new HashSet<X509Certificate>();
            }
            this.setRetrieverTrustManager();
        }
        InputStream is = this.getInputStreamOfURL(currURI.toURL(), ProxySelector.getDefault().select(currURI).get(0));
        result = new HashMap<String, InputStream>();
        result.put(currURI.toString(), is);
        return result;
    }

    public InputStream getInputStreamOfURL(URL downloadURL, Proxy proxy) throws IOException {
        Object expn = null;
        URLConnection ucn = null;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        ucn = proxy != null ? downloadURL.openConnection(proxy) : downloadURL.openConnection();
        ucn.setReadTimeout(10000);
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        ucn.connect();
        InputStream is = ucn.getInputStream();
        this.streamLength = ucn.getContentLength();
        return is;
    }

    @Override
    public long getStreamLength() {
        return this.streamLength;
    }

    private void setRetrieverTrustManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                if (certs != null) {
                    for (int i = 0; i < certs.length; ++i) {
                        if (acceptedCertificates.contains(certs[i])) continue;
                        DialogDescriptor desc = new DialogDescriptor((Object)new CertificationPanel(certs[i]), NbBundle.getMessage(URLResourceRetriever.class, (String)"TTL_CertifiedWebSite"), true, 0, DialogDescriptor.YES_OPTION, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        if (DialogDescriptor.YES_OPTION.equals(desc.getValue())) {
                            acceptedCertificates.add(certs[i]);
                            continue;
                        }
                        throw new CertificateException(NbBundle.getMessage(URLResourceRetriever.class, (String)"ERR_NotTrustedCertificate"));
                    }
                }
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
        }
        catch (GeneralSecurityException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    @Override
    public String getEffectiveAddress(String baseAddress, String documentAddress) throws IOException, URISyntaxException {
        URI currURI = new URI(documentAddress);
        String result = null;
        if (currURI.isAbsolute()) {
            result = currURI.toString();
            return result;
        }
        if (baseAddress != null) {
            URI baseURI = new URI(baseAddress);
            URI finalURI = baseURI.resolve(currURI);
            result = finalURI.toString();
            return result;
        }
        return null;
    }
}

