/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResults;

public class Validator
implements Serializable {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$validator$Validator == null ? (class$org$apache$commons$validator$Validator = Validator.class$("org.apache.commons.validator.Validator")) : class$org$apache$commons$validator$Validator));
    public static final String BEAN_PARAM = "java.lang.Object";
    public static final String BEAN_KEY = "java.lang.Object";
    public static final String VALIDATOR_ACTION_PARAM = "org.apache.commons.validator.ValidatorAction";
    public static final String VALIDATOR_ACTION_KEY = "org.apache.commons.validator.ValidatorAction";
    public static final String FIELD_PARAM = "org.apache.commons.validator.Field";
    public static final String FIELD_KEY = "org.apache.commons.validator.Field";
    public static final String VALIDATOR_PARAM = "org.apache.commons.validator.Validator";
    public static final String VALIDATOR_KEY = "org.apache.commons.validator.Validator";
    public static final String LOCALE_PARAM = "java.util.Locale";
    public static final String LOCALE_KEY = "java.util.Locale";
    protected ValidatorResources resources = null;
    protected String formName = null;
    protected Map parameters = new HashMap();
    protected HashMap hResources = (HashMap)this.parameters;
    protected int page = 0;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    protected boolean onlyReturnErrors = false;
    static /* synthetic */ Class class$org$apache$commons$validator$Validator;

    public Validator(ValidatorResources resources) {
        this(resources, null);
    }

    public Validator(ValidatorResources resources, String formName) {
        if (resources == null) {
            throw new IllegalArgumentException("Resources cannot be null.");
        }
        this.resources = resources;
        this.formName = formName;
    }

    public void addResource(String parameterClassName, Object parameterValue) {
        this.setParameter(parameterClassName, parameterValue);
    }

    public void setParameter(String parameterClassName, Object parameterValue) {
        this.parameters.put(parameterClassName, parameterValue);
    }

    public Object getResource(String parameterClassName) {
        return this.getParameterValue(parameterClassName);
    }

    public Object getParameterValue(String parameterClassName) {
        return this.parameters.get(parameterClassName);
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void clear() {
        this.formName = null;
        this.parameters = new HashMap();
        this.hResources = (HashMap)this.parameters;
        this.page = 0;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public ClassLoader getClassLoader() {
        ClassLoader contextLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (contextLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return contextLoader;
        }
        return this.getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ValidatorResults validate() throws ValidatorException {
        Locale locale = (Locale)this.getParameterValue("java.util.Locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setParameter("org.apache.commons.validator.Validator", this);
        Form form = this.resources.getForm(locale, this.formName);
        if (form != null) {
            return form.validate(this.parameters, this.resources.getValidatorActions(), this.page);
        }
        return new ValidatorResults();
    }

    public boolean getOnlyReturnErrors() {
        return this.onlyReturnErrors;
    }

    public void setOnlyReturnErrors(boolean onlyReturnErrors) {
        this.onlyReturnErrors = onlyReturnErrors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

