/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModuleContainer;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.ui.FileChooser;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.netbeans.modules.web.project.ui.wizards.ImportWebProjectWizardIterator;
import org.netbeans.modules.web.project.ui.wizards.J2eeVersionWarningPanel;
import org.netbeans.modules.web.project.ui.wizards.PanelOptionsVisual;
import org.netbeans.modules.web.project.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.web.project.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.web.project.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ImportLocationVisual
extends SettingsPanel
implements HelpCtx.Provider {
    private ImportWebProjectWizardIterator.ThePanel panel;
    private Document moduleDocument;
    private Document nameDocument;
    private boolean contextModified = false;
    private boolean locationModified = false;
    private boolean locationComputed = false;
    private WizardDescriptor wizardDescriptor;
    private J2eeVersionWarningPanel warningPanel;
    private String generatedProjectName = "";
    private int generatedProjectNameIndex = 0;
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private List earProjects;
    private static final String J2EE_SPEC_13_LABEL = NbBundle.getMessage(ImportLocationVisual.class, (String)"J2EESpecLevel_13");
    private static final String J2EE_SPEC_14_LABEL = NbBundle.getMessage(ImportLocationVisual.class, (String)"J2EESpecLevel_14");
    private static final String JAVA_EE_5_LABEL = NbBundle.getMessage(ImportLocationVisual.class, (String)"JavaEESpecLevel_50");
    private JComboBox j2eeSpecComboBox;
    private JLabel j2eeSpecLabel;
    private JButton jButtonPrjLocation;
    private JButton jButtonSrcLocation;
    private JComboBox jComboBoxEnterprise;
    private JLabel jLabelContextPath;
    private JLabel jLabelEnterprise;
    private JLabel jLabelPrjLocation;
    private JLabel jLabelPrjLocationDesc;
    private JLabel jLabelPrjName;
    private JLabel jLabelSrcLocation;
    private JLabel jLabelSrcLocationDesc;
    private JPanel jPanel1;
    private JPanel jPanelOptions;
    private JSeparator jSeparator1;
    protected JTextField jTextFieldContextPath;
    private JButton manageServersButton;
    public JTextField moduleLocationTextField;
    public JTextField projectLocationTextField;
    public JTextField projectNameTextField;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JCheckBox setAsMainCheckBox;
    private JPanel warningPlaceHolderPanel;
    private String lastComputedPrjName = null;
    private String lastComputedPrjFolder = null;
    private String lastComputedContextPath = null;
    boolean ignoreLocEvent = false;
    boolean ignoreNameEvent = false;

    public ImportLocationVisual(ImportWebProjectWizardIterator.ThePanel panel) {
        this.panel = panel;
        this.initComponents();
        this.initServers(FoldersListSettings.getDefault().getLastUsedServer());
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        this.initEnterpriseApplications();
        this.setJ2eeVersionWarningPanel();
        this.computeSize();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_NWP1_NamePanel_A11YDesc"));
        this.setName(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_ImportTitle"));
        this.moduleDocument = this.moduleLocationTextField.getDocument();
        this.nameDocument = this.projectNameTextField.getDocument();
        this.moduleLocationTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ImportLocationVisual.this.locationDataChanged(e);
            }

            public void insertUpdate(DocumentEvent e) {
                ImportLocationVisual.this.locationDataChanged(e);
            }

            public void removeUpdate(DocumentEvent e) {
                ImportLocationVisual.this.locationDataChanged(e);
            }
        });
        this.projectNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ImportLocationVisual.this.nameDataChanged(e);
            }

            public void insertUpdate(DocumentEvent e) {
                ImportLocationVisual.this.nameDataChanged(e);
            }

            public void removeUpdate(DocumentEvent e) {
                ImportLocationVisual.this.nameDataChanged(e);
            }
        });
        this.projectLocationTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ImportLocationVisual.this.fireChanges();
            }

            public void insertUpdate(DocumentEvent e) {
                ImportLocationVisual.this.fireChanges();
            }

            public void removeUpdate(DocumentEvent e) {
                ImportLocationVisual.this.fireChanges();
            }
        });
    }

    private void computeSize() {
        int height;
        double srcLocLabelLength = this.jLabelSrcLocationDesc.getFontMetrics(this.jLabelSrcLocationDesc.getFont()).getStringBounds(this.jLabelSrcLocationDesc.getText(), this.getGraphics()).getWidth() * 0.85;
        int width = new Double(srcLocLabelLength).intValue();
        if (width < 500) {
            width = 500;
        }
        if ((height = this.jComboBoxEnterprise.getFontMetrics(this.jComboBoxEnterprise.getFont()).getHeight() * 13 + 150) > 340) {
            Dimension dim = new Dimension(width, height);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
        }
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        File projectLocation = (File)settings.getProperty("projdir");
        projectLocation = projectLocation == null || projectLocation.getParentFile() == null || !projectLocation.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : projectLocation.getParentFile();
        if (this.generatedProjectNameIndex == 0) {
            this.generatedProjectName = (String)settings.getProperty("name");
            if (this.generatedProjectName == null) {
                this.generatedProjectNameIndex = FoldersListSettings.getDefault().getNewProjectCount() + 1;
                String formater = NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NPW1_DefaultProjectName");
                while ((this.generatedProjectName = this.validFreeProjectName(projectLocation, formater, this.generatedProjectNameIndex)) == null) {
                    ++this.generatedProjectNameIndex;
                }
                settings.putProperty("nameIndex", (Object)new Integer(this.generatedProjectNameIndex));
            }
            this.moduleLocationTextField.selectAll();
        }
    }

    void store(WizardDescriptor settings) {
        String contextPath;
        File srcRoot = null;
        String srcPath = this.moduleLocationTextField.getText();
        if (srcPath.length() > 0) {
            srcRoot = FileUtil.normalizeFile((File)new File(srcPath));
        }
        FoldersListSettings.getDefault().setLastUsedImportLocation(srcRoot);
        settings.putProperty("sourceRoot", (Object)srcRoot);
        settings.putProperty("name", (Object)this.projectNameTextField.getText().trim());
        String projectLocation = this.projectLocationTextField.getText().trim();
        if (projectLocation.length() >= 0) {
            settings.putProperty("projdir", (Object)new File(projectLocation));
        }
        if (!(contextPath = this.jTextFieldContextPath.getText().trim()).startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        settings.putProperty("contextPath", (Object)contextPath);
        Integer nameIndex = this.projectNameTextField.getText().equals(this.generatedProjectName) ? new Integer(this.generatedProjectNameIndex) : null;
        settings.putProperty("nameIndex", (Object)nameIndex);
        settings.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        settings.putProperty("serverInstanceID", (Object)this.getSelectedServer());
        settings.putProperty("j2eeLevel", (Object)this.getSelectedJ2eeSpec());
        settings.putProperty("earApplication", (Object)this.getSelectedEarApplication());
        if (this.warningPanel != null && this.warningPanel.getDowngradeAllowed()) {
            settings.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            String j2ee = this.getSelectedJ2eeSpec();
            if (j2ee != null) {
                String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
                FoldersListSettings fls = FoldersListSettings.getDefault();
                String srcLevel = "1.6";
                if (warningType.equals("warnSetSourceLevel14") && fls.isAgreedSetSourceLevel14()) {
                    srcLevel = "1.4";
                } else if (warningType.equals("warnSetSourceLevel15") && fls.isAgreedSetSourceLevel15()) {
                    srcLevel = "1.5";
                }
                settings.putProperty("setSourceLevel", (Object)srcLevel);
            }
        } else {
            settings.putProperty("setSourceLevel", null);
        }
    }

    boolean valid(WizardDescriptor settings) {
        String sourceLocationPath = this.moduleLocationTextField.getText().trim();
        if (sourceLocationPath.length() == 0) {
            this.setErrorMessage("MSG_ProvideExistingSourcesLocation");
            return false;
        }
        File f = new File(sourceLocationPath);
        if (!f.isDirectory() || !f.canRead()) {
            String format = NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_IllegalSources");
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(format, sourceLocationPath));
            return false;
        }
        String projectLocationPath = this.projectLocationTextField.getText().trim();
        f = new File(projectLocationPath);
        String projectName = this.projectNameTextField.getText().trim();
        f = new File(f, projectName);
        if ((f = PanelProjectLocationVisual.getCanonicalFile(f)) == null || !projectName.equals(f.getName())) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProvideProjectName"));
            return false;
        }
        if (projectLocationPath.length() == 0) {
            this.setErrorMessage("MSG_ProvideProjectFolder");
            return false;
        }
        File projectLocation = this.locationComputed ? ProjectChooser.getProjectsFolder() : new File(projectLocationPath);
        if (projectLocation.exists() && !projectLocation.canWrite()) {
            this.setErrorMessage("MSG_ProjectLocationRO");
            return false;
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocationPath));
        if (destFolder.isDirectory()) {
            FileObject destFO = FileUtil.toFileObject((File)destFolder);
            assert (destFO != null) : "No FileObject for " + destFolder;
            boolean clear = false;
            try {
                clear = ProjectManager.getDefault().findProject(destFO) == null;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!clear) {
                this.setErrorMessage("MSG_ProjectFolderHasDeletedProject");
                return false;
            }
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_NetBeansProject");
                } else if ("build".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_BuildFolder");
                } else if ("WEB-INF".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_WebInfFolder");
                } else if ("dist".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_DistFolder");
                } else if ("manifest.mf".equals(childName)) {
                    file = NbBundle.getMessage(ImportLocationVisual.class, (String)"TXT_Manifest");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage(ImportLocationVisual.class, (String)"MSG_ProjectFolderInvalid");
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)MessageFormat.format(format, file));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    private void setErrorMessage(String messageId) {
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", messageId == null ? null : NbBundle.getMessage(ImportLocationVisual.class, (String)messageId));
    }

    private void initComponents() {
        this.jLabelSrcLocationDesc = new JLabel();
        this.jLabelSrcLocation = new JLabel();
        this.moduleLocationTextField = new JTextField();
        this.jButtonSrcLocation = new JButton();
        this.jLabelPrjLocationDesc = new JLabel();
        this.jLabelPrjName = new JLabel();
        this.projectNameTextField = new JTextField();
        this.jLabelPrjLocation = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.jButtonPrjLocation = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanelOptions = new JPanel();
        this.jLabelEnterprise = new JLabel();
        this.jComboBoxEnterprise = new JComboBox();
        this.setAsMainCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.j2eeSpecLabel = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.jLabelContextPath = new JLabel();
        this.jTextFieldContextPath = new JTextField();
        this.manageServersButton = new JButton();
        this.warningPlaceHolderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabelSrcLocationDesc, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_LocationSrcDesc"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabelSrcLocationDesc, gridBagConstraints);
        this.jLabelSrcLocation.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_ImportLocation_LabelMnemonic").charAt(0));
        this.jLabelSrcLocation.setHorizontalAlignment(2);
        this.jLabelSrcLocation.setLabelFor(this.moduleLocationTextField);
        this.jLabelSrcLocation.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_LocationSrc_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelSrcLocation, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.moduleLocationTextField, gridBagConstraints);
        this.moduleLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_IW_ImportLocation_A11YDesc"));
        this.jButtonSrcLocation.setMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_BrowseLocation_MNE").charAt(0));
        this.jButtonSrcLocation.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.jButtonSrcLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.jButtonSrcLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonSrcLocation, gridBagConstraints);
        this.jButtonSrcLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_IW_ImportLocationBrowse_A11YDesc"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelPrjLocationDesc, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_LocationPrjDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jLabelPrjLocationDesc, gridBagConstraints);
        this.jLabelPrjName.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_ProjectName_LabelMnemonic").charAt(0));
        this.jLabelPrjName.setHorizontalAlignment(2);
        this.jLabelPrjName.setLabelFor(this.projectNameTextField);
        this.jLabelPrjName.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.jLabelPrjName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_ProjectName_A11YDesc"));
        this.jLabelPrjLocation.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_LabelMnemonic").charAt(0));
        this.jLabelPrjLocation.setHorizontalAlignment(2);
        this.jLabelPrjLocation.setLabelFor(this.projectLocationTextField);
        this.jLabelPrjLocation.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.jLabelPrjLocation, gridBagConstraints);
        this.projectLocationTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ImportLocationVisual.this.projectLocationTextFieldKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NPW1_ProjectLocation_A11YDesc"));
        this.jButtonPrjLocation.setMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_BrowseProjectFolder_MNE").charAt(0));
        this.jButtonPrjLocation.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.jButtonPrjLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.jButtonPrjLocationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jButtonPrjLocation, gridBagConstraints);
        this.jButtonPrjLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_BrowseLocation_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanelOptions.setLayout(new GridBagLayout());
        this.jLabelEnterprise.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_AddToEnterprise_LabelMnemonic").charAt(0));
        this.jLabelEnterprise.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_AddToEnterprise_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPanelOptions.add((Component)this.jLabelEnterprise, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPanelOptions.add((Component)this.jComboBoxEnterprise, gridBagConstraints);
        this.jComboBoxEnterprise.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_AddToEnterpriseComboBox_A11YDesc"));
        this.setAsMainCheckBox.setMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBoxMnemonic").charAt(0));
        this.setAsMainCheckBox.setSelected(true);
        this.setAsMainCheckBox.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanelOptions.add((Component)this.setAsMainCheckBox, gridBagConstraints);
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_SetAsMain_A11YDesc"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.serverInstanceLabel.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_Server_LabelMnemonic").charAt(0));
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        this.serverInstanceLabel.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_Server"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.jPanel1.add((Component)this.serverInstanceLabel, gridBagConstraints);
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.serverInstanceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.serverInstanceComboBox, gridBagConstraints);
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleName("Server");
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_NWP1_Server_ComboBox_A11YDesc"));
        this.j2eeSpecLabel.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_J2EESpecLevel_CheckBoxMnemonic").charAt(0));
        this.j2eeSpecLabel.setLabelFor(this.j2eeSpecComboBox);
        this.j2eeSpecLabel.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 11);
        this.jPanel1.add((Component)this.j2eeSpecLabel, gridBagConstraints);
        this.j2eeSpecComboBox.setPrototypeDisplayValue("MMMMMMMMM");
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel1.add((Component)this.j2eeSpecComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleName("J2EE Version");
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NPW1_J2EESpecLevel_A11YDesc"));
        this.jLabelContextPath.setDisplayedMnemonic(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_ContextPath_CheckBoxMnemonic").charAt(0));
        this.jLabelContextPath.setLabelFor(this.jTextFieldContextPath);
        this.jLabelContextPath.setText(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_NWP1_ContextPath_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.jPanel1.add((Component)this.jLabelContextPath, gridBagConstraints);
        this.jTextFieldContextPath.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ImportLocationVisual.this.jTextFieldContextPathKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.jPanel1.add((Component)this.jTextFieldContextPath, gridBagConstraints);
        this.jTextFieldContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportLocationVisual.class, (String)"ACS_LBL_NWP1_ContextPath_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageServersButton, (String)NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_ManageServers"));
        this.manageServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImportLocationVisual.this.manageServersButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.jPanel1.add((Component)this.manageServersButton, gridBagConstraints);
        this.manageServersButton.getAccessibleContext().setAccessibleName(null);
        this.manageServersButton.getAccessibleContext().setAccessibleDescription(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanelOptions.add((Component)this.jPanel1, gridBagConstraints);
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanelOptions.add((Component)this.warningPlaceHolderPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanelOptions, gridBagConstraints);
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        this.setJ2eeVersionWarningPanel();
    }

    private void manageServersButtonActionPerformed(ActionEvent evt) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = serverInstanceWrapper.getServerInstanceID();
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        String lastSelectedJ2eeSpecLevel = (String)this.j2eeSpecComboBox.getSelectedItem();
        this.initServers(lastSelectedServerInstanceID);
        if (lastSelectedJ2eeSpecLevel != null) {
            this.j2eeSpecComboBox.setSelectedItem(lastSelectedJ2eeSpecLevel);
        }
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent evt) {
        String prevSelectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID());
            Set supportedVersions = j2eePlatform.getSupportedSpecVersions(J2eeModule.WAR);
            this.j2eeSpecComboBox.removeAllItems();
            if (supportedVersions.contains("1.5")) {
                this.j2eeSpecComboBox.addItem(JAVA_EE_5_LABEL);
            }
            if (supportedVersions.contains("1.4")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_14_LABEL);
            }
            if (supportedVersions.contains("1.3")) {
                this.j2eeSpecComboBox.addItem(J2EE_SPEC_13_LABEL);
            }
            if (prevSelectedItem != null) {
                this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
            }
        } else {
            this.j2eeSpecComboBox.removeAllItems();
        }
        this.panel.fireChangeEvent();
    }

    private void projectLocationTextFieldKeyReleased(KeyEvent evt) {
        this.locationModified = true;
    }

    private void jTextFieldContextPathKeyReleased(KeyEvent evt) {
        this.contextModified = true;
    }

    private void jButtonPrjLocationActionPerformed(ActionEvent evt) {
        FileChooser chooser = FileChooser.createDirectoryChooser("ImportLocationVisual.Project", this.projectLocationTextField.getText());
        chooser.setDialogTitle(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_BrowseProjectFolder"));
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(projectDir.getAbsolutePath());
        }
    }

    private void jButtonSrcLocationActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(NbBundle.getMessage(ImportLocationVisual.class, (String)"LBL_IW_BrowseExistingSource"));
        if (this.moduleLocationTextField.getText().length() > 0 && this.getProjectLocation().exists()) {
            chooser.setSelectedFile(this.getProjectLocation());
        } else {
            File existingSourcesFile;
            File currentDirectory = null;
            FileObject existingSourcesFO = Templates.getExistingSourcesFolder((WizardDescriptor)this.wizardDescriptor);
            if (existingSourcesFO != null && (existingSourcesFile = FileUtil.toFile((FileObject)existingSourcesFO)) != null && existingSourcesFile.isDirectory()) {
                currentDirectory = existingSourcesFile;
            }
            if (currentDirectory != null) {
                chooser.setCurrentDirectory(currentDirectory);
            } else {
                File lastUsedImportLoc = FoldersListSettings.getDefault().getLastUsedImportLocation();
                if (lastUsedImportLoc != null) {
                    chooser.setCurrentDirectory(lastUsedImportLoc.getParentFile());
                } else {
                    chooser.setSelectedFile(ProjectChooser.getProjectsFolder());
                }
            }
        }
        if (0 == chooser.showOpenDialog(this)) {
            File projectDir = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.moduleLocationTextField.setText(projectDir.getAbsolutePath());
        }
    }

    private String computeProjectName() {
        String cPrjName = null;
        FileObject fo = FileUtil.toFileObject((File)this.getProjectLocation());
        if (fo != null) {
            cPrjName = fo.getName();
        }
        return cPrjName;
    }

    private String computeProjectFolder() {
        return this.getProjectLocation().getAbsolutePath();
    }

    private String computeContextPath() {
        return Utils.createDefaultContext(this.projectNameTextField.getText());
    }

    private void locationDataChanged(DocumentEvent de) {
        if (!this.ignoreLocEvent) {
            this.ignoreLocEvent = true;
            if (de.getDocument() == this.moduleDocument) {
                this.updateProjectName();
                this.updateProjectFolder();
            }
            this.ignoreLocEvent = false;
        }
        this.fireChanges();
    }

    private void nameDataChanged(DocumentEvent de) {
        if (!this.ignoreNameEvent) {
            this.ignoreNameEvent = true;
            if (de.getDocument() == this.nameDocument) {
                this.updateProjectFolder();
                this.updateContextPath();
            }
            this.ignoreNameEvent = false;
        }
        this.fireChanges();
    }

    private void updateProjectName() {
        String prjName = this.computeProjectName();
        if (this.lastComputedPrjName != null && !this.lastComputedPrjName.equals(this.projectNameTextField.getText().trim())) {
            return;
        }
        this.lastComputedPrjName = prjName;
        if (prjName != null) {
            this.projectNameTextField.setText(prjName);
        }
    }

    private void updateProjectFolder() {
        String prjFolder = this.computeProjectFolder();
        if (this.lastComputedPrjFolder != null && !this.lastComputedPrjFolder.equals(this.projectLocationTextField.getText().trim())) {
            return;
        }
        this.lastComputedPrjFolder = prjFolder;
        if (prjFolder != null) {
            this.projectLocationTextField.setText(prjFolder);
        } else {
            this.projectLocationTextField.setText("");
        }
    }

    private void updateContextPath() {
        String ctxPath = this.computeContextPath();
        if (this.lastComputedContextPath != null && !this.lastComputedContextPath.equals(this.jTextFieldContextPath.getText().trim())) {
            return;
        }
        this.lastComputedContextPath = ctxPath;
        if (ctxPath != null) {
            this.jTextFieldContextPath.setText(ctxPath);
        }
    }

    private void fireChanges() {
        this.panel.fireChangeEvent();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ImportLocationVisual.class);
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        boolean sjasFound = false;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            String displayName = Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID);
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
            if (displayName == null || j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.WAR)) continue;
            ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
            if (selectedItem == null || !sjasFound) {
                if (selectedServerInstanceID != null) {
                    if (selectedServerInstanceID.equals(serverInstanceID)) {
                        selectedItem = serverWrapper;
                    }
                } else {
                    String shortName = Deployment.getDefault().getServerID(serverInstanceID);
                    if ("J2EE".equals(shortName)) {
                        selectedItem = serverWrapper;
                        sjasFound = true;
                    } else if ("JBoss4".equals(shortName)) {
                        selectedItem = serverWrapper;
                    }
                }
            }
            servers.add(serverWrapper);
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    private Project getSelectedEarApplication() {
        int idx = this.jComboBoxEnterprise.getSelectedIndex();
        return idx <= 0 ? null : (Project)this.earProjects.get(idx - 1);
    }

    private void initEnterpriseApplications() {
        this.jComboBoxEnterprise.addItem(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_AddToEnterprise_None"));
        this.jComboBoxEnterprise.setSelectedIndex(0);
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        this.earProjects = new ArrayList();
        for (int i = 0; i < allProjects.length; ++i) {
            J2eeModuleContainer container = (J2eeModuleContainer)allProjects[i].getLookup().lookup(J2eeModuleContainer.class);
            ProjectInformation projectInfo = ProjectUtils.getInformation((Project)allProjects[i]);
            if (container == null) continue;
            this.earProjects.add(projectInfo.getProject());
            this.jComboBoxEnterprise.addItem(projectInfo.getDisplayName());
        }
        if (this.earProjects.size() <= 0) {
            this.jComboBoxEnterprise.setEnabled(false);
        }
    }

    private String getSelectedJ2eeSpec() {
        Object item = this.j2eeSpecComboBox.getSelectedItem();
        String value = null;
        if (item != null) {
            if (item.equals(JAVA_EE_5_LABEL)) {
                value = "1.5";
            } else if (item.equals(J2EE_SPEC_14_LABEL)) {
                value = "1.4";
            } else if (item.equals(J2EE_SPEC_13_LABEL)) {
                value = "1.3";
            }
        }
        return value;
    }

    private String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    private String validFreeProjectName(File parentFolder, String formater, int index) {
        String name = MessageFormat.format(formater, new Integer(index));
        File file = new File(parentFolder, name);
        return file.exists() ? null : name;
    }

    private void setJ2eeVersionWarningPanel() {
        String j2ee = this.getSelectedJ2eeSpec();
        if (j2ee == null) {
            return;
        }
        String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
        if (warningType == null && this.warningPanel == null) {
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(warningType);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
            this.warningPanel.setWarningType(warningType);
        } else {
            this.warningPanel.setWarningType(warningType);
        }
    }

    public File getProjectLocation() {
        return this.getAsFile(this.moduleLocationTextField.getText());
    }

    private File getAsFile(String filename) {
        return FileUtil.normalizeFile((File)new File(filename));
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

