/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.spi.debugger.jpda.EditorContext;

public class EditorContextBridge {
    public static final String FIELD = "field";
    public static final String METHOD = "method";
    public static final String CLASS = "class";
    public static final String LINE = "line";
    private static EditorContext context;

    private static EditorContext getContext() {
        if (context == null) {
            List l = DebuggerManager.getDebuggerManager().lookup(null, EditorContext.class);
            context = (EditorContext)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                context = new CompoundContextProvider((EditorContext)l.get(i), context);
            }
        }
        return context;
    }

    public static boolean showSource(String url, int lineNumber, Object timeStamp) {
        return EditorContextBridge.getContext().showSource(url, lineNumber, timeStamp);
    }

    public static void createTimeStamp(Object timeStamp) {
        EditorContextBridge.getContext().createTimeStamp(timeStamp);
    }

    public static void disposeTimeStamp(Object timeStamp) {
        EditorContextBridge.getContext().disposeTimeStamp(timeStamp);
    }

    public static Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return EditorContextBridge.getContext().annotate(url, lineNumber, annotationType, timeStamp);
    }

    public static void removeAnnotation(Object annotation) {
        EditorContextBridge.getContext().removeAnnotation(annotation);
    }

    public static int getLineNumber(Object annotation, Object timeStamp) {
        return EditorContextBridge.getContext().getLineNumber(annotation, timeStamp);
    }

    public static int getCurrentLineNumber() {
        return EditorContextBridge.getContext().getCurrentLineNumber();
    }

    public static String getCurrentClassName() {
        return EditorContextBridge.getContext().getCurrentClassName();
    }

    public static String getCurrentURL() {
        return EditorContextBridge.getContext().getCurrentURL();
    }

    public static String getCurrentMethodName() {
        return EditorContextBridge.getContext().getCurrentMethodName();
    }

    public static String getCurrentFieldName() {
        return EditorContextBridge.getContext().getCurrentFieldName();
    }

    public static String getSelectedIdentifier() {
        return EditorContextBridge.getContext().getSelectedIdentifier();
    }

    public static String getSelectedMethodName() {
        return EditorContextBridge.getContext().getSelectedMethodName();
    }

    public static int getFieldLineNumber(String url, String className, String fieldName) {
        return EditorContextBridge.getContext().getFieldLineNumber(url, className, fieldName);
    }

    public static String getClassName(String url, int lineNumber) {
        return EditorContextBridge.getContext().getClassName(url, lineNumber);
    }

    public static String[] getImports(String url) {
        return EditorContextBridge.getContext().getImports(url);
    }

    public static void addPropertyChangeListener(PropertyChangeListener l) {
        EditorContextBridge.getContext().addPropertyChangeListener(l);
    }

    public static void removePropertyChangeListener(PropertyChangeListener l) {
        EditorContextBridge.getContext().removePropertyChangeListener(l);
    }

    public static String getFileName(LineBreakpoint b) {
        try {
            return new File(new URL(b.getURL()).getFile()).getName();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean showSource(LineBreakpoint b, Object timeStamp) {
        if (b.getLineNumber() < 1) {
            return EditorContextBridge.showSource(b.getURL(), 1, timeStamp);
        }
        return EditorContextBridge.showSource(b.getURL(), b.getLineNumber(), timeStamp);
    }

    public static String getDefaultType() {
        String id = EditorContextBridge.getSelectedIdentifier();
        if (id != null) {
            if (id.equals(EditorContextBridge.getCurrentMethodName())) {
                return METHOD;
            }
            String s = EditorContextBridge.getCurrentClassName();
            int i = s.lastIndexOf(46);
            if (i >= 0) {
                s = s.substring(i + 1);
            }
            if (id.equals(s)) {
                return CLASS;
            }
            return FIELD;
        }
        String s = EditorContextBridge.getCurrentFieldName();
        if (s != null && s.length() > 0) {
            return FIELD;
        }
        s = EditorContextBridge.getCurrentMethodName();
        if (s != null && s.length() > 0) {
            return METHOD;
        }
        if (s != null && s.length() < 1 && (s = EditorContextBridge.getCurrentClassName()).length() > 0) {
            return CLASS;
        }
        return CLASS;
    }

    public static Object annotate(LineBreakpoint b) {
        boolean isConditional;
        String url = b.getURL();
        int lineNumber = b.getLineNumber();
        if (lineNumber < 1) {
            return null;
        }
        String condition = b.getCondition();
        boolean bl = isConditional = condition != null && !condition.trim().equals("");
        String annotationType = b.isEnabled() ? (isConditional ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (isConditional ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        return EditorContextBridge.annotate(url, lineNumber, annotationType, null);
    }

    public static String getRelativePath(JPDAThread thread, String stratumn) {
        try {
            return EditorContextBridge.convertSlash(thread.getSourcePath(stratumn));
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.getRelativePath(thread.getClassName());
        }
    }

    public static String getRelativePath(CallStackFrame csf, String stratumn) {
        try {
            return EditorContextBridge.convertSlash(csf.getSourcePath(stratumn));
        }
        catch (AbsentInformationException e) {
            return EditorContextBridge.getRelativePath(csf.getClassName());
        }
    }

    public static String getRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    private static class CompoundAnnotation {
        Object annotation1;
        Object annotation2;
    }

    private static class CompoundContextProvider
    extends EditorContext {
        private EditorContext cp1;
        private EditorContext cp2;

        CompoundContextProvider(EditorContext cp1, EditorContext cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public void createTimeStamp(Object timeStamp) {
            this.cp1.createTimeStamp(timeStamp);
            this.cp2.createTimeStamp(timeStamp);
        }

        public void disposeTimeStamp(Object timeStamp) {
            this.cp1.disposeTimeStamp(timeStamp);
            this.cp2.disposeTimeStamp(timeStamp);
        }

        public void updateTimeStamp(Object timeStamp, String url) {
            this.cp1.updateTimeStamp(timeStamp, url);
            this.cp2.updateTimeStamp(timeStamp, url);
        }

        public String getCurrentClassName() {
            String s = this.cp1.getCurrentClassName();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentClassName();
            }
            return s;
        }

        public String getCurrentURL() {
            String s = this.cp1.getCurrentURL();
            if (s.trim().length() < 1) {
                return this.cp2.getCurrentURL();
            }
            return s;
        }

        public String getCurrentFieldName() {
            String s = this.cp1.getCurrentFieldName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentFieldName();
            }
            return s;
        }

        public int getCurrentLineNumber() {
            int i = this.cp1.getCurrentLineNumber();
            if (i < 1) {
                return this.cp2.getCurrentLineNumber();
            }
            return i;
        }

        public String getCurrentMethodName() {
            String s = this.cp1.getCurrentMethodName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getCurrentMethodName();
            }
            return s;
        }

        public String getSelectedIdentifier() {
            String s = this.cp1.getSelectedIdentifier();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedIdentifier();
            }
            return s;
        }

        public String getSelectedMethodName() {
            String s = this.cp1.getSelectedMethodName();
            if (s == null || s.trim().length() < 1) {
                return this.cp2.getSelectedMethodName();
            }
            return s;
        }

        public void removeAnnotation(Object annotation) {
            CompoundAnnotation ca = (CompoundAnnotation)annotation;
            this.cp1.removeAnnotation(ca.annotation1);
            this.cp2.removeAnnotation(ca.annotation2);
        }

        public Object annotate(String sourceName, int lineNumber, String annotationType, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            ca.annotation1 = this.cp1.annotate(sourceName, lineNumber, annotationType, timeStamp);
            ca.annotation2 = this.cp2.annotate(sourceName, lineNumber, annotationType, timeStamp);
            return ca;
        }

        public int getLineNumber(Object annotation, Object timeStamp) {
            CompoundAnnotation ca = new CompoundAnnotation();
            int ln = this.cp1.getLineNumber(ca.annotation1, timeStamp);
            if (ln >= 0) {
                return ln;
            }
            return this.cp2.getLineNumber(ca.annotation2, timeStamp);
        }

        public boolean showSource(String sourceName, int lineNumber, Object timeStamp) {
            return this.cp1.showSource(sourceName, lineNumber, timeStamp) | this.cp2.showSource(sourceName, lineNumber, timeStamp);
        }

        public int getFieldLineNumber(String url, String className, String fieldName) {
            int ln = this.cp1.getFieldLineNumber(url, className, fieldName);
            if (ln != -1) {
                return ln;
            }
            return this.cp2.getFieldLineNumber(url, className, fieldName);
        }

        public String getClassName(String url, int lineNumber) {
            String className = this.cp1.getClassName(url, lineNumber);
            if (className != null) {
                return className;
            }
            return this.cp2.getClassName(url, lineNumber);
        }

        public String[] getImports(String url) {
            String[] r1 = this.cp1.getImports(url);
            String[] r2 = this.cp2.getImports(url);
            String[] r = new String[r1.length + r2.length];
            System.arraycopy(r1, 0, r, 0, r1.length);
            System.arraycopy(r2, 0, r, r1.length, r2.length);
            return r;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(propertyName, l);
            this.cp2.addPropertyChangeListener(propertyName, l);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(propertyName, l);
            this.cp2.removePropertyChangeListener(propertyName, l);
        }
    }
}

