/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.StepRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.SmartSteppingFilter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.CompoundSmartSteppingListener;
import org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider;
import org.netbeans.modules.debugger.jpda.actions.SmartSteppingFilterImpl;
import org.netbeans.modules.debugger.jpda.actions.StepIntoActionProvider;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class StepActionProvider
extends JPDADebuggerActionProvider
implements Executor {
    private StepRequest stepRequest;
    private ContextProvider lookupProvider;
    private static boolean ssverbose = System.getProperty("netbeans.debugger.smartstepping") != null;
    private static boolean verbose = System.getProperty("netbeans.debugger.jdievents") != null;
    private StepIntoActionProvider stepIntoActionProvider;
    private SmartSteppingFilterImpl smartSteppingFilterImpl;
    private CompoundSmartSteppingListener compoundSmartSteppingListener;

    private static int getJDIAction(Object action) {
        if (action == ActionsManager.ACTION_STEP_OUT) {
            return 3;
        }
        if (action == ActionsManager.ACTION_STEP_OVER) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public StepActionProvider(ContextProvider lookupProvider) {
        super((JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class)));
        this.lookupProvider = lookupProvider;
        this.setProviderToDisableOnLazyAction(this);
    }

    public Set getActions() {
        return new HashSet<Object>(Arrays.asList(ActionsManager.ACTION_STEP_OUT, ActionsManager.ACTION_STEP_OVER));
    }

    public void doAction(Object action) {
        this.runAction(action);
    }

    public void postAction(final Object action, final Runnable actionPerformedNotifier) {
        this.doLazyAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    StepActionProvider.this.runAction(action);
                }
                finally {
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(Object action) {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            try {
                ThreadReference tr = ((JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread()).getThreadReference();
                this.removeStepRequests(tr);
                VirtualMachine vm = this.getDebuggerImpl().getVirtualMachine();
                if (vm == null) {
                    return;
                }
                this.stepRequest = vm.eventRequestManager().createStepRequest(tr, -2, StepActionProvider.getJDIAction(action));
                this.stepRequest.addCountFilter(1);
                this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                this.stepRequest.setSuspendPolicy(this.getDebuggerImpl().getSuspend());
                this.stepRequest.enable();
                if (verbose) {
                    System.out.println("JDI Request: " + this.stepRequest);
                }
                this.getDebuggerImpl().resume();
            }
            catch (VMDisconnectedException e) {
                ErrorManager.getDefault().notify(256, ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)StepActionProvider.class, (String)"VMDisconnected")));
            }
        }
    }

    protected void checkEnabled(int debuggerState) {
        Iterator i = this.getActions().iterator();
        while (i.hasNext()) {
            Object e = i.next();
            this.getDebuggerImpl();
            this.setEnabled(e, debuggerState == 3 && this.getDebuggerImpl().getCurrentThread() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(Event ev) {
        Object object = this.getDebuggerImpl().LOCK;
        synchronized (object) {
            LocatableEvent event = (LocatableEvent)ev;
            String className = event.location().declaringType().name();
            ThreadReference tr = event.thread();
            JPDAThreadImpl ct = (JPDAThreadImpl)this.getDebuggerImpl().getCurrentThread();
            if (ct != null && !ct.getThreadReference().equals(tr)) {
                return true;
            }
            try {
                if (ct.getThreadReference().frame(0).location().method().isSynthetic()) {
                    this.removeStepRequests(ct.getThreadReference());
                    int step = ((StepRequest)ev.request()).depth();
                    this.stepRequest = this.getDebuggerImpl().getVirtualMachine().eventRequestManager().createStepRequest(ct.getThreadReference(), -2, step);
                    this.stepRequest.addCountFilter(1);
                    this.getDebuggerImpl().getOperator().register(this.stepRequest, this);
                    this.stepRequest.setSuspendPolicy(this.getDebuggerImpl().getSuspend());
                    this.stepRequest.enable();
                    return true;
                }
            }
            catch (IncompatibleThreadStateException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            boolean fsh = this.getSmartSteppingFilterImpl().stopHere(className);
            if (ssverbose) {
                System.out.println("SS  SmartSteppingFilter.stopHere (" + className + ") ? " + fsh);
            }
            if (fsh) {
                JPDAThread t = this.getDebuggerImpl().getThread(tr);
                if (this.getCompoundSmartSteppingListener().stopHere(this.lookupProvider, t, this.getSmartSteppingFilterImpl())) {
                    Session session = (Session)this.lookupProvider.lookupFirst(null, Session.class);
                    if (session != null) {
                        DebuggerManager.getDebuggerManager().setCurrentSession(session);
                    }
                    this.getDebuggerImpl().setStoppedState(tr);
                    return false;
                }
            }
            if (ssverbose) {
                System.out.println("\nSS:  SMART STEPPING START! ********** ");
            }
            boolean stepInto = ((StepRequest)ev.request()).depth() == 1;
            this.getStepIntoActionProvider().doAction(ActionsManager.ACTION_STEP_INTO);
            return true;
        }
    }

    private StepIntoActionProvider getStepIntoActionProvider() {
        if (this.stepIntoActionProvider == null) {
            List l = this.lookupProvider.lookup(null, ActionsProvider.class);
            int k = l.size();
            for (int i = 0; i < k; ++i) {
                if (!(l.get(i) instanceof StepIntoActionProvider)) continue;
                this.stepIntoActionProvider = (StepIntoActionProvider)l.get(i);
            }
        }
        return this.stepIntoActionProvider;
    }

    private SmartSteppingFilterImpl getSmartSteppingFilterImpl() {
        if (this.smartSteppingFilterImpl == null) {
            this.smartSteppingFilterImpl = (SmartSteppingFilterImpl)this.lookupProvider.lookupFirst(null, SmartSteppingFilter.class);
        }
        return this.smartSteppingFilterImpl;
    }

    private CompoundSmartSteppingListener getCompoundSmartSteppingListener() {
        if (this.compoundSmartSteppingListener == null) {
            this.compoundSmartSteppingListener = (CompoundSmartSteppingListener)((Object)this.lookupProvider.lookupFirst(null, CompoundSmartSteppingListener.class));
        }
        return this.compoundSmartSteppingListener;
    }
}

