/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.request.ExceptionRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ExceptionBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;

public class ExceptionBreakpointImpl
extends ClassBasedBreakpoint {
    private ExceptionBreakpoint breakpoint;

    public ExceptionBreakpointImpl(ExceptionBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session) {
        super((JPDABreakpoint)breakpoint, debugger, session);
        this.breakpoint = breakpoint;
        this.set();
    }

    protected void setRequests() {
        this.setClassRequests(new String[]{this.breakpoint.getExceptionClassName()}, new String[0], 1);
        this.checkLoadedClasses(this.breakpoint.getExceptionClassName(), true);
    }

    protected void classLoaded(ReferenceType referenceType) {
        try {
            ExceptionRequest er = this.getEventRequestManager().createExceptionRequest(referenceType, (this.breakpoint.getCatchType() & 1) != 0, (this.breakpoint.getCatchType() & 2) != 0);
            this.addEventRequest(er);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public boolean exec(Event event) {
        if (event instanceof ExceptionEvent) {
            return this.perform(this.breakpoint.getCondition(), ((ExceptionEvent)event).thread(), ((ExceptionEvent)event).location().declaringType(), ((ExceptionEvent)event).exception());
        }
        return super.exec(event);
    }
}

