/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.impl.application.ApplicationProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final String APP_13_DOCTYPE = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    private static final DDProvider ddProvider = new DDProvider();
    private Map ddMap = new HashMap(5);
    static ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/dd/Bundle");

    private DDProvider() {
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Application getDDRoot(FileObject fo) throws IOException {
        ApplicationProxy ejbJarProxy;
        block8: {
            if (fo == null) {
                return null;
            }
            ejbJarProxy = null;
            Map map = this.ddMap;
            synchronized (map) {
                ejbJarProxy = this.getFromCache(fo);
                if (ejbJarProxy != null) {
                    return ejbJarProxy;
                }
            }
            fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileChanged(FileEvent evt) {
                    FileObject fo = evt.getFile();
                    try {
                        Map map = DDProvider.this.ddMap;
                        synchronized (map) {
                            ApplicationProxy ejbJarProxy = DDProvider.this.getFromCache(fo);
                            String version = null;
                            if (ejbJarProxy != null) {
                                try {
                                    DDParse parseResult = DDProvider.this.parseDD(fo);
                                    version = parseResult.getVersion();
                                    DDProvider.setProxyErrorStatus(ejbJarProxy, parseResult);
                                    Application newValue = DDProvider.createApplication(parseResult);
                                    if (!version.equals(ejbJarProxy.getVersion().toString())) {
                                        ejbJarProxy.setOriginal(newValue);
                                    } else if (ejbJarProxy.getOriginal() == null) {
                                        ejbJarProxy.setOriginal(newValue);
                                    } else {
                                        ejbJarProxy.getOriginal().merge(newValue, 3);
                                    }
                                }
                                catch (SAXException ex) {
                                    if (ex instanceof SAXParseException) {
                                        ejbJarProxy.setError((SAXParseException)ex);
                                    } else if (ex.getException() instanceof SAXParseException) {
                                        ejbJarProxy.setError((SAXParseException)ex.getException());
                                    }
                                    ejbJarProxy.setStatus(2);
                                    ejbJarProxy.setProxyVersion(version);
                                }
                            }
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            try {
                DDParse parseResult = this.parseDD(fo);
                SAXParseException error = parseResult.getWarning();
                Application original = DDProvider.createApplication(parseResult);
                ejbJarProxy = new ApplicationProxy(original, parseResult.getVersion());
                DDProvider.setProxyErrorStatus(ejbJarProxy, parseResult);
            }
            catch (SAXException ex) {
                ejbJarProxy = new ApplicationProxy(org.netbeans.modules.j2ee.dd.impl.application.model_1_4.Application.createGraph(), "2.0");
                ejbJarProxy.setStatus(2);
                if (ex instanceof SAXParseException) {
                    ejbJarProxy.setError((SAXParseException)ex);
                }
                if (!(ex.getException() instanceof SAXParseException)) break block8;
                ejbJarProxy.setError((SAXParseException)ex.getException());
            }
        }
        this.ddMap.put(fo, ejbJarProxy);
        return ejbJarProxy;
    }

    public Application getDDRootCopy(FileObject fo) throws IOException {
        return (Application)this.getDDRoot(fo).clone();
    }

    private ApplicationProxy getFromCache(FileObject fo) {
        return (ApplicationProxy)this.ddMap.get(fo);
    }

    public Application getDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = this.parseDD(is);
        Application ejbJar = DDProvider.createApplication(parse);
        ApplicationProxy proxy = new ApplicationProxy(ejbJar, ejbJar.getVersion().toString());
        DDProvider.setProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof ApplicationProxy) {
            return (BaseBean)((ApplicationProxy)bean).getOriginal();
        }
        return null;
    }

    private static void setProxyErrorStatus(ApplicationProxy ejbJarProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        ejbJarProxy.setError(error);
        if (error != null) {
            ejbJarProxy.setStatus(1);
        } else {
            ejbJarProxy.setStatus(0);
        }
    }

    private static Application createApplication(DDParse parse) {
        Application jar = null;
        String version = parse.getVersion();
        if ("1.4".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_1_4.Application(parse.getDocument(), 1);
        }
        if ("1.3".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_1_3.Application(parse.getDocument(), 1);
        }
        if ("5".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_5.Application(parse.getDocument(), 1);
        }
        return jar;
    }

    public SAXParseException parse(FileObject fo) throws SAXException, IOException {
        DDParse parseResult = this.parseDD(fo);
        return parseResult.getWarning();
    }

    private DDParse parseDD(FileObject fo) throws SAXException, IOException {
        return this.parseDD(fo.getInputStream());
    }

    private DDParse parseDD(InputStream is) throws SAXException, IOException {
        return this.parseDD(new InputSource(is));
    }

    private DDParse parseDD(InputSource is) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            parser = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        parser.setErrorHandler(errorHandler);
        parser.setEntityResolver(DDResolver.getInstance());
        Document d = parser.parse(is);
        SAXParseException error = errorHandler.getError();
        return new DDParse(d, error);
    }

    private static class DDParse {
        private final Document document;
        private final SAXParseException saxException;
        private String version;

        public DDParse(Document d, SAXParseException saxEx) {
            this.document = d;
            this.saxException = saxEx;
            this.extractVersion();
        }

        public Document getDocument() {
            return this.document;
        }

        private void extractVersion() {
            this.version = "5";
            DocumentType dt = this.document.getDoctype();
            if (dt == null) {
                Node appNode;
                NamedNodeMap attrs;
                Node vNode;
                NodeList nl = this.document.getElementsByTagName("application");
                if (nl != null && nl.getLength() > 0 && (vNode = (attrs = (appNode = nl.item(0)).getAttributes()).getNamedItem("version")) != null) {
                    String versionValue = vNode.getNodeValue();
                    this.version = "1.4".equals(versionValue) ? "1.4" : ("1.3".equals(versionValue) ? "1.3" : "5");
                }
            } else if (DDProvider.APP_13_DOCTYPE.equals(dt.getPublicId())) {
                this.version = "1.3";
            }
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (DDProvider.APP_13_DOCTYPE.equals(publicId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application_1_3.dtd");
            }
            if ("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application_1_4.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application_5.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_5.xsd");
            }
            return null;
        }
    }
}

