/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.j2ee.dd.impl.web.WebAppProxy;
import org.netbeans.modules.j2ee.dd.impl.web.WebNNListener;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.j2ee.metadata.MergedProvider;
import org.netbeans.modules.j2ee.metadata.MetadataUnit;
import org.netbeans.modules.j2ee.metadata.NNListener;
import org.netbeans.modules.j2ee.metadata.NNMDRListener;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static DDProvider ddProvider;
    private Map ddMap = new HashMap(5);
    private Map<MetadataUnit, WebApp> annotationDDMap = new HashMap<MetadataUnit, WebApp>(5);
    private Map baseBeanMap = new HashMap(5);
    private Map errorMap = new HashMap(5);
    private FCA fileChangeListener;
    private Map musMap = new HashMap(5);

    private DDProvider() {
        this.fileChangeListener = new FCA();
    }

    public static synchronized DDProvider getDefault() {
        if (ddProvider == null) {
            ddProvider = new DDProvider();
        }
        return ddProvider;
    }

    public WebApp getMergedDDRoot(FileObject fo) throws IOException {
        if (fo == null) {
            throw new IllegalArgumentException("FileObject is null");
        }
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null) {
            MetadataUnit mu = (MetadataUnit)this.musMap.get(wm.getDeploymentDescriptor());
            if (mu == null) {
                mu = new SimpleMetadataUnit(wm.getDeploymentDescriptor(), wm.getJavaSources());
                this.musMap.put(wm.getDeploymentDescriptor(), mu);
            }
            return this.getMergedDDRoot(mu);
        }
        return this.getDDRoot(fo);
    }

    public WebApp getMergedDDRoot(MetadataUnit mu) throws IOException {
        WebApp xmlRoot = this.getDDRoot(mu.getDeploymentDescriptor());
        if (xmlRoot != null && !xmlRoot.getVersion().equals("2.5")) {
            return xmlRoot;
        }
        WebApp annotationRoot = this.getAnnotationRoot(mu);
        if (xmlRoot instanceof WebAppProxy) {
            xmlRoot = ((WebAppProxy)xmlRoot).getOriginal();
        }
        if (annotationRoot instanceof WebAppProxy) {
            annotationRoot = ((WebAppProxy)annotationRoot).getOriginal();
        }
        return (WebApp)MergedProvider.getDefault().getRoot((BaseBean)annotationRoot, (BaseBean)xmlRoot);
    }

    private synchronized WebApp getAnnotationRoot(MetadataUnit mu) throws IOException {
        if (mu == null) {
            return null;
        }
        WebApp webApp = this.annotationDDMap.get(mu);
        if (webApp != null) {
            return webApp;
        }
        webApp = new org.netbeans.modules.j2ee.dd.impl.web.model_2_5.WebApp();
        this.annotationDDMap.put(mu, webApp);
        NNMDRListener.getDefault().addAnnotationListener((NNListener)new WebNNListener(webApp, mu.getClassPath()));
        return webApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebApp getDDRoot(FileObject fo) throws IOException {
        WebAppProxy webApp;
        block13: {
            webApp = null;
            Map map = this.ddMap;
            synchronized (map) {
                webApp = this.getFromCache(fo);
                if (webApp != null) {
                    return webApp;
                }
            }
            fo.addFileChangeListener((FileChangeListener)this.fileChangeListener);
            String version = null;
            SAXParseException error = null;
            try {
                WebApp original = null;
                Map map2 = this.baseBeanMap;
                synchronized (map2) {
                    original = this.getOriginalFromCache(fo);
                    if (original == null) {
                        version = WebParseUtils.getVersion(fo.getInputStream());
                        error = this.parse(fo);
                        original = DDUtils.createWebApp(fo.getInputStream(), version);
                        this.baseBeanMap.put(fo.getURL(), new WeakReference<WebApp>(original));
                        this.errorMap.put(fo.getURL(), error);
                    } else {
                        version = original.getVersion();
                        error = (SAXParseException)this.errorMap.get(fo.getURL());
                    }
                }
                webApp = new WebAppProxy(original, version);
                if (error != null) {
                    webApp.setStatus(1);
                    webApp.setError(error);
                }
            }
            catch (SAXException ex) {
                webApp = new WebAppProxy(null, version);
                webApp.setStatus(2);
                if (ex instanceof SAXParseException) {
                    webApp.setError((SAXParseException)ex);
                }
                if (!(ex.getException() instanceof SAXParseException)) break block13;
                webApp.setError((SAXParseException)ex.getException());
            }
        }
        this.ddMap.put(fo.getURL(), new WeakReference<WebAppProxy>(webApp));
        return webApp;
    }

    public WebApp getDDRootCopy(FileObject fo) throws IOException {
        return (WebApp)this.getDDRoot(fo).clone();
    }

    private WebAppProxy getFromCache(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        WeakReference wr = (WeakReference)this.ddMap.get(fo.getURL());
        if (wr == null) {
            return null;
        }
        WebAppProxy webApp = (WebAppProxy)wr.get();
        if (webApp == null) {
            this.ddMap.remove(fo.getURL());
        }
        return webApp;
    }

    private WebApp getOriginalFromCache(FileObject fo) throws IOException {
        WeakReference wr = (WeakReference)this.baseBeanMap.get(fo.getURL());
        if (wr == null) {
            return null;
        }
        WebApp webApp = (WebApp)wr.get();
        if (webApp == null) {
            this.baseBeanMap.remove(fo.getURL());
            this.errorMap.remove(fo.getURL());
            if (this.ddMap.get(fo.getURL()) == null) {
                // empty if block
            }
        }
        return webApp;
    }

    public WebApp getDDRoot(File f) throws IOException, SAXException {
        return DDUtils.createWebApp(new FileInputStream(f), WebParseUtils.getVersion(new FileInputStream(f)));
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof WebAppProxy) {
            return (BaseBean)((WebAppProxy)bean).getOriginal();
        }
        return null;
    }

    public SAXParseException parse(FileObject fo) throws SAXException, IOException {
        return WebParseUtils.parse(fo);
    }

    private void removeFromCache(FileObject fo) {
        try {
            URL foUrl = fo.getURL();
            this.ddMap.remove(foUrl);
            this.baseBeanMap.remove(foUrl);
            this.errorMap.remove(foUrl);
            this.musMap.remove(fo);
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private class SimpleMetadataUnit
    implements MetadataUnit {
        private FileObject dd;
        private FileObject[] roots;

        public SimpleMetadataUnit(FileObject dd, FileObject[] javaSources) {
            this.dd = dd;
            this.roots = javaSources;
        }

        public FileObject getDeploymentDescriptor() {
            return this.dd;
        }

        public ClassPath getClassPath() {
            if (this.roots.length > 0) {
                FileObject fo = this.roots[0];
                return org.netbeans.modules.j2ee.metadata.ClassPathSupport.createWeakProxyClassPath((ClassPath[])new ClassPath[]{ClassPath.getClassPath((FileObject)fo, (String)"classpath/source"), ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")});
            }
            return ClassPathSupport.createClassPath(Collections.emptyList());
        }
    }

    private class FCA
    extends FileChangeAdapter {
        private FCA() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent evt) {
            FileObject fo = evt.getFile();
            try {
                if (DataObject.find((FileObject)fo) != null) {
                    return;
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
            try {
                Map e = DDProvider.this.ddMap;
                synchronized (e) {
                    Map map = DDProvider.this.baseBeanMap;
                    synchronized (map) {
                        WebAppProxy webApp = DDProvider.this.getFromCache(fo);
                        WebApp orig = DDProvider.this.getOriginalFromCache(fo);
                        if (webApp != null) {
                            String version = null;
                            try {
                                version = WebParseUtils.getVersion(fo.getInputStream());
                                SAXParseException error = DDProvider.this.parse(fo);
                                if (error != null) {
                                    webApp.setError(error);
                                    webApp.setStatus(1);
                                } else {
                                    webApp.setError(null);
                                    webApp.setStatus(0);
                                }
                                WebApp original = DDUtils.createWebApp(fo.getInputStream(), version);
                                DDProvider.this.baseBeanMap.put(fo.getURL(), new WeakReference<WebApp>(original));
                                DDProvider.this.errorMap.put(fo.getURL(), webApp.getError());
                                webApp.merge(original, 3);
                            }
                            catch (SAXException ex) {
                                if (ex instanceof SAXParseException) {
                                    webApp.setError((SAXParseException)ex);
                                } else if (ex.getException() instanceof SAXParseException) {
                                    webApp.setError((SAXParseException)ex.getException());
                                }
                                webApp.setStatus(2);
                                webApp.setOriginal(null);
                                webApp.setProxyVersion(version);
                            }
                        } else if (orig != null) {
                            String version = null;
                            try {
                                version = WebParseUtils.getVersion(fo.getInputStream());
                                WebApp original = DDUtils.createWebApp(fo.getInputStream(), version);
                                if (original.getClass().equals(orig.getClass())) {
                                    orig.merge(original, 3);
                                } else {
                                    DDProvider.this.baseBeanMap.put(fo.getURL(), new WeakReference<WebApp>(original));
                                }
                            }
                            catch (SAXException ex) {
                                DDProvider.this.baseBeanMap.remove(fo.getURL());
                            }
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void fileDeleted(FileEvent fe) {
            DDProvider.this.removeFromCache(fe.getFile());
        }
    }
}

