/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.comments;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefObject;
import javax.swing.DefaultListModel;
import javax.swing.JEditorPane;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.ExtentEvent;
import org.netbeans.api.mdr.events.InstanceEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javadoc.comments.ElementDescriptor;
import org.netbeans.modules.javadoc.comments.JMIUtils;
import org.netbeans.modules.javadoc.comments.JavaTagNames;
import org.netbeans.modules.javadoc.comments.ResourceUtils;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.JavaDocTag;
import org.openide.src.SourceException;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class AutoCommenter
implements JavaTagNames {
    public static final int JDC_OK = 1;
    public static final int JDC_MISSING = 2;
    public static final int JDC_ERROR = 4;
    private static final RequestProcessor QUEUE = new RequestProcessor("Auto CommenterQueue");
    private final ArrayList dataObjects;
    ArrayList elements;
    Node[] nodes;
    private final WPCL dataObjectListener = new WPCL(this);
    private AutoCommentChangeListener autoCommentChangeListener = null;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;
    static /* synthetic */ Class class$org$netbeans$jmi$javamodel$Element;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$javadoc$comments$AutoCommenter;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    AutoCommenter() {
        this(new Node[0]);
    }

    AutoCommenter(Node[] nodes) {
        this.dataObjects = new ArrayList();
        this.nodes = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataObjects() {
        LinkedList<DataObject> newDOs = new LinkedList<DataObject>();
        for (int i = 0; i < this.nodes.length; ++i) {
            DataFolder df = (DataFolder)this.nodes[i].getCookie(class$org$openide$loaders$DataFolder == null ? AutoCommenter.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            Object cookie = null;
            if (df != null && df.isValid()) {
                DataObject[] children = df.getChildren();
                for (int n = 0; n < children.length; ++n) {
                    DataObject child = children[n];
                    cookie = child.getCookie(class$org$openide$cookies$SourceCookie == null ? AutoCommenter.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
                    FileObject childFO = child.getPrimaryFile();
                    if (cookie == null || !childFO.canWrite() || "class".equalsIgnoreCase(childFO.getExt()) || newDOs.contains(child)) continue;
                    child.addPropertyChangeListener((PropertyChangeListener)this.dataObjectListener);
                    newDOs.add(child);
                }
                continue;
            }
            Lookup lkp = this.nodes[i].getLookup();
            cookie = lkp.lookup(class$org$netbeans$jmi$javamodel$Element == null ? AutoCommenter.class$("org.netbeans.jmi.javamodel.Element") : class$org$netbeans$jmi$javamodel$Element);
            if (cookie == null) {
                cookie = lkp.lookup(class$org$openide$cookies$SourceCookie == null ? AutoCommenter.class$("org.openide.cookies.SourceCookie") : class$org$openide$cookies$SourceCookie);
            }
            DataObject doj = (DataObject)this.nodes[i].getCookie(class$org$openide$loaders$DataObject == null ? AutoCommenter.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (cookie == null || doj == null || !doj.getPrimaryFile().canWrite() || "class".equalsIgnoreCase(doj.getPrimaryFile().getExt()) || newDOs.contains(doj)) continue;
            doj.addPropertyChangeListener((PropertyChangeListener)this.dataObjectListener);
            newDOs.add(doj);
        }
        ArrayList arrayList = this.dataObjects;
        synchronized (arrayList) {
            this.dataObjects.removeAll(newDOs);
            Iterator it = this.dataObjects.iterator();
            while (it.hasNext()) {
                DataObject dataObject = (DataObject)it.next();
                dataObject.removePropertyChangeListener((PropertyChangeListener)this.dataObjectListener);
            }
            this.dataObjects.clear();
            this.dataObjects.addAll(newDOs);
            this.dataObjectListener.setDataObjects(newDOs);
        }
    }

    public void refreshFromSource() {
        QUEUE.post(new Runnable(){

            public void run() {
                AutoCommenter.this.refreshFromSourceImpl();
                AutoCommenter.this.fireAutocommentChangeEvent();
            }
        });
    }

    public void modifyJavadoc(final Element el, final JavaDoc doc) {
        QUEUE.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JavaModel.getJavaRepository().beginTrans(true);
                    try {
                        if (el.getSrcElement().isValid()) {
                            el.setJavaDoc(doc);
                            el.checkError();
                            AutoCommenter.this.fireElementUpdatedEvent(el);
                        }
                    }
                    finally {
                        JavaModel.getJavaRepository().endTrans();
                    }
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    public void autoCorrectJavadoc(final Element element, final JavaDoc doc) {
        QUEUE.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JavaModel.getJavaRepository().beginTrans(true);
                    try {
                        if (element.getSrcElement().isValid()) {
                            if (doc != null) {
                                element.setJavaDoc(doc);
                            }
                            element.autoCorrect();
                            element.checkError();
                            AutoCommenter.this.fireElementUpdatedEvent(element);
                        }
                    }
                    finally {
                        JavaModel.getJavaRepository().endTrans();
                    }
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                catch (SourceException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    public void autoCorrectJavadoc(final Element[] elements) {
        if (elements == null) {
            throw new NullPointerException("elements");
        }
        QUEUE.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    JavaModel.getJavaRepository().beginTrans(true);
                    try {
                        for (int i = 0; i < elements.length; ++i) {
                            Element element = elements[i];
                            if (!element.getSrcElement().isValid()) continue;
                            element.autoCorrect();
                            element.checkError();
                        }
                        AutoCommenter.this.fireAutocommentChangeEvent();
                    }
                    finally {
                        JavaModel.getJavaRepository().endTrans();
                    }
                }
                catch (JmiException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                catch (SourceException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFromSourceImpl() {
        ArrayList dobjs;
        this.updateDataObjects();
        ArrayList arrayList = this.dataObjects;
        synchronized (arrayList) {
            dobjs = new ArrayList(this.dataObjects);
        }
        this.elements = new ArrayList(dobjs.size());
        try {
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                Iterator it = dobjs.iterator();
                while (it.hasNext()) {
                    DataObject d = (DataObject)it.next();
                    Resource r = JavaModel.getResource((FileObject)d.getPrimaryFile());
                    if (r == null) continue;
                    this.addCommentable(r);
                }
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
        catch (JmiException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void addCommentable(Resource r) {
        List classes = JMIUtils.getAllClasses(r);
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            JavaClass jc = (JavaClass)it.next();
            if (!jc.isValid()) continue;
            this.addElements(jc);
        }
    }

    private void prepareListModel(DefaultListModel listModel, int mask, boolean pckg, int err_mask) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!AutoCommenter.acceptElement(el, mask, pckg, err_mask)) continue;
            listModel.addElement(el);
        }
    }

    static boolean acceptElement(Element el, int mask, boolean pckg, int err_mask) {
        if ((el.getErrorNumber() & err_mask) == 0) {
            return false;
        }
        int access = el.getDescriptor().getEffectiveAccess();
        if (access == 0) {
            return pckg;
        }
        return (access & mask) > 0;
    }

    DefaultListModel prepareListModel(int mask, boolean pckg, int err_mask) {
        DefaultListModel dm = new DefaultListModel();
        this.prepareListModel(dm, mask, pckg, err_mask);
        return dm;
    }

    private void addElements(JavaClass classElement) {
        this.elements.add(AutoCommenter.createAutoCommenterElement((ClassMember)classElement));
        List features = classElement.getFeatures();
        Iterator it = features.iterator();
        while (it.hasNext()) {
            Element el;
            Object feature = it.next();
            if (feature instanceof JavaClass || !(feature instanceof ClassMember) || (el = AutoCommenter.createAutoCommenterElement((ClassMember)feature)) == null) continue;
            this.elements.add(el);
        }
    }

    public static Element createAutoCommenterElement(ClassMember element) {
        Element jdElement = null;
        if (element instanceof JavaClass) {
            jdElement = new Element.Class((JavaClass)element);
        } else if (element instanceof Field) {
            jdElement = new Element.Field((Field)element);
        } else if (element instanceof Constructor) {
            jdElement = new Element.Constructor((CallableFeature)((Constructor)element));
        } else if (element instanceof Method) {
            jdElement = new Element.Method((Method)element);
        } else if (element instanceof Attribute) {
            jdElement = new Element.Field((Attribute)element);
        }
        if (jdElement != null) {
            jdElement.initialize();
        }
        return jdElement;
    }

    public synchronized void addAutoCommentChangeListener(AutoCommentChangeListener listener) throws TooManyListenersException {
        if (this.autoCommentChangeListener != null) {
            throw new TooManyListenersException();
        }
        this.autoCommentChangeListener = listener;
    }

    public synchronized void removeAutoCommentChangeListener(AutoCommentChangeListener listener) {
        this.autoCommentChangeListener = null;
    }

    private void fireAutocommentChangeEvent() {
        if (this.autoCommentChangeListener == null) {
            return;
        }
        this.autoCommentChangeListener.listChanged();
    }

    private void fireElementUpdatedEvent(Element el) {
        if (this.autoCommentChangeListener == null) {
            return;
        }
        this.autoCommentChangeListener.elementUpdated(el);
    }

    public static interface AutoCommentChangeListener
    extends EventListener {
        public void listChanged();

        public void elementUpdated(Element var1);
    }

    static abstract class Element {
        private DefaultListModel errorList;
        protected final ClassMember srcElement;
        private int srcError = 1;
        private JavaDoc javadoc;
        private ElementDescriptor desc;
        private boolean isValid = true;
        static final /* synthetic */ boolean $assertionsDisabled;

        protected Element(ClassMember srcElement) {
            this.srcElement = srcElement;
        }

        protected final void initialize() throws JmiException {
            this.javadoc = this.createJavaDoc();
            this.desc = new ElementDescriptor(this, this.getNameFormat());
            this.checkError();
        }

        public final boolean isValid() {
            return this.isValid;
        }

        public final ElementDescriptor getDescriptor() throws JmiException {
            if (!$assertionsDisabled && this.desc == null) {
                throw new AssertionError();
            }
            return this.desc;
        }

        public final ClassMember getSrcElement() {
            return this.srcElement;
        }

        public final int getErrorNumber() {
            return this.srcError;
        }

        public final void viewSource() {
            QUEUE.post(new Runnable(){
                int state = 0;
                EditorCookie ec;
                int offset;
                DataObject dobj;

                public void run() {
                    switch (this.state) {
                        case 0: {
                            this.findOffset();
                            break;
                        }
                        case 1: {
                            this.open();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void findOffset() {
                    try {
                        JavaModel.getJavaRepository().beginTrans(false);
                        try {
                            if (!Element.this.srcElement.isValid()) {
                                return;
                            }
                            Resource r = Element.this.srcElement.getResource();
                            if (r == null) {
                                return;
                            }
                            this.offset = JavaMetamodel.getManager().getElementPosition((org.netbeans.jmi.javamodel.Element)Element.this.srcElement).getBegin().getOffset();
                            this.dobj = JavaMetamodel.getManager().getDataObject(r);
                            if (this.dobj == null) {
                                return;
                            }
                            this.ec = (EditorCookie)this.dobj.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = AutoCommenter.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                            if (this.ec == null) {
                                return;
                            }
                            ++this.state;
                            EventQueue.invokeLater(this);
                        }
                        finally {
                            JavaModel.getJavaRepository().endTrans();
                        }
                    }
                    catch (JmiException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                        return;
                    }
                }

                void open() {
                    this.ec.open();
                    JEditorPane[] epane = this.ec.getOpenedPanes();
                    if (epane != null && epane.length > 0) {
                        epane[0].getCaret().setDot(this.offset);
                        epane[0].requestFocus();
                    }
                }
            });
        }

        public final synchronized DefaultListModel getErrorList() {
            return this.errorList;
        }

        protected abstract String[] getNotPermittedTags();

        protected abstract boolean elementTagsOk(DefaultListModel var1);

        public abstract void autoCorrect() throws SourceException;

        protected abstract JavaDoc createJavaDoc();

        public final JavaDoc getJavaDoc() {
            if (!$assertionsDisabled && this.javadoc == null) {
                throw new AssertionError();
            }
            return this.javadoc;
        }

        public final void setJavaDoc(JavaDoc doc) throws JmiException {
            if (doc == null) {
                throw new NullPointerException("doc");
            }
            this.srcElement.setJavadocText(doc.getRawText());
            this.javadoc = this.createJavaDoc();
        }

        protected abstract Format getNameFormat();

        protected abstract String typeToString();

        static boolean isPermittedTag(JavaDocTag tag, String[] notPermittedTags) {
            String tagName = tag.name();
            for (int i = 0; i < notPermittedTags.length; ++i) {
                if (!tagName.equals(notPermittedTags[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean isEmptyString(String string) {
            return string == null || string.trim().length() <= 0;
        }

        private boolean isOkTag(JavaDocTag tag, DefaultListModel errList) {
            if (Element.isEmptyString(tag.text())) {
                Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_EmptyTag"), tag.name()));
                return false;
            }
            if (tag instanceof JavaDocTag.See) {
                JavaDocTag.See seetag = (JavaDocTag.See)tag;
                if (seetag.referencedClassName() != null || seetag.referencedMemberName() != null) {
                    return true;
                }
                String text = tag.text();
                int len = text.length();
                if (len >= 2) {
                    char first = text.charAt(0);
                    char last = text.charAt(len - 1);
                    if (first == '\"' && last == first) {
                        return true;
                    }
                    if (first == '<' && last == '>') {
                        return true;
                    }
                }
                Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_InvalidTag"), seetag));
                return false;
            }
            if (tag instanceof JavaDocTag.Param) {
                if (Element.isEmptyString(((JavaDocTag.Param)tag).parameterName())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_ParamNoName"), tag.name()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.Param)tag).parameterComment())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_ParamNoDescr"), tag.name(), ((JavaDocTag.Param)tag).parameterName()));
                    return false;
                }
            } else if (tag instanceof JavaDocTag.Throws) {
                if (Element.isEmptyString(((JavaDocTag.Throws)tag).exceptionName())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_ThrowsNoName"), tag.name()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.Throws)tag).exceptionComment())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_ThrowsNoDescr"), tag.name(), ((JavaDocTag.Throws)tag).exceptionName()));
                    return false;
                }
            } else if (tag instanceof JavaDocTag.SerialField) {
                if (Element.isEmptyString(((JavaDocTag.SerialField)tag).fieldName())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_SerialFieldNoName"), tag.name()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.SerialField)tag).fieldType())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_SerialFieldNoType"), tag.name(), ((JavaDocTag.SerialField)tag).fieldName()));
                    return false;
                }
                if (Element.isEmptyString(((JavaDocTag.SerialField)tag).description())) {
                    Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_SerialFieldNoDescr"), tag.name(), ((JavaDocTag.SerialField)tag).fieldName()));
                    return false;
                }
            }
            return true;
        }

        protected final boolean isMultipleTags(String tag, DefaultListModel errList) {
            boolean error = false;
            JavaDocTag[] tags = this.getJavaDoc().getTags(tag);
            if (tags.length > 1) {
                Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_DuplicatedTag"), tags[0].name()));
                error = true;
            }
            return error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void checkError() {
            DefaultListModel<String> _errorList = new DefaultListModel<String>();
            JavaDoc jdoc = this.getJavaDoc();
            if (jdoc.isEmpty()) {
                _errorList.addElement(ResourceUtils.getBundledString("ERR_JavadocMissing"));
                Element element = this;
                synchronized (element) {
                    this.srcError = 2;
                    this.errorList = _errorList;
                }
                this.desc.recomputeIcon();
                return;
            }
            JavaDocTag[] tags = jdoc.getTags();
            boolean error = false;
            if (jdoc.getText() == null || jdoc.getText().trim().length() <= 0) {
                _errorList.addElement(ResourceUtils.getBundledString("ERR_EmptyText"));
                error = true;
            }
            for (int i = 0; i < tags.length; ++i) {
                if (!Element.isPermittedTag(tags[i], this.getNotPermittedTags())) {
                    _errorList.addElement(MessageFormat.format(ResourceUtils.getBundledString("ERR_BadTag"), tags[i].name(), this.typeToString()));
                    error = true;
                    continue;
                }
                if (this.isOkTag(tags[i], _errorList)) continue;
                error = true;
            }
            if (this.isMultipleTags("@since", _errorList)) {
                error = true;
            }
            if (this.isMultipleTags("@deprecated", _errorList)) {
                error = true;
            }
            if (!this.elementTagsOk(_errorList)) {
                error = true;
            }
            if (!error) {
                _errorList.addElement(ResourceUtils.getBundledString("ERR_JavadocOK"));
            }
            Element element = this;
            synchronized (element) {
                this.srcError = error ? 4 : 1;
                this.errorList = _errorList;
            }
            this.desc.recomputeIcon();
        }

        public boolean isCorrectable() {
            if (!$assertionsDisabled && this.javadoc == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.desc == null) {
                throw new AssertionError();
            }
            JavaDocTag[] tags = this.getJavaDoc().getTags();
            for (int i = 0; i < tags.length; ++i) {
                if (Element.isPermittedTag(tags[i], this.getNotPermittedTags())) continue;
                return true;
            }
            return false;
        }

        protected void autoCorrect(JavaDoc jdoc) throws SourceException {
            JavaDocTag[] tags = jdoc.getTags();
            ArrayList<JavaDocTag> correctedTags = new ArrayList<JavaDocTag>(tags.length);
            String correctedText = jdoc.getText();
            if (correctedText == null) {
                correctedText = "";
            }
            for (int i = 0; i < tags.length; ++i) {
                if (!Element.isPermittedTag(tags[i], this.getNotPermittedTags())) continue;
                correctedTags.add(tags[i]);
            }
            jdoc.changeTags(correctedTags.toArray(new JavaDocTag[correctedTags.size()]), 3);
        }

        private static void log(DefaultListModel errList, String txt) {
            if (errList != null) {
                errList.addElement(txt);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Element)) {
                return false;
            }
            Element element = (Element)o;
            return this.desc != null && element.desc != null && this.desc.getIdentity().equals(element.desc.getIdentity());
        }

        public int hashCode() {
            return this.desc != null ? this.desc.getIdentity().hashCode() : 0;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$javadoc$comments$AutoCommenter == null ? (class$org$netbeans$modules$javadoc$comments$AutoCommenter = AutoCommenter.class$("org.netbeans.modules.javadoc.comments.AutoCommenter")) : class$org$netbeans$modules$javadoc$comments$AutoCommenter).desiredAssertionStatus();
        }

        static class Method
        extends Constructor {
            private static final Format nameFormat = SourceNodes.createElementFormat((String)"{n}({p,,,\",\"})");
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@author", "@serial", "@serialField", "@version"};

            Method(org.netbeans.jmi.javamodel.Method element) {
                super((CallableFeature)element);
            }

            public String typeToString() {
                return "method";
            }

            public String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            protected boolean elementTagsOk(DefaultListModel errList) {
                boolean superOk = super.elementTagsOk(errList);
                boolean retOk = this.checkReturnType(false, errList);
                return !superOk ? false : retOk;
            }

            private boolean checkReturnType(boolean checkOnly, DefaultListModel errList) {
                boolean retOk = true;
                String retFQN = this.getDescriptor().getTypeFQName();
                JavaDocTag[] retTags = this.getJavaDoc().getTags("@return");
                boolean isVoid = "void".equals(retFQN);
                if (isVoid && retTags.length > 0) {
                    if (checkOnly) {
                        return false;
                    }
                    Element.log(errList, ResourceUtils.getBundledString("ERR_ReturnForVoid"));
                    retOk = false;
                } else if (!isVoid && retTags.length <= 0) {
                    if (checkOnly) {
                        return false;
                    }
                    Element.log(errList, ResourceUtils.getBundledString("ERR_NoReturn"));
                    retOk = false;
                } else if (!isVoid && retTags.length > 1) {
                    if (checkOnly) {
                        return false;
                    }
                    Element.log(errList, ResourceUtils.getBundledString("ERR_DuplicatedReturn"));
                    retOk = false;
                }
                return retOk;
            }

            public boolean isCorrectable() {
                if (super.isCorrectable()) {
                    return true;
                }
                return !this.checkReturnType(true, null);
            }

            public void autoCorrect() throws SourceException {
                JavaDoc.Method jdTemp = JavaDocSupport.createMethodJavaDoc((String)this.getJavaDoc().getRawText());
                super.autoCorrect((JavaDoc)jdTemp);
                if (!this.checkReturnType(true, null)) {
                    String retFQN = this.getDescriptor().getTypeFQName();
                    if (!"void".equals(retFQN)) {
                        jdTemp.changeTags(new JavaDocTag[]{JavaDocSupport.createTag((String)"@return", (String)"")}, 1);
                    } else {
                        JavaDocTag[] toRemove = jdTemp.getTags("@return");
                        jdTemp.changeTags(toRemove, 2);
                    }
                }
                this.getJavaDoc().setRawText(jdTemp.getRawText());
                this.setJavaDoc(this.getJavaDoc());
            }

            public Format getNameFormat() {
                return nameFormat;
            }
        }

        static class Constructor
        extends Element {
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@author", "@serial", "@serialField", "@version", "@return"};
            private static final Format nameFormat = SourceNodes.createElementFormat((String)"{n}({p,,,\",\"})");

            protected Constructor(CallableFeature element) {
                super((ClassMember)element);
            }

            protected JavaDoc createJavaDoc() {
                String s = this.srcElement.getJavadocText();
                JavaDoc.Method javadoc = JavaDocSupport.createMethodJavaDoc((String)s);
                return javadoc;
            }

            public String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            public String typeToString() {
                return "constructor";
            }

            protected boolean elementTagsOk(DefaultListModel errList) {
                return this.elementTagsOk(null, false, errList);
            }

            private boolean elementTagsOk(ArrayList correctedTags, boolean checkOnly, DefaultListModel errList) {
                boolean error = false;
                JavaDoc jdoc = this.getJavaDoc();
                JavaDocTag.Param[] ptags = ((JavaDoc.Method)jdoc).getParamTags();
                boolean[] ptags_found = new boolean[ptags.length];
                String[] params = this.getDescriptor().getParameterNames();
                for (int j = 0; j < params.length; ++j) {
                    String param = params[j];
                    boolean tagFound = false;
                    boolean duplicateTagAlreadyFound = false;
                    for (int i = 0; i < ptags.length; ++i) {
                        if (ptags[i].parameterName() == null || !ptags[i].parameterName().equals(param)) continue;
                        ptags_found[i] = true;
                        if (!tagFound) {
                            tagFound = true;
                            continue;
                        }
                        if (duplicateTagAlreadyFound) continue;
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_DuplicatedParamTag"), param));
                        }
                        error = true;
                        duplicateTagAlreadyFound = true;
                    }
                    if (tagFound) continue;
                    if (checkOnly) {
                        return false;
                    }
                    if (correctedTags == null) {
                        error = true;
                        Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_NoTagForParam"), param));
                        continue;
                    }
                    correctedTags.add(JavaDocSupport.createParamTag((String)"@param", (String)param));
                }
                for (int i = 0; i < ptags.length; ++i) {
                    if (!ptags_found[i]) {
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_NoSuchParam"), ptags[i].name(), ptags[i].parameterName()));
                        }
                        error = true;
                        continue;
                    }
                    if (correctedTags == null) continue;
                    correctedTags.add(ptags[i]);
                }
                JavaDocTag.Throws[] ttags = ((JavaDoc.Method)this.getJavaDoc()).getThrowsTags();
                boolean[] ttags_found = new boolean[ttags.length];
                String[] excs = this.getDescriptor().getThrowFQNames();
                for (int j = 0; j < excs.length; ++j) {
                    String excFQN = excs[j];
                    boolean tagFound = false;
                    boolean duplicateTagAlreadyFound = false;
                    for (int i = 0; i < ttags.length; ++i) {
                        String tagExId = ttags[i].exceptionName().replaceFirst("\\.+\\z", "");
                        if (tagExId.length() <= 0 || !excFQN.endsWith(tagExId)) continue;
                        ttags_found[i] = true;
                        if (!tagFound) {
                            tagFound = true;
                            continue;
                        }
                        if (duplicateTagAlreadyFound) continue;
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_DuplicatedExceptionTag"), excFQN));
                        }
                        error = true;
                        duplicateTagAlreadyFound = true;
                    }
                    if (tagFound) continue;
                    if (checkOnly) {
                        return false;
                    }
                    if (correctedTags == null) {
                        error = true;
                        Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_NoTagForException"), excFQN));
                        continue;
                    }
                    correctedTags.add(JavaDocSupport.createThrowsTag((String)"@throws", (String)excFQN));
                }
                for (int i = 0; i < ttags.length; ++i) {
                    if (!ttags_found[i]) {
                        if (checkOnly) {
                            return false;
                        }
                        if (correctedTags == null) {
                            Element.log(errList, MessageFormat.format(ResourceUtils.getBundledString("ERR_NoSuchException"), ttags[i].name(), ttags[i].exceptionName()));
                        }
                        error = true;
                        continue;
                    }
                    if (correctedTags == null) continue;
                    correctedTags.add(ttags[i]);
                }
                return !error;
            }

            public boolean isCorrectable() {
                if (super.isCorrectable()) {
                    return true;
                }
                return !this.elementTagsOk(null, true, null);
            }

            public void autoCorrect() throws SourceException {
                this.autoCorrect(this.getJavaDoc());
                this.setJavaDoc(this.getJavaDoc());
            }

            public void autoCorrect(JavaDoc jDoc) throws SourceException {
                JavaDoc.Method jdTemp = JavaDocSupport.createMethodJavaDoc((String)this.getJavaDoc().getRawText());
                JavaDocTag[] tags = jdTemp.getTags();
                ArrayList<JavaDocTag> stdTags = new ArrayList<JavaDocTag>(tags.length);
                for (int i = 0; i < tags.length; ++i) {
                    if (tags[i] instanceof JavaDocTag.Param || tags[i] instanceof JavaDocTag.Throws) continue;
                    stdTags.add(tags[i]);
                }
                jdTemp.changeTags(stdTags.toArray(new JavaDocTag[stdTags.size()]), 3);
                super.autoCorrect((JavaDoc)jdTemp);
                ArrayList correctedTags = new ArrayList();
                this.elementTagsOk(correctedTags, false, null);
                ArrayList<Object> allTags = new ArrayList<Object>(correctedTags.size() + tags.length);
                tags = jdTemp.getTags();
                for (int i = 0; i < tags.length; ++i) {
                    allTags.add(tags[i]);
                }
                allTags.addAll(correctedTags);
                jDoc.changeTags(allTags.toArray(new JavaDocTag[allTags.size()]), 3);
            }

            public Format getNameFormat() {
                return nameFormat;
            }
        }

        static class Field
        extends Element {
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@author", "@exception", "@param", "@return", "@serialData", "@throws", "@version"};
            private static final Format nameFormat = SourceNodes.createElementFormat((String)"{n}");

            protected Field(org.netbeans.jmi.javamodel.Field element) {
                super((ClassMember)element);
            }

            protected Field(Attribute element) {
                super((ClassMember)element);
            }

            protected JavaDoc createJavaDoc() {
                String s = this.srcElement.getJavadocText();
                JavaDoc.Field javaDoc = JavaDocSupport.createFieldJavaDoc((String)s);
                return javaDoc;
            }

            public String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            public String typeToString() {
                return this.srcElement instanceof Field ? "field" : "attribute";
            }

            protected boolean elementTagsOk(DefaultListModel errList) {
                boolean error = false;
                if (this.isMultipleTags("@serial", errList)) {
                    error = true;
                }
                return !error;
            }

            public void autoCorrect() throws SourceException {
                super.autoCorrect(this.getJavaDoc());
                this.setJavaDoc(this.getJavaDoc());
            }

            public Format getNameFormat() {
                return nameFormat;
            }
        }

        static class Class
        extends Element {
            private static final String[] NOT_PERMITTED_TAGS = new String[]{"@exception", "@param", "@return", "@serial", "@serialData", "@serialField", "@throws"};
            private static final Format nameFormat = SourceNodes.createElementFormat((String)"{C}");

            protected Class(JavaClass element) {
                super((ClassMember)element);
            }

            public String[] getNotPermittedTags() {
                return NOT_PERMITTED_TAGS;
            }

            protected boolean elementTagsOk(DefaultListModel errList) {
                boolean error = false;
                if (this.isMultipleTags("@version", errList)) {
                    error = true;
                }
                return !error;
            }

            public void autoCorrect() throws SourceException {
                super.autoCorrect(this.getJavaDoc());
                this.setJavaDoc(this.getJavaDoc());
            }

            public String typeToString() {
                String type = this.srcElement instanceof JavaEnum ? "enum" : (this.srcElement instanceof AnnotationType ? "annotation type" : (Modifier.isInterface(this.getDescriptor().getModifiers()) ? "interface" : "class"));
                return type;
            }

            protected JavaDoc createJavaDoc() {
                String s = this.srcElement.getJavadocText();
                JavaDoc.Class javadoc = JavaDocSupport.createClassJavaDoc((String)s);
                return javadoc;
            }

            public Format getNameFormat() {
                return nameFormat;
            }
        }
    }

    private static class WPCL
    extends WeakReference
    implements PropertyChangeListener,
    MDRChangeListener,
    Runnable {
        private List dataObjects = null;
        private MDRepository repository;

        public WPCL(AutoCommenter ac) {
            super(ac, Utilities.activeReferenceQueue());
            this.initMDRListener();
        }

        public synchronized void setDataObjects(List dos) {
            this.dataObjects = dos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            AutoCommenter ac = (AutoCommenter)this.get();
            if (ac == null) {
                return;
            }
            DataObject doj = (DataObject)evt.getSource();
            if (evt.getPropertyName().equals("valid")) {
                WPCL wPCL = this;
                synchronized (wPCL) {
                    if (this.dataObjects != null) {
                        doj.removePropertyChangeListener((PropertyChangeListener)this);
                        if (this.dataObjects.remove(doj)) {
                            ac.refreshFromSource();
                        }
                    }
                }
            }
        }

        public void change(MDRChangeEvent e) {
            AutoCommenter ac = (AutoCommenter)this.get();
            if (ac == null) {
                return;
            }
            if (e instanceof ExtentEvent && e.getType() == 134283266) {
                ac.refreshFromSource();
            } else if (e instanceof InstanceEvent) {
                InstanceEvent ie = (InstanceEvent)e;
                this.handleElementDelete(ie);
            }
        }

        private void handleElementDelete(InstanceEvent e) {
            RefObject instance = e.getInstance();
            if (e.getType() != 0x2010002 || !(instance instanceof ClassMember)) {
                return;
            }
            AutoCommenter ac = (AutoCommenter)this.get();
            if (ac == null) {
                return;
            }
            Iterator it = ac.elements.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                if (instance != element.getSrcElement()) continue;
                element.isValid = false;
                return;
            }
        }

        public void run() {
            if (this.dataObjects != null) {
                Iterator it = this.dataObjects.iterator();
                while (it.hasNext()) {
                    DataObject d = (DataObject)it.next();
                    d.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
            if (this.repository != null) {
                this.repository.removeListener((MDRChangeListener)this);
            }
        }

        private void initMDRListener() {
            this.repository = JavaModel.getJavaRepository();
            this.repository.addListener((MDRChangeListener)this);
        }
    }
}

