/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Dialog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.AbstractSystemAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.add.AddExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.tag.SwitchBranchPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SwitchBranchAction
extends AbstractSystemAction {
    private static final int enabledForStatus = 1208;

    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_SwitchBranch";
    }

    protected int getFileEnabledStatus() {
        return 1208;
    }

    public void performCvsAction(final Node[] nodes) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SwitchBranchAction.this.switchBranch(nodes);
            }
        });
    }

    protected boolean asynchronous() {
        return false;
    }

    private void switchBranch(Node[] nodes) {
        Context context = this.getContext(nodes);
        String title = MessageFormat.format(NbBundle.getBundle((Class)SwitchBranchAction.class).getString("CTL_SwitchBranchDialog_Title"), this.getContextDisplayName(nodes));
        final SwitchBranchPanel settings = new SwitchBranchPanel(context.getFiles());
        JButton swich = new JButton(NbBundle.getMessage((Class)SwitchBranchAction.class, (String)"CTL_SwitchBranchDialog_Action_Switch"));
        swich.setToolTipText(NbBundle.getMessage((Class)SwitchBranchAction.class, (String)"TT_SwitchBranchDialog_Action_Switch"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)settings, title, true, new Object[]{swich, DialogDescriptor.CANCEL_OPTION}, (Object)swich, 0, new HelpCtx(SwitchBranchAction.class), null);
        descriptor.setClosingOptions(null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SwitchBranchAction.class, (String)"ACSD_SwitchBranchDialog"));
        dialog.setVisible(true);
        if (descriptor.getValue() != swich) {
            return;
        }
        settings.saveSettings();
        ArrayList<File> newFolders = new ArrayList<File>();
        ArrayList<File> others = new ArrayList<File>();
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] roots = context.getRootFiles();
        for (int i = 0; i < roots.length; ++i) {
            File root = roots[i];
            if (root.isDirectory() && cache.getStatus(root).getStatus() == 4) {
                newFolders.add(root);
                continue;
            }
            others.add(root);
        }
        ExecutorGroup group = new ExecutorGroup(this.getRunningName(nodes));
        if (newFolders.size() > 0) {
            AddCommand acmd = new AddCommand();
            final File[] files = newFolders.toArray(new File[newFolders.size()]);
            acmd.setFiles(files);
            group.addExecutors(AddExecutor.splitCommand(acmd, CvsVersioningSystem.getInstance(), null));
            Runnable action = new Runnable(){

                public void run() {
                    if (settings.isSwitchToTrunk()) {
                        SwitchBranchAction.this.setSticky(files, null);
                    } else {
                        SwitchBranchAction.this.setSticky(files, settings.getBranchName());
                    }
                }
            };
            group.addBarrier(action);
        }
        if (others.size() > 0) {
            UpdateCommand cmd = new UpdateCommand();
            if (settings.isSwitchToTrunk()) {
                cmd.setResetStickyOnes(true);
            } else {
                cmd.setUpdateByRevision(settings.getBranchName());
            }
            cmd.setBuildDirectories(true);
            cmd.setPruneDirectories(true);
            cmd.setFiles(others.toArray(new File[others.size()]));
            GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
            if (context.getExclusions().size() > 0) {
                options.setExclusions(context.getExclusions().toArray(new File[context.getExclusions().size()]));
            }
            group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options));
        }
        group.execute();
    }

    private void setSticky(File[] files, String sticky) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            try {
                this.setSticky(file, sticky);
                continue;
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    private void setSticky(File file, String sticky) throws IOException {
        File tag = new File(file, "CVS/Tag");
        tag.delete();
        if ("HEAD".equals(sticky)) {
            return;
        }
        if (sticky != null) {
            FileWriter w = new FileWriter(tag);
            w.write("T");
            w.write(sticky);
            w.write(System.getProperty("line.separator"));
            w.close();
        }
    }
}

