/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.io.File;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.AbstractFilesListener;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ModuleDDSupport;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class DDFilesListener
extends AbstractFilesListener {
    private SunONEDeploymentConfiguration config;
    private File[] ddFiles = null;
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public DDFilesListener(SunONEDeploymentConfiguration config, J2eeModuleProvider provider) {
        super(provider);
        this.config = config;
    }

    protected File[] getTargetFiles() {
        if (this.ddFiles != null) {
            return this.ddFiles;
        }
        SourceFileMap sfm = this.provider.getSourceFileMap();
        FileObject[] roots = sfm.getSourceRoots();
        if (roots == null || roots.length < 1) {
            this.ddFiles = EMPTY_FILE_ARRAY;
            return this.ddFiles;
        }
        if (roots[0] == null) {
            this.ddFiles = EMPTY_FILE_ARRAY;
            return this.ddFiles;
        }
        File configFolder = FileUtil.toFile((FileObject)roots[0]);
        String[] pathNames = ModuleDDSupport.getDDPaths(this.provider.getJ2eeModule().getModuleType());
        this.ddFiles = new File[pathNames.length];
        for (int i = 0; i < pathNames.length; ++i) {
            String fileName = pathNames[i];
            if (J2eeModule.WAR != this.provider.getJ2eeModule().getModuleType()) {
                fileName = fileName.substring(pathNames[i].lastIndexOf(47) + 1);
            }
            this.ddFiles[i] = new File(configFolder, fileName);
        }
        return this.ddFiles;
    }

    protected boolean isTarget(FileObject fo) {
        if (fo == null) {
            return false;
        }
        this.getTargetFiles();
        for (int i = 0; i < this.ddFiles.length; ++i) {
            if (!fo.getNameExt().equalsIgnoreCase(this.ddFiles[i].getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isTarget(String fileName) {
        if (fileName == null) {
            return false;
        }
        this.getTargetFiles();
        for (int i = 0; i < this.ddFiles.length; ++i) {
            if (!fileName.equalsIgnoreCase(this.ddFiles[i].getName())) continue;
            return true;
        }
        return true;
    }

    protected void targetCreated(FileObject fo) {
        ConfigurationStorage cs = this.config.getStorage();
        if (cs != null) {
            cs.updateDDRoot(fo);
        }
    }

    protected void targetDeleted(FileObject fo) {
    }

    protected void targetChanged(FileObject fo) {
    }
}

