/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.config.ConfigBeanStorage;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.DDCommon;
import org.netbeans.modules.j2ee.sun.share.config.DDLeafBean;
import org.netbeans.modules.j2ee.sun.share.config.DDNodeBean;
import org.netbeans.modules.j2ee.sun.share.config.DDProxy;
import org.netbeans.modules.j2ee.sun.share.config.DDRoot;
import org.netbeans.modules.j2ee.sun.share.config.StandardDDImpl;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.schema2beans.BaseProperty;
import org.netbeans.modules.schema2beans.Bean;
import org.netbeans.modules.schema2beans.GraphManager;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public class ModuleDDSupport
implements PropertyChangeListener {
    public static final String SEPARATOR = "/";
    public static final String WEBSERVICES_XML = "webservices.xml";
    private static Map filenameToPathMap = null;
    private Map rootMap = new HashMap(5);
    private Map configMap = new IdentityHashMap(5);
    private Map beanMap = Collections.synchronizedMap(new IdentityHashMap());
    private Map leafMap = Collections.synchronizedMap(new IdentityHashMap());
    private Map listenerMap = Collections.synchronizedMap(new IdentityHashMap(5));
    private Set xpathListeners = new HashSet();
    private J2eeModuleProvider provider;
    private DeploymentConfiguration config;
    private static Map moduleDDlocationMap = new HashMap(10);

    public static String[] getDDPaths(Object type) {
        return (String[])moduleDDlocationMap.get(type);
    }

    public ModuleDDSupport(J2eeModuleProvider provider, DeploymentConfiguration config) {
        this.provider = provider;
        this.config = config;
        String[] ddLocs = ModuleDDSupport.getDDPaths(provider.getJ2eeModule().getModuleType());
        for (int i = 0; i < ddLocs.length; ++i) {
            this.createRoot(ddLocs[i]);
        }
    }

    private ModuleType getModuleType() {
        return (ModuleType)this.provider.getJ2eeModule().getModuleType();
    }

    private BaseBean getDeploymentDescriptor(String ddLoc) {
        return this.provider.getJ2eeModule().getDeploymentDescriptor(ddLoc);
    }

    private DDRoot createRoot(String ddLoc) {
        BaseBean bean = this.getDeploymentDescriptor(ddLoc);
        if (bean == null) {
            return null;
        }
        while (!bean.isRoot()) {
            bean = bean.parent();
        }
        DDRoot root = new DDRoot(new DDNodeBean(null, bean, this));
        this.rootMap.put(ddLoc, root);
        this.beanMap.put(bean, root);
        PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)root.proxy.bean);
        this.listenerMap.put(bean, weakListener);
        bean.addPropertyChangeListener(weakListener);
        return root;
    }

    public DeployableObject getDeployableObject() {
        return this.config.getDeployableObject();
    }

    public DDRoot getDDBeanRoot() {
        String loc = ((String[])moduleDDlocationMap.get(this.getModuleType()))[0];
        return this.getDDBeanRoot(loc);
    }

    public DDRoot getDDBeanRoot(String loc) {
        DDRoot root = (DDRoot)this.rootMap.get(loc);
        if (root == null && !ModuleDDSupport.isPrimaryDD(loc, this.getType())) {
            DConfigBeanRoot cbroot;
            DConfigBean cb;
            root = this.createRoot(loc);
            DDRoot proot = this.getPrimaryDD();
            ConfigBeanStorage configRoot = (ConfigBeanStorage)this.configMap.get(proot);
            if (root != null && configRoot != null && (cb = (cbroot = (DConfigBeanRoot)configRoot.getConfigBean()).getDConfigBean((DDBeanRoot)root)) != null) {
                try {
                    ConfigBeanStorage cbs = new ConfigBeanStorage(cb, null, configRoot.getStorage());
                    this.configMap.put(root, cbs);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
        return root;
    }

    public ModuleType getType() {
        return this.getModuleType();
    }

    public String getVersion() {
        return this.provider.getJ2eeModule().getModuleVersion();
    }

    public Class getClassFromScope(String cls) {
        return null;
    }

    public Node[] getNodes() {
        String[] ddLocs = (String[])moduleDDlocationMap.get(this.getModuleType());
        ArrayList<Node> ret = new ArrayList<Node>();
        for (int i = 0; i < ddLocs.length; ++i) {
            ConfigBeanStorage cbs;
            Object dd = this.rootMap.get(ddLocs[i]);
            if (dd == null || (cbs = (ConfigBeanStorage)this.configMap.get(dd)) == null) continue;
            Node n = cbs.getNode();
            if (n != null) {
                ret.add(n);
                continue;
            }
            throw new RuntimeException("CBS.getNode returned null");
        }
        return ret.toArray(new Node[ret.size()]);
    }

    public void resetConfigCache() {
        this.configMap = new IdentityHashMap(5);
        this.xpathListeners = new HashSet();
    }

    public void createConfigs(ConfigurationStorage storage) throws ConfigurationException {
        String[] ddLocs = (String[])moduleDDlocationMap.get(this.getModuleType());
        DDRoot root = (DDRoot)this.rootMap.get(ddLocs[0]);
        DConfigBeanRoot cbroot = this.config.getDConfigBeanRoot((DDBeanRoot)root);
        ConfigBeanStorage cbs = new ConfigBeanStorage((DConfigBean)cbroot, null, storage);
        this.configMap.put(root, cbs);
        Iterator it = this.rootMap.keySet().iterator();
        while (it.hasNext()) {
            DConfigBean cb;
            String ddLoc = (String)it.next();
            if (ModuleDDSupport.isPrimaryDD(ddLoc, this.getModuleType()) || (cb = cbroot.getDConfigBean((DDBeanRoot)(root = (DDRoot)this.rootMap.get(ddLoc)))) == null) continue;
            ConfigBeanStorage cbStorage = new ConfigBeanStorage(cb, null, storage);
            this.configMap.put(root, cbStorage);
        }
    }

    public static boolean isPrimaryDD(String ddLocation, Object type) {
        String[] ddLocs = (String[])moduleDDlocationMap.get(type);
        if (ddLocs.length < 1) {
            return false;
        }
        return ddLocs[0].equals(ddLocation);
    }

    private static Map filenameToPathMap() {
        if (filenameToPathMap == null) {
            filenameToPathMap = new HashMap();
            filenameToPathMap.put(ModuleDDSupport.filename("META-INF/application.xml"), "META-INF/application.xml");
            filenameToPathMap.put(ModuleDDSupport.filename("WEB-INF/web.xml"), "WEB-INF/web.xml");
            filenameToPathMap.put(ModuleDDSupport.filename("META-INF/ejb-jar.xml"), "META-INF/ejb-jar.xml");
            filenameToPathMap.put(ModuleDDSupport.filename("META-INF/ra.xml"), "META-INF/ra.xml");
            filenameToPathMap.put(ModuleDDSupport.filename("META-INF/application-client.xml"), "META-INF/application-client.xml");
            filenameToPathMap.put("META-INF/application.xml", "META-INF/application.xml");
            filenameToPathMap.put("WEB-INF/web.xml", "WEB-INF/web.xml");
            filenameToPathMap.put("META-INF/ejb-jar.xml", "META-INF/ejb-jar.xml");
            filenameToPathMap.put("META-INF/ra.xml", "META-INF/ra.xml");
            filenameToPathMap.put("META-INF/application-client.xml", "META-INF/application-client.xml");
        }
        return filenameToPathMap;
    }

    private static String filename(String path) {
        int i = path.lastIndexOf(SEPARATOR);
        return path.substring(i + 1);
    }

    public static String filenameToPath(String filename, Object type) {
        if (filename.endsWith(WEBSERVICES_XML)) {
            if (J2eeModule.EJB.equals(type)) {
                return "META-INF/webservices.xml";
            }
            return "WEB-INF/webservices.xml";
        }
        String name = (String)ModuleDDSupport.filenameToPathMap().get(filename);
        if (name == null) {
            name = filename;
        }
        return name;
    }

    public DDRoot getPrimaryDD() {
        ModuleType type = this.getType();
        String[] ddLocs = (String[])moduleDDlocationMap.get(type);
        if (ddLocs.length < 1) {
            return null;
        }
        return (DDRoot)this.rootMap.get(ddLocs[0]);
    }

    public void cleanup() {
        Iterator i = this.rootMap.values().iterator();
        while (i.hasNext()) {
            DDRoot root = (DDRoot)i.next();
            PropertyChangeListener weakListener = (PropertyChangeListener)this.listenerMap.get(root.proxy.bean);
            root.proxy.bean.removePropertyChangeListener(weakListener);
            ConfigBeanStorage cbs = (ConfigBeanStorage)this.configMap.get(root);
            try {
                if (this.config == null || cbs == null || cbs.bean == null) continue;
                this.config.removeDConfigBean((DConfigBeanRoot)cbs.bean);
            }
            catch (BeanNotFoundException bnfe) {
                ErrorManager.getDefault().log("BeanNotFoundException caught by ModuleDDSupport: " + bnfe.getMessage());
            }
        }
        this.listenerMap = null;
        this.rootMap = null;
        this.configMap = null;
        this.beanMap = null;
        this.xpathListeners = null;
        this.leafMap = null;
        this.provider = null;
    }

    StandardDDImpl getBean(BaseBean bean) {
        if (bean == null) {
            return null;
        }
        if (this.beanMap == null) {
            return null;
        }
        StandardDDImpl ret = (StandardDDImpl)this.beanMap.get(bean);
        if (ret == null && bean.parent() != null) {
            ret = new StandardDDImpl(new DDNodeBean(bean, this));
            this.beanMap.put(bean, ret);
        }
        return ret;
    }

    StandardDDImpl getBean(BaseProperty prop, int index) {
        if (index < 0) {
            return this.getBean(prop);
        }
        if (!this.leafMap.containsKey(prop)) {
            this.leafMap.put(prop, new StandardDDImpl[index + 1]);
        } else if (((StandardDDImpl[])this.leafMap.get(prop)).length <= index) {
            StandardDDImpl[] a = (StandardDDImpl[])this.leafMap.get(prop);
            StandardDDImpl[] b = new StandardDDImpl[index + 1];
            this.leafMap.put(prop, b);
            for (int i = 0; i < a.length; ++i) {
                b[i] = a[i];
            }
        }
        StandardDDImpl[] arr = (StandardDDImpl[])this.leafMap.get(prop);
        StandardDDImpl elem = arr[index];
        if (elem == null) {
            arr[index] = elem = new StandardDDImpl(new DDLeafBean(prop, index, this));
        }
        return elem;
    }

    StandardDDImpl getBean(BaseProperty prop) {
        StandardDDImpl elem = (StandardDDImpl)this.leafMap.get(prop);
        if (elem == null) {
            elem = new StandardDDImpl(new DDLeafBean(prop, this));
            this.leafMap.put(prop, elem);
        }
        return elem;
    }

    StandardDDImpl getBean(String name) {
        return this.getBean(name, this.getDDBeanRoot().proxy.bean);
    }

    StandardDDImpl getBean(String name, BaseBean rootBean) {
        Bean parent = GraphManager.getPropertyParent((Bean)rootBean, (String)name);
        if (parent == null) {
            return this.getDDBeanRoot();
        }
        String shortName = GraphManager.getPropertyName((String)name);
        int index = GraphManager.getPropertyIndex((Bean)rootBean, (String)name);
        BaseProperty prop = parent.getProperty(shortName);
        if (index < 0 && prop.isIndexed()) {
            index = 0;
        }
        StandardDDImpl ret = prop.isBean() ? (prop.isIndexed() ? this.getBean((BaseBean)parent.getValue(shortName, index)) : this.getBean((BaseBean)parent.getValue(shortName))) : (prop.isIndexed() ? this.getBean(prop, index) : this.getBean(prop));
        return ret;
    }

    void addXpathListener(DDCommon bean, String xpath, XpathListener listen) {
        this.xpathListeners.add(new XpathListenerStorage(bean, xpath, listen));
    }

    void removeXpathListener(DDCommon bean, String xpath, XpathListener listen) {
        this.xpathListeners.remove(new XpathListenerStorage(bean, xpath, listen));
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        String name = event.getPropertyName();
        if (this.rootMap == null) {
            ErrorManager.getDefault().notify(1, (Throwable)new Exception("ModuleDDSupport: Unexpected change event (NAME=" + name + ", old=" + oldValue + ", new=" + newValue + ") received on previously removed DDBean->DConfigBean graph.  See IZ 81332."));
            return;
        }
        try {
            StandardDDImpl eventBean = null;
            if (newValue == null && oldValue instanceof BaseBean) {
                eventBean = this.getBean((BaseBean)oldValue);
            } else {
                Object eventObj;
                Object object = eventObj = oldValue != null ? oldValue : newValue;
                if (!(eventObj instanceof BaseBean)) {
                    eventObj = event.getSource();
                }
                if (eventObj instanceof BaseBean) {
                    BaseBean root = (BaseBean)eventObj;
                    while (!root.isRoot()) {
                        root = root.parent();
                    }
                    boolean rootInCache = false;
                    Iterator ddRoots = this.rootMap.values().iterator();
                    while (ddRoots.hasNext()) {
                        DDRoot ddroot = (DDRoot)ddRoots.next();
                        if (ddroot.proxy == null || ddroot.proxy.bean != root) continue;
                        rootInCache = true;
                        break;
                    }
                    if (rootInCache) {
                        eventBean = this.getBean(name, root);
                    }
                }
                if (eventBean == null) {
                    eventBean = this.getBean(name);
                }
            }
            if (eventBean == null && oldValue instanceof Object[]) {
                Object value;
                int i;
                ArrayList<Object> newElements = new ArrayList<Object>();
                if (newValue != null) {
                    Object[] newValues = (Object[])newValue;
                    for (i = 0; i < newValues.length; ++i) {
                        if (newValues[i] == null) continue;
                        newElements.add(newValues[i]);
                    }
                }
                Object[] values = (Object[])oldValue;
                for (i = 0; i < values.length && (value = values[i]) instanceof BaseBean; ++i) {
                    if (newElements.contains(value)) {
                        newElements.remove(value);
                        continue;
                    }
                    StandardDDImpl valueBean = this.getBean((BaseBean)value);
                    if (valueBean == null) continue;
                    this.processEvent(value, null, valueBean.proxy, event);
                }
            }
            if (eventBean == null) {
                return;
            }
            if (oldValue == null && eventBean.proxy.isProxy()) {
                eventBean.setProxy(new DDNodeBean((DDProxy)eventBean.proxy));
                return;
            }
            this.processEvent(oldValue, newValue, eventBean.proxy, event);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void processEvent(Object oldValue, Object newValue, DDCommon eventBean, PropertyChangeEvent event) {
        String eventDtdPath = eventBean.getXpath();
        Object type = XpathEvent.BEAN_CHANGED;
        if (oldValue == null) {
            type = XpathEvent.BEAN_ADDED;
        }
        if (newValue == null) {
            type = XpathEvent.BEAN_REMOVED;
        }
        XpathEvent xe = new XpathEvent((DDBean)eventBean.container, type);
        xe.setChangeEvent(event);
        Object[] xpathListenerArray = this.xpathListeners.toArray();
        for (int i = 0; i < xpathListenerArray.length; ++i) {
            DDCommon rightBean;
            DDCommon leftBean;
            XpathListenerStorage x = (XpathListenerStorage)xpathListenerArray[i];
            if (x.bean == null) continue;
            String xp = x.getNormalizedPath();
            if (eventDtdPath.startsWith(xp)) {
                leftBean = x.bean;
                rightBean = eventBean;
            } else {
                if (!xp.startsWith(eventDtdPath)) continue;
                leftBean = eventBean;
                rightBean = x.bean;
            }
            while (leftBean != rightBean && rightBean != null) {
                rightBean = rightBean.parent;
            }
            if (leftBean != rightBean) continue;
            x.listen.fireXpathEvent(xe);
        }
        eventBean.fireEvent(xe);
    }

    static String normalizePath(String path) {
        boolean absolute = path.startsWith(SEPARATOR);
        StringTokenizer tokens = new StringTokenizer(path, SEPARATOR, false);
        LinkedList<Object> l = new LinkedList<Object>();
        while (tokens.hasMoreElements()) {
            l.addLast(tokens.nextElement());
        }
        int i = 0;
        while (i < l.size()) {
            String tok = (String)l.get(i);
            if (tok.equals(".")) {
                l.remove(i);
                continue;
            }
            if (tok.equals("..") && i > 0 && !l.get(i - 1).equals("..")) {
                l.remove(i);
                l.remove(i - 1);
                --i;
                continue;
            }
            ++i;
        }
        StringBuffer ret = new StringBuffer();
        for (int i2 = 0; i2 < l.size(); ++i2) {
            if (absolute || i2 > 0) {
                ret.append(SEPARATOR);
            }
            ret.append(l.get(i2));
        }
        return ret.toString();
    }

    public J2eeModuleProvider getProvider() {
        return this.provider;
    }

    static {
        moduleDDlocationMap.put(J2eeModule.EAR, new String[]{"META-INF/application.xml"});
        moduleDDlocationMap.put(J2eeModule.WAR, new String[]{"WEB-INF/web.xml", "WEB-INF/webservices.xml"});
        moduleDDlocationMap.put(J2eeModule.EJB, new String[]{"META-INF/ejb-jar.xml", "META-INF/webservices.xml"});
        moduleDDlocationMap.put(J2eeModule.CONN, new String[]{"META-INF/ra.xml"});
        moduleDDlocationMap.put(J2eeModule.CLIENT, new String[]{"META-INF/application-client.xml"});
    }

    private class XpathListenerStorage {
        private DDCommon bean = null;
        private String xpath;
        private boolean xpathRelative;
        private XpathListener listen;
        private String normal = null;

        XpathListenerStorage(DDCommon bean, String xpath, XpathListener listen) {
            this.bean = bean;
            this.xpath = xpath;
            this.listen = listen;
            this.xpathRelative = !xpath.startsWith(ModuleDDSupport.SEPARATOR);
        }

        public String getNormalizedPath() {
            if (this.normal == null) {
                String base = this.xpath;
                if (this.xpathRelative) {
                    base = this.bean.getXpath() + ModuleDDSupport.SEPARATOR + base;
                }
                this.normal = ModuleDDSupport.normalizePath(base);
            }
            return this.normal;
        }

        public String toString() {
            return this.bean + " " + this.xpath + " " + this.listen;
        }

        public int hashCode() {
            return this.listen.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof XpathListenerStorage) {
                XpathListenerStorage x = (XpathListenerStorage)o;
                return x.bean == this.bean && x.xpath == this.xpath && x.listen == this.listen;
            }
            return false;
        }
    }
}

