/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.config.ui;

import java.awt.Component;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.sun.share.config.ConfigBeanStorage;
import org.netbeans.modules.j2ee.sun.share.config.ConfigurationStorage;
import org.netbeans.modules.j2ee.sun.share.config.ui.ConfigUtils;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.DConfigBeanProperties;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListeners;

public class ConfigBeanNode
extends AbstractNode
implements PropertyChangeListener {
    final ConfigBeanStorage bean;
    final BeanInfo info;
    final DConfigBeanProperties extraProps;
    private static final Action[] EMPTY_ACTIONS = new Action[0];

    public ConfigBeanNode(ConfigBeanStorage bean) {
        super((Children)new ConfigChildren(bean));
        this.bean = bean;
        this.info = ConfigUtils.createBeanInfo(bean.getConfigBean());
        DConfigBean dcb = bean.getConfigBean();
        this.extraProps = dcb instanceof Base ? ((Base)dcb).getUICustomization(dcb) : null;
        ConfigurationStorage storage = bean.getStorage();
        storage.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)storage));
    }

    public String getDisplayName() {
        if (this.extraProps != null) {
            return this.extraProps.getDisplayName();
        }
        if (this.info == null) {
            return this.bean.getClass().toString();
        }
        return this.info.getBeanDescriptor().getDisplayName();
    }

    public Node.Cookie getCookie(Class type) {
        if (SaveCookie.class.isAssignableFrom(type)) {
            return this.bean.getStorage().getPrimaryDataObject().getCookie(type);
        }
        return super.getCookie(type);
    }

    public Action[] getActions(boolean context) {
        return EMPTY_ACTIONS;
    }

    public HelpCtx getHelpCtx() {
        String helpId;
        if (this.extraProps != null && (helpId = this.extraProps.getHelpId()) != null) {
            return new HelpCtx(helpId);
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Image getIcon(int type) {
        Image icon;
        if (this.info != null && (icon = this.info.getIcon(type)) != null) {
            return icon;
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        Image icon;
        if (this.info != null && (icon = this.info.getIcon(type)) != null) {
            return icon;
        }
        return super.getOpenedIcon(type);
    }

    public Sheet createSheet() {
        Sheet ret = new Sheet();
        Sheet.Set set = ConfigUtils.createSheet(this.bean);
        set.setName(this.getDisplayName());
        ret.put(set);
        return ret;
    }

    public DConfigBean getBean() {
        return this.bean.getConfigBean();
    }

    public Component getCustomizer() {
        Component comp = null;
        if (!this.hasCustomizer()) {
            return null;
        }
        try {
            return (Component)this.info.getBeanDescriptor().getCustomizerClass().newInstance();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return comp;
        }
    }

    public boolean hasCustomizer() {
        return this.info.getBeanDescriptor().getCustomizerClass() != null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("cookie".equals(evt.getPropertyName())) {
            this.fireCookieChange();
        }
    }

    public static class ConfigChildren
    extends Children.Keys
    implements ConfigBeanStorage.ChildrenChangeListener {
        ConfigBeanStorage bean;

        ConfigChildren(ConfigBeanStorage bean) {
            this.bean = bean;
        }

        protected void addNotify() {
            this.updateKeys();
            this.bean.addChildrenChangeListener(this);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.bean.removeChildrenChangeListener(this);
        }

        void updateKeys() {
            this.setKeys(this.bean.getChildMap().keySet());
        }

        void updateKey(Object key) {
            this.refreshKey(key);
        }

        protected Node[] createNodes(Object key) {
            Collection nodeSet = (Collection)this.bean.getChildMap().get(key);
            ArrayList<Node> ret = new ArrayList<Node>();
            Iterator i = nodeSet.iterator();
            int c = 0;
            while (i.hasNext()) {
                ConfigBeanStorage cbs = (ConfigBeanStorage)i.next();
                Node node = cbs.getNode();
                if (node != null) {
                    ret.add(node);
                }
                ++c;
            }
            return ret.toArray(new Node[ret.size()]);
        }

        public void childBeanAdded(final ConfigBeanStorage childStorage) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChildren.this.updateKeys();
                    ConfigChildren.this.refreshKey(childStorage.getConfigBean().getDDBean().getXpath());
                }
            });
        }

        public void childBeanRemoved(final ConfigBeanStorage childStorage) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConfigChildren.this.updateKey(childStorage.getConfigBean().getDDBean().getXpath());
                }
            });
        }
    }
}

