/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.sun.share.configbean.Base;
import org.netbeans.modules.j2ee.sun.share.configbean.BaseEjb;
import org.openide.ErrorManager;

public class EntityEjb
extends BaseEjb {
    private String isReadOnlyBean;
    private String refreshPeriodInSeconds;
    private String commitOption;

    protected void init(DDBean dDBean, Base parent) throws ConfigurationException {
        super.init(dDBean, parent);
        this.addVetoableChangeListener(new VetoRefreshPeriodChange());
        this.addPropertyChangeListener(new KeepRefreshPeriodValid());
    }

    Collection getSnippets() {
        ArrayList<EntityEjbSnippet> snippets = new ArrayList<EntityEjbSnippet>();
        snippets.add(new EntityEjbSnippet());
        return snippets;
    }

    protected void loadEjbProperties(Ejb savedEjb) {
        super.loadEjbProperties(savedEjb);
        this.isReadOnlyBean = savedEjb.getIsReadOnlyBean();
        this.refreshPeriodInSeconds = savedEjb.getRefreshPeriodInSeconds();
        this.commitOption = savedEjb.getCommitOption();
    }

    protected void clearProperties() {
        super.clearProperties();
        this.isReadOnlyBean = null;
        this.refreshPeriodInSeconds = null;
        this.commitOption = null;
    }

    public void fireXpathEvent(XpathEvent xpathEvent) {
        super.fireXpathEvent(xpathEvent);
        DDBean eventBean = xpathEvent.getBean();
        String xpath = eventBean.getXpath();
        if ("/ejb-jar/enterprise-beans/entity/remote".equals(xpath)) {
            try {
                if (xpathEvent.isAddEvent()) {
                    this.setJndiName(this.getDefaultJndiName());
                } else if (xpathEvent.isRemoveEvent()) {
                    this.setJndiName(null);
                }
            }
            catch (PropertyVetoException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public String getIsReadOnlyBean() {
        return this.isReadOnlyBean;
    }

    public void setIsReadOnlyBean(String isReadOnlyBean) throws PropertyVetoException {
        String oldIsReadOnlyBean = this.isReadOnlyBean;
        this.getVCS().fireVetoableChange("isReadOnlyBean", oldIsReadOnlyBean, isReadOnlyBean);
        this.isReadOnlyBean = isReadOnlyBean;
        this.getPCS().firePropertyChange("isReadOnlyBean", oldIsReadOnlyBean, isReadOnlyBean);
    }

    public String getRefreshPeriodInSeconds() {
        return this.refreshPeriodInSeconds;
    }

    public void setRefreshPeriodInSeconds(String refreshPeriodInSeconds) throws PropertyVetoException {
        String oldRefreshPeriodInSeconds = this.refreshPeriodInSeconds;
        this.getVCS().fireVetoableChange("refreshPeriodInSeconds", oldRefreshPeriodInSeconds, refreshPeriodInSeconds);
        this.refreshPeriodInSeconds = refreshPeriodInSeconds;
        this.getPCS().firePropertyChange("refreshPeriodInSeconds", oldRefreshPeriodInSeconds, refreshPeriodInSeconds);
    }

    public String getCommitOption() {
        return this.commitOption;
    }

    public void setCommitOption(String commitOption) throws PropertyVetoException {
        String oldCommitOption = this.commitOption;
        this.getVCS().fireVetoableChange("commitOption", oldCommitOption, commitOption);
        this.commitOption = commitOption;
        this.getPCS().firePropertyChange("commitOption", oldCommitOption, commitOption);
    }

    public String getHelpId() {
        return "AS_CFG_EntityEjb";
    }

    public class KeepRefreshPeriodValid
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                String propName = evt.getPropertyName();
                if (propName.indexOf("isReadOnlyBean") > -1) {
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (newValue.equals(Boolean.TRUE)) {
                        EntityEjb.this.setRefreshPeriodInSeconds("60");
                    }
                    if (newValue.equals(Boolean.FALSE)) {
                        EntityEjb.this.setRefreshPeriodInSeconds(null);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class VetoRefreshPeriodChange
    implements VetoableChangeListener {
        VetoRefreshPeriodChange() {
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            boolean acceptable = true;
            String failureMessage = "bad things happen";
            try {
                String propName = evt.getPropertyName();
                if (propName.indexOf("refreshPeriodInSeconds") > -1 && (null == EntityEjb.this.isReadOnlyBean || EntityEjb.this.isReadOnlyBean.equals("false")) && evt.getNewValue() != null) {
                    failureMessage = "property only valid for read-only beans";
                }
            }
            catch (Exception ex) {
                acceptable = false;
            }
            if (!acceptable) {
                throw new PropertyVetoException(failureMessage, evt);
            }
        }
    }

    protected class EntityEjbSnippet
    extends BaseEjb.BaseEjbSnippet {
        protected EntityEjbSnippet() {
        }

        public CommonDDBean getDDSnippet() {
            Ejb ejb = (Ejb)super.getDDSnippet();
            if (EntityEjb.this.isReadOnlyBean != null) {
                ejb.setIsReadOnlyBean(EntityEjb.this.isReadOnlyBean);
            }
            if (EntityEjb.this.refreshPeriodInSeconds != null) {
                ejb.setRefreshPeriodInSeconds(EntityEjb.this.refreshPeriodInSeconds);
            }
            if (EntityEjb.this.commitOption != null) {
                ejb.setCommitOption(EntityEjb.this.commitOption);
            }
            return ejb;
        }

        public boolean hasDDSnippet() {
            if (super.hasDDSnippet()) {
                return true;
            }
            if (EntityEjb.this.isReadOnlyBean != null) {
                return true;
            }
            if (EntityEjb.this.refreshPeriodInSeconds != null) {
                return true;
            }
            return EntityEjb.this.commitOption != null;
        }
    }
}

