/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.templates;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.sun.share.configbean.SunONEDeploymentConfiguration;
import org.netbeans.modules.j2ee.sun.share.configbean.templates.SunDDWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public final class SunDDWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new SunDDWizardPanel()};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        Set<FileObject> result = Collections.EMPTY_SET;
        SunDDWizardPanel wizardPanel = (SunDDWizardPanel)this.panels[0];
        File configDir = wizardPanel.getSelectedLocation();
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        FileObject configFolder = FileUtil.toFileObject((File)configDir);
        Project project = wizardPanel.getProject();
        String sunDDFileName = wizardPanel.getFileName();
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
        if (configFolder != null) {
            String resource = "org-netbeans-modules-j2ee-sun-ddui/" + sunDDFileName;
            FileObject sunDDTemplate = Repository.getDefault().getDefaultFileSystem().findResource(resource);
            if (sunDDTemplate != null) {
                FileSystem fs = configFolder.getFileSystem();
                XmlFileCreator creator = new XmlFileCreator(sunDDTemplate, configFolder, sunDDTemplate.getName(), sunDDTemplate.getExt());
                fs.runAtomicAction((FileSystem.AtomicAction)creator);
                FileObject sunDDFO = creator.getResult();
                if (sunDDFO != null) {
                    SunONEDeploymentConfiguration config = SunONEDeploymentConfiguration.getConfiguration(FileUtil.toFile((FileObject)sunDDFO));
                    if (config != null) {
                        config.setAppServerVersion(config.getMaxASVersion());
                    } else {
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)SunDDWizardIterator.class, (String)"ERR_NoDeploymentConfiguration"), 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    result = Collections.singleton(creator.getResult());
                } else {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)SunDDWizardIterator.class, (String)"ERR_FileCreationFailed", (Object)sunDDFileName), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            } else {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)SunDDWizardIterator.class, (String)"ERR_TemplateNotFound", (Object)resource), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        } else {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)SunDDWizardIterator.class, (String)"ERR_LocationNotFound", (Object)configDir.getAbsolutePath()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
        return result;
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    private static class XmlFileCreator
    implements FileSystem.AtomicAction {
        private final FileObject source;
        private final FileObject destFolder;
        private final String name;
        private final String ext;
        private FileObject result;

        XmlFileCreator(FileObject source, FileObject destFolder, String name, String ext) {
            this.source = source;
            this.destFolder = destFolder;
            this.name = name;
            this.ext = ext;
            this.result = null;
        }

        public void run() throws IOException {
            this.result = FileUtil.copyFile((FileObject)this.source, (FileObject)this.destFolder, (String)this.name, (String)this.ext);
        }

        public FileObject getResult() {
            return this.result;
        }
    }
}

