/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.tasklist.client.Suggestion;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.suggestions.SPIMonitor;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.filesystems.FileObject;

public class DefaultSuggestionManager
extends SuggestionManager {
    private SuggestionType unfilteredType = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SuggestionAgent createSuggestion(FileObject fo, String type, String summary, SuggestionPerformer action, Object data) {
        if (summary.indexOf(10) != -1) {
            int n = summary.length();
            StringBuffer sb = new StringBuffer(2 * n);
            for (int i = 0; i < n; ++i) {
                char c = summary.charAt(i);
                if (c == '\n') {
                    sb.append(':');
                    sb.append(' ');
                    continue;
                }
                if (c == '\r') continue;
                sb.append(c);
            }
            summary = sb.toString();
        }
        SPIMonitor.log("  create type: " + type + " summary: " + summary);
        SuggestionType st = SuggestionTypes.getDefault().getType(type);
        if (st == null) {
            throw new IllegalArgumentException("type " + st + " is not registered");
        }
        SuggestionImpl s = new SuggestionImpl(fo, summary, st, action, data);
        return new SuggestionAgent((Suggestion)s);
    }

    public boolean isEnabled(String id) {
        return true;
    }

    public boolean isObserved(String id) {
        return true;
    }

    public void register(String type, List add, List remove) {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"This public contract is not implemented use private one!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String typeName, List addList, List removeList, SuggestionList tasklist, boolean sizeKnown) {
        SuggestionType type = null;
        if (typeName != null && (type = SuggestionTypes.getDefault().getType(typeName)) == null) {
            throw new IllegalArgumentException("No such SuggestionType: " + typeName);
        }
        boolean split = type == null;
        ListIterator ita = null;
        ListIterator itr = null;
        if (split) {
            ArrayList<SuggestionImpl> allAdds = addList;
            ArrayList<SuggestionImpl> allRems = removeList;
            if (allAdds != null) {
                ita = allAdds.listIterator();
                addList = new ArrayList<SuggestionImpl>(allAdds.size());
            }
            if (allRems != null) {
                itr = allRems.listIterator();
                removeList = new ArrayList<SuggestionImpl>(allRems.size());
            }
        }
        do {
            if (split) {
                SuggestionImpl s;
                if (ita != null && ita.hasNext()) {
                    addList.clear();
                    type = null;
                    while (ita.hasNext()) {
                        s = (SuggestionImpl)((Object)ita.next());
                        if (type == null) {
                            type = s.getSType();
                        } else if (s.getSType() != type) {
                            ita.previous();
                            break;
                        }
                        addList.add(s);
                    }
                } else {
                    addList = null;
                }
                if (itr != null && itr.hasNext()) {
                    removeList.clear();
                    type = null;
                    while (itr.hasNext()) {
                        s = (SuggestionImpl)((Object)itr.next());
                        if (type == null) {
                            type = s.getSType();
                        } else if (s.getSType() != type) {
                            itr.previous();
                            break;
                        }
                        removeList.add(s);
                    }
                } else {
                    removeList = null;
                }
                if (addList == null && removeList == null) break;
            }
            SuggestionImpl category = tasklist.getCategoryTask(type, false);
            int currnum = 0;
            if (category != null) {
                currnum = category.subtasksCount();
            } else {
                Iterator it = tasklist.getTasks().iterator();
                while (it.hasNext()) {
                    SuggestionImpl s = (SuggestionImpl)((Object)it.next());
                    if (s.getSType() != type) continue;
                    ++currnum;
                }
            }
            int addnum = addList != null ? addList.size() : 0;
            int remnum = removeList != null ? removeList.size() : 0;
            int newSize = currnum + addnum - remnum;
            if (newSize > tasklist.getGroupTreshold() && this.getUnfilteredType() == null) {
                if (category == null) {
                    category = tasklist.getCategoryTask(type, true);
                    DefaultSuggestionManager defaultSuggestionManager = this;
                    synchronized (defaultSuggestionManager) {
                        ArrayList<SuggestionImpl> leftover = null;
                        if (removeList != null) {
                            tasklist.addRemove(null, removeList, true, null, null);
                        }
                        if (currnum - remnum > 0) {
                            leftover = new ArrayList<SuggestionImpl>(currnum);
                            Iterator it = tasklist.getTasks().iterator();
                            while (it.hasNext()) {
                                SuggestionImpl s = (SuggestionImpl)((Object)it.next());
                                if (s.getSType() != type || s == category) continue;
                                leftover.add(s);
                            }
                        }
                        if (leftover != null && leftover.size() > 0) {
                            tasklist.addRemove(null, leftover, false, null, null);
                            tasklist.addRemove(leftover, null, true, category, null);
                        }
                        tasklist.addRemove(addList, null, true, category, null);
                    }
                } else {
                    tasklist.addRemove(addList, removeList, false, category, null);
                }
                DefaultSuggestionManager.updateCategoryCount(category, sizeKnown);
                continue;
            }
            SuggestionImpl after = tasklist.findAfter(type);
            if (category == null) {
                boolean append = after == null;
                tasklist.addRemove(addList, removeList, append, null, after);
                continue;
            }
            DefaultSuggestionManager defaultSuggestionManager = this;
            synchronized (defaultSuggestionManager) {
                if (removeList != null) {
                    tasklist.addRemove(null, removeList, false, category, null);
                }
                List leftover = category.getSubtasks();
                if (addList != null) {
                    tasklist.addRemove(addList, null, true, null, after);
                }
                if (leftover != null && leftover.size() > 0) {
                    tasklist.addRemove(leftover, null, true, null, after);
                }
            }
            tasklist.removeCategory(category, true);
        } while (split);
    }

    private static void updateCategoryCount(SuggestionImpl category, boolean sizeKnown) {
        SuggestionType type = category.getSType();
        int count = category.subtasksCount();
        String summary = count != 0 || sizeKnown ? type.getLocalizedName() + " (" + Integer.toString(count) + ")" : type.getLocalizedName();
        category.setSummary(summary);
    }

    protected final SuggestionType getUnfilteredType() {
        return this.unfilteredType;
    }

    protected final void setUnfilteredType(SuggestionType unfilteredType) {
        this.unfilteredType = unfilteredType;
    }

    static {
        $assertionsDisabled = !DefaultSuggestionManager.class.desiredAssertionStatus();
    }
}

