/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderInstance;

public final class SuggestionTypesFolder
extends FolderInstance {
    private static final String FOLDER = "Suggestions/Types";
    private static SuggestionTypesFolder folder;
    private Map suggestionTypes;
    private FileObject fo;

    private SuggestionTypesFolder(FileObject fo, DataFolder fld) {
        super(fld);
        this.recreate();
        this.instanceFinished();
        this.fo = fo;
    }

    public static synchronized SuggestionTypesFolder getSuggestionTypesFolder() {
        if (folder != null) {
            return folder;
        }
        FileObject f = Repository.getDefault().getDefaultFileSystem().findResource(FOLDER);
        if (f == null) {
            return null;
        }
        try {
            DataObject d = DataObject.find((FileObject)f);
            DataFolder df = (DataFolder)d.getCookie(DataFolder.class);
            if (df != null) {
                folder = new SuggestionTypesFolder(f, df);
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
        return folder;
    }

    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        this.suggestionTypes = new HashMap(cookies.length * 4 / 3);
        for (int i = 0; i < cookies.length; ++i) {
            Object o = cookies[i].instanceCreate();
            if (!(o instanceof SuggestionType)) continue;
            SuggestionType type = (SuggestionType)o;
            type.setPosition(i);
            this.suggestionTypes.put(type.getName(), type);
        }
        SuggestionTypes.getDefault().setTypes(this.suggestionTypes);
        return null;
    }
}

