/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.Map;
import javax.persistence.OneToMany;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.CollectionAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;

public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        OneToMany oneToMany = (OneToMany)this.getAnnotation(OneToMany.class);
        if (oneToMany != null) {
            this.setFetchType(oneToMany.fetch());
            this.setMappedBy(oneToMany.mappedBy());
            this.setCascadeTypes(oneToMany.cascade());
            this.setTargetEntity(oneToMany.targetEntity());
        }
    }

    public boolean isOneToMany() {
        return true;
    }

    public void process() {
        String mappedBy = this.getMappedBy();
        if (mappedBy.equals("")) {
            if (this.hasJoinColumn() || this.hasJoinColumns()) {
                this.getValidator().throwUniDirectionalOneToManyHasJoinColumnSpecified(this.getJavaClass(), this.getAttributeName());
            }
            ManyToManyMapping mapping = new ManyToManyMapping();
            this.populateCollectionMapping(mapping, "metadata_default_one_to_many_reference_class");
            this.processJoinTable(this.getJoinTable(), mapping);
            this.m_descriptor.addMapping(mapping);
        } else {
            OneToManyMapping mapping = new OneToManyMapping();
            this.populateCollectionMapping(mapping, "metadata_default_one_to_many_reference_class");
            OneToOneMapping ownerMapping = null;
            if (this.getOwningMapping().isOneToOneMapping()) {
                ownerMapping = (OneToOneMapping)this.getOwningMapping();
            } else {
                this.getValidator().throwIvalidMappingEncountered(this.getJavaClass(), this.getReferenceClass());
            }
            Map keys = ownerMapping.getSourceToTargetKeyFields();
            for (DatabaseField fkField : keys.keySet()) {
                mapping.addTargetForeignKeyField(fkField, (DatabaseField)keys.get(fkField));
            }
            this.m_descriptor.addMapping(mapping);
        }
    }
}

