/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.expressions.SQLUpdateStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.DatasourceCallQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;

public class CallQueryMechanism
extends DatasourceCallQueryMechanism {
    public CallQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public CallQueryMechanism(DatabaseQuery query, DatabaseCall call) {
        super(query, call);
        call.setIsFieldMatchingRequired(true);
    }

    public DatabaseCall getDatabaseCall() {
        return (DatabaseCall)this.call;
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery query = this.getQuery();
        AbstractSession executionSession = this.getSession().getExecutionSession(query);
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                if (!query.shouldIgnoreBindAllParameters()) {
                    call.setUsesBinding(query.shouldBindAllParameters());
                }
                if (!query.shouldIgnoreCacheStatement()) {
                    call.setShouldCacheStatement(query.shouldCacheStatement());
                }
                if (query.isReadQuery()) {
                    ReadQuery readQuery = (ReadQuery)query;
                    call.setMaxRows(readQuery.getMaxRows());
                    if (readQuery.getFirstResult() != 0) {
                        call.setFirstResult(readQuery.getFirstResult());
                        call.setIsResultSetScrollable(true);
                        call.setResultSetType(1004);
                        call.setResultSetConcurrency(1007);
                    }
                }
                call.prepare(executionSession);
            }
        } else if (this.getCall() != null) {
            DatabaseCall call = this.getDatabaseCall();
            if (!query.shouldIgnoreBindAllParameters()) {
                call.setUsesBinding(query.shouldBindAllParameters());
            }
            if (!query.shouldIgnoreCacheStatement()) {
                call.setShouldCacheStatement(query.shouldCacheStatement());
            }
            if (query.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)query;
                call.setMaxRows(readQuery.getMaxRows());
                if (readQuery.getFirstResult() != 0) {
                    call.setFirstResult(readQuery.getFirstResult());
                    call.setIsResultSetScrollable(true);
                    call.setResultSetType(1004);
                    call.setResultSetConcurrency(1007);
                }
            }
            call.prepare(executionSession);
        }
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                call.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                call.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField field) {
        this.getCall().returnOneRow();
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(1);
        ((Vector)fields).addElement(field);
        this.getDatabaseCall().setFields(fields);
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall databseCall = (DatabaseCall)callsEnum.nextElement();
                databseCall.returnManyRows();
                databseCall.setIsFieldMatchingRequired(this.isCallQueryMechanism());
            }
        } else {
            DatabaseCall call = this.getDatabaseCall();
            call.returnManyRows();
            call.setIsFieldMatchingRequired(this.isCallQueryMechanism());
        }
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnManyRows();
                if (!this.isCallQueryMechanism()) continue;
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
            }
        } else {
            this.getCall().returnManyRows();
            if (this.isCallQueryMechanism()) {
                DatabaseCall call = this.getDatabaseCall();
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
            }
        }
        this.prepareCall();
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnOneRow();
                if (!this.isCallQueryMechanism()) continue;
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
            }
        } else {
            this.getCall().returnOneRow();
            if (this.isCallQueryMechanism()) {
                DatabaseCall call = this.getDatabaseCall();
                call.setIsFieldMatchingRequired(true);
                call.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
            }
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall call = (DatabaseCall)callsEnum.nextElement();
                call.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                call.setHasOptimisticLock(true);
            }
        } else if (this.getCall() != null) {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void setCallHasCustomSQLArguments() {
        if (this.hasMultipleCalls()) {
            Enumeration callsEnum = this.getCalls().elements();
            while (callsEnum.hasMoreElements()) {
                DatabaseCall databseCall = (DatabaseCall)callsEnum.nextElement();
                if (!databseCall.isSQLCall()) continue;
                ((SQLCall)databseCall).setHasCustomSQLArguments(true);
            }
        } else if (this.getCall().isSQLCall()) {
            ((SQLCall)this.getCall()).setHasCustomSQLArguments(true);
        }
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeQuery) {
        Enumeration tablesEnum = this.getDescriptor().getTables().elements();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = (DatabaseTable)tablesEnum.nextElement();
            SQLUpdateStatement updateStatement = new SQLUpdateStatement();
            updateStatement.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdate(writeQuery));
            updateStatement.setTranslationRow(this.getTranslationRow());
            updateStatement.setTable(table);
            updateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildPrimaryKeyExpression(table));
            StatementQueryMechanism updateMechanism = new StatementQueryMechanism((DatabaseQuery)writeQuery, updateStatement);
            writeQuery.setModifyRow(updateStatement.getModifyRow());
            updateMechanism.updateObject();
        }
    }
}

