/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.java.parser;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import org.netbeans.lib.java.parser.ASTContext;
import org.netbeans.lib.java.parser.CompilerException;
import org.netbeans.lib.java.parser.ECRequestDesc;
import org.netbeans.lib.java.parser.ErrorChecker;
import org.netbeans.lib.java.parser.JParser;
import org.netbeans.lib.java.parser.JScanner;
import org.netbeans.lib.java.parser.Parser;
import org.netbeans.lib.java.parser.Scanner;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;

public final class Factory {
    private static Factory instance = null;
    private static Constructor newParser;
    private static Method newScanner;
    private static Constructor newErrorChecker;

    public static synchronized Factory getDefault() {
        if (instance == null) {
            instance = new Factory();
            Class[] newParserTypes = new Class[]{ASTContext.class, Reader.class, String.class};
            Class[] newScannerTypes = new Class[]{Reader.class, String.class, Boolean.TYPE};
            Class[] newCheckerTypes = new Class[]{ECRequestDesc.class};
            File gjastJar = InstalledFileLocator.getDefault().locate("modules/ext/gjast.jar", "org.netbeans.modules.javacore", false);
            if (gjastJar != null) {
                try {
                    GJASTClassLoader loader = new GJASTClassLoader(gjastJar.toURI().toURL());
                    Class<?> c = Class.forName("org.netbeans.lib.gjast.ASParser", true, loader);
                    newParser = c.getConstructor(newParserTypes);
                    c = Class.forName("org.netbeans.lib.gjast.ASScanner$Factory", true, loader);
                    newScanner = c.getMethod("newScanner", newScannerTypes);
                    c = Class.forName("org.netbeans.lib.gjast.ASErrorChecker", true, loader);
                    newErrorChecker = c.getConstructor(newCheckerTypes);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot load javac bridge classes: " + e);
                }
            }
            ErrorManager.getDefault().log(256, "javac bridge not present");
            try {
                newParser = Parser.class.getConstructor(newParserTypes);
                newScanner = Scanner.class.getMethod("newScanner", newScannerTypes);
                newErrorChecker = DummyErrorChecker.class.getConstructor(newCheckerTypes);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot load parser classes: " + e);
            }
        }
        return instance;
    }

    public JParser getParser(ASTContext context, Reader in, String filename) {
        try {
            return (JParser)newParser.newInstance(context, in, filename);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create parser: " + e);
        }
    }

    public JScanner getScanner(Reader in, String sourceLevel) {
        return this.getScanner(in, sourceLevel, false);
    }

    public JScanner getScanner(Reader in, String sourceLevel, boolean liteScanning) {
        try {
            return (JScanner)newScanner.invoke(null, in, sourceLevel, liteScanning);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            System.err.println("Factory: cannot create scanner " + (t != null ? t : e));
            throw new RuntimeException("Cannot create scanner: " + t != null ? t : e);
        }
    }

    public ErrorChecker getErrorChecker(ECRequestDesc desc) {
        try {
            return (ErrorChecker)newErrorChecker.newInstance(desc);
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            throw new RuntimeException("Cannot create errorChecker: " + t != null ? t : e);
        }
    }

    private static class DummyErrorChecker
    implements ErrorChecker {
        public DummyErrorChecker(ECRequestDesc desc) {
        }

        public int parse() throws CompilerException {
            return 0;
        }
    }

    private static class GJASTClassLoader
    extends URLClassLoader {
        private final PermissionCollection permissions = new Permissions();

        public GJASTClassLoader(URL gjastJar) {
            super(new URL[]{gjastJar}, Factory.class.getClassLoader());
            this.permissions.add(new AllPermission());
        }

        protected Class loadClass(String n, boolean r) throws ClassNotFoundException {
            if (n.startsWith("com.sun.tools.javac") || n.startsWith("org.netbeans.lib.gjast")) {
                Class<?> c = this.findLoadedClass(n);
                if (c != null) {
                    return c;
                }
                c = this.findClass(n);
                if (r) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(n, r);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            return this.permissions;
        }
    }
}

