/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.CodeTemplateSettings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

final class AbbrevSettings
implements LookupListener {
    private static final KeyStroke DEFAULT_EXPANSION_KEYSTROKE = KeyStroke.getKeyStroke(' ');
    private static final Map mimeType2settings = new HashMap();
    private Lookup.Result codeTemplateSettingsLookupResult;
    private KeyStroke expandKeyStroke;

    public static synchronized AbbrevSettings get(String mimeType) {
        AbbrevSettings settings = (AbbrevSettings)mimeType2settings.get(mimeType);
        if (settings == null) {
            settings = new AbbrevSettings(mimeType);
            mimeType2settings.put(mimeType, settings);
        }
        return settings;
    }

    public static KeyStroke getDefaultExpansionKeyStroke() {
        return DEFAULT_EXPANSION_KEYSTROKE;
    }

    AbbrevSettings(String mimeType) {
        MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)mimeType);
        this.codeTemplateSettingsLookupResult = mimeLookup.lookup(new Lookup.Template(CodeTemplateSettings.class));
        this.codeTemplateSettingsLookupResult.addLookupListener((LookupListener)WeakListeners.create((Class)LookupListener.class, (EventListener)((Object)this), (Object)mimeLookup));
        this.resultChanged(null);
    }

    public KeyStroke getExpandKeyStroke() {
        KeyStroke eks = BaseOptions.getCodeTemplateExpandKey();
        if (eks == null) {
            eks = AbbrevSettings.getDefaultExpansionKeyStroke();
        }
        eks = this.patchExpandKeystroke(eks);
        return eks;
    }

    public String getExpandKeyStrokeText() {
        KeyStroke expandKeyStroke = this.getExpandKeyStroke();
        String expandKeyStrokeText = expandKeyStroke.equals(KeyStroke.getKeyStroke(' ')) ? "SPACE" : (expandKeyStroke.equals(KeyStroke.getKeyStroke(new Character(' '), 1)) ? "Shift-SPACE" : (expandKeyStroke.equals(KeyStroke.getKeyStroke(9, 0)) ? "TAB" : (expandKeyStroke.equals(KeyStroke.getKeyStroke(10, 0)) ? "ENTER" : expandKeyStroke.toString())));
        return expandKeyStrokeText;
    }

    public void resultChanged(LookupEvent ev) {
    }

    private KeyStroke patchExpandKeystroke(KeyStroke eks) {
        if (eks.equals(KeyStroke.getKeyStroke(32, 0))) {
            eks = KeyStroke.getKeyStroke(' ');
        } else if (eks.equals(KeyStroke.getKeyStroke(32, 1))) {
            eks = KeyStroke.getKeyStroke(new Character(' '), 1);
        } else if (eks.equals(KeyStroke.getKeyStroke(9, 0)) || eks.equals(KeyStroke.getKeyStroke(10, 0))) {
            // empty if block
        }
        return eks;
    }
}

