/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.dev.wizard.EJBListViewChildren;
import org.netbeans.modules.websvc.dev.wizard.EjbChooser;
import org.netbeans.modules.websvc.dev.wizard.PlatformUtil;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WebServiceTypePanel
extends JPanel
implements HelpCtx.Provider,
ItemListener {
    private Project project;
    private Node[] sessionBeanNodes;
    private final List listeners = new ArrayList();
    private boolean isWaitingForScan = false;
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean jwsdpSupported;
    private ButtonGroup buttonGroup1;
    private JButton jButtonConvert;
    private JButton jButtonDelegate;
    private JLabel jLabelConvert;
    private JLabel jLabelDelegate;
    private JRadioButton jRadioButtonConvert;
    private JRadioButton jRadioButtonDelegate;
    private JRadioButton jRadioButtonScratch;
    private JTextField jTextFieldConvert;
    private JTextField jTextFieldDelegate;

    public WebServiceTypePanel(Project project) {
        this.project = project;
        this.initComponents();
        this.jsr109Supported = PlatformUtil.isJsr109Supported(project);
        this.jsr109oldSupported = PlatformUtil.isJsr109OldSupported(project);
        this.jwsdpSupported = PlatformUtil.isJWSDPSupported(project);
        this.jRadioButtonConvert.setEnabled(false);
        this.jLabelConvert.setEnabled(false);
        this.jTextFieldConvert.setEnabled(false);
        this.jButtonConvert.setEnabled(false);
        this.jRadioButtonConvert.setVisible(false);
        this.jLabelConvert.setVisible(false);
        this.jTextFieldConvert.setVisible(false);
        this.jButtonConvert.setVisible(false);
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        EjbJar em = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
        if (em == null && wm == null || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported) {
            this.disableDelegateToEJB();
        }
        this.addItemListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButtonScratch = new JRadioButton();
        this.jRadioButtonDelegate = new JRadioButton();
        this.jLabelDelegate = new JLabel();
        this.jTextFieldDelegate = new JTextField();
        this.jButtonDelegate = new JButton();
        this.jRadioButtonConvert = new JRadioButton();
        this.jLabelConvert = new JLabel();
        this.jTextFieldConvert = new JTextField();
        this.jButtonConvert = new JButton();
        this.buttonGroup1.add(this.jRadioButtonScratch);
        this.jRadioButtonScratch.setMnemonic(NbBundle.getMessage(WebServiceTypePanel.class, (String)"MNE_CreateEmptyWS").charAt(0));
        this.jRadioButtonScratch.setSelected(true);
        this.jRadioButtonScratch.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EmptyWebService"));
        this.jRadioButtonScratch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonScratch.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.jRadioButtonDelegate);
        this.jRadioButtonDelegate.setMnemonic(NbBundle.getMessage(WebServiceTypePanel.class, (String)"MNE_DelegateSessionBean").charAt(0));
        this.jRadioButtonDelegate.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EncapsulateSessionBean"));
        this.jRadioButtonDelegate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonDelegate.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelDelegate.setDisplayedMnemonic(NbBundle.getMessage(WebServiceTypePanel.class, (String)"MNE_EnterpriseBeans").charAt(0));
        this.jLabelDelegate.setLabelFor(this.jTextFieldDelegate);
        this.jLabelDelegate.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_EnterpriseBean"));
        this.jTextFieldDelegate.setEditable(false);
        this.jTextFieldDelegate.setEnabled(false);
        this.jButtonDelegate.setMnemonic(NbBundle.getMessage(WebServiceTypePanel.class, (String)"MNE_Browse").charAt(0));
        this.jButtonDelegate.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_Browse"));
        this.jButtonDelegate.setEnabled(false);
        this.jButtonDelegate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebServiceTypePanel.this.jButtonDelegateActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonConvert);
        this.jRadioButtonConvert.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_ConvertJavaClass"));
        this.jRadioButtonConvert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonConvert.setMargin(new Insets(0, 0, 0, 0));
        this.jLabelConvert.setLabelFor(this.jTextFieldConvert);
        this.jLabelConvert.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_JavaClass"));
        this.jTextFieldConvert.setEditable(false);
        this.jTextFieldConvert.setEnabled(false);
        this.jButtonConvert.setText(NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_Browse"));
        this.jButtonConvert.setEnabled(false);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonScratch).addContainerGap(313, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonDelegate).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelConvert).add((Component)this.jLabelDelegate)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jTextFieldConvert).add((Component)this.jTextFieldDelegate)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonConvert).add((Component)this.jButtonDelegate))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonConvert, 0, 497, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(new Component[]{this.jLabelConvert, this.jLabelDelegate}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonScratch).addPreferredGap(0).add((Component)this.jRadioButtonDelegate, -2, 15, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonDelegate).add((Component)this.jLabelDelegate).add((Component)this.jTextFieldDelegate, -2, -1, -2)).addPreferredGap(0).add((Component)this.jRadioButtonConvert).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelConvert).add((Component)this.jButtonConvert).add((Component)this.jTextFieldConvert, -2, -1, -2)).addContainerGap(184, Short.MAX_VALUE)));
    }

    private void jButtonDelegateActionPerformed(ActionEvent evt) {
        Project[] allProjects = this.getCallableEjbProjects(this.project);
        LinkedList<2> ejbProjectNodes = new LinkedList<2>();
        for (int i = 0; i < allProjects.length; ++i) {
            LogicalViewProvider lvp = (LogicalViewProvider)allProjects[i].getLookup().lookup(LogicalViewProvider.class);
            Node projectView = lvp.createLogicalView();
            ejbProjectNodes.add(new FilterNode(projectView, (Children)new EJBListViewChildren(allProjects[i])){

                public Action[] getActions(boolean context) {
                    return new Action[0];
                }
            });
        }
        Children.Array children = new Children.Array();
        children.add(ejbProjectNodes.toArray(new Node[ejbProjectNodes.size()]));
        AbstractNode root = new AbstractNode((Children)children);
        EjbChooser chooser = new EjbChooser((Node)root);
        final DialogDescriptor dd = new DialogDescriptor((Object)chooser, NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_BrowseBean_Title"));
        dd.setValid(false);
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("ejbChooser_isValid") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    dd.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (result == DialogDescriptor.OK_OPTION) {
            this.jTextFieldDelegate.setText(chooser.getSelectedEJBProjectName() + "#" + chooser.getSelectedNodes()[0].getDisplayName());
            this.sessionBeanNodes = chooser.getSelectedNodes();
            this.fireChange();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!this.checkNonJsr109Valid(wizardDescriptor)) {
            return false;
        }
        if (this.getServiceType() == 1 && this.jTextFieldDelegate.getText().length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceTypePanel.class, (String)"LBL_SelectOneEJB"));
            return false;
        }
        if (JavaMetamodel.getManager().isScanInProgress()) {
            if (!this.isWaitingForScan) {
                this.isWaitingForScan = true;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        WebServiceTypePanel.this.isWaitingForScan = false;
                        WebServiceTypePanel.this.fireChange();
                    }
                });
            }
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceTypePanel.class, (String)"MSG_ScanningInProgress"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    private boolean checkNonJsr109Valid(WizardDescriptor wizardDescriptor) {
        if ((!this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported && this.jwsdpSupported) && Util.isSourceLevel14orLower((Project)this.project)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceTypePanel.class, (String)"ERR_NeedProperSourceLevel"));
            return false;
        }
        return true;
    }

    void store(WizardDescriptor d) {
        d.putProperty("webServiceType", (Object)new Integer(this.getServiceType()));
        if (this.getServiceType() == 1) {
            d.putProperty("delegateToSessionBean", (Object)this.sessionBeanNodes);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceTypePanel.class);
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src.equals(this.jRadioButtonScratch)) {
            this.jButtonDelegate.setEnabled(false);
            this.jTextFieldDelegate.setEnabled(false);
        } else if (src.equals(this.jRadioButtonDelegate)) {
            this.jButtonDelegate.setEnabled(true);
            this.jTextFieldDelegate.setEnabled(true);
        }
        this.fireChange();
    }

    public void addItemListener(ItemListener l) {
        this.jRadioButtonScratch.addItemListener(l);
        this.jRadioButtonDelegate.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.jRadioButtonScratch.removeItemListener(l);
        this.jRadioButtonDelegate.removeItemListener(l);
    }

    public int getServiceType() {
        if (this.jRadioButtonScratch.isSelected()) {
            return 0;
        }
        return 1;
    }

    private void disableDelegateToEJB() {
        this.jRadioButtonDelegate.setEnabled(false);
        this.jLabelDelegate.setEnabled(false);
        this.jTextFieldDelegate.setEnabled(false);
        this.jButtonDelegate.setEnabled(false);
    }

    private Project[] getCallableEjbProjects(Project enterpriseProject) {
        Project[] allProjects = OpenProjects.getDefault().getOpenProjects();
        boolean isCallerEJBModule = false;
        J2eeModuleProvider callerJ2eeModuleProvider = (J2eeModuleProvider)enterpriseProject.getLookup().lookup(J2eeModuleProvider.class);
        if (callerJ2eeModuleProvider != null && callerJ2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
            isCallerEJBModule = true;
        }
        boolean isCallerFreeform = enterpriseProject.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> filteredResults = new ArrayList<Project>(allProjects.length);
        for (int i = 0; i < allProjects.length; ++i) {
            boolean isEJBModule = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)allProjects[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                isEJBModule = true;
            }
            if ((!isEJBModule || isCallerFreeform) && (!isCallerFreeform || !enterpriseProject.equals(allProjects[i]))) continue;
            filteredResults.add(allProjects[i]);
        }
        return filteredResults.toArray(new Project[filteredResults.size()]);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }
}

