/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.module.api.support.TargetLister;
import org.apache.tools.ant.module.spi.AntEvent;
import org.netbeans.modules.ant.debugger.DebuggerAnnotation;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Utils {
    private static Object currentLine;
    static final /* synthetic */ boolean $assertionsDisabled;

    static void markCurrent(Object line) {
        Utils.unmarkCurrent();
        Annotatable[] annotatables = (Annotatable[])line;
        int i = 0;
        int k = annotatables.length;
        DebuggerAnnotation[] annotations = new DebuggerAnnotation[k];
        annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_PART_ANNOTATION_TYPE, annotatables[i]) : new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_ANNOTATION_TYPE, annotatables[i]);
        for (i = 1; i < k; ++i) {
            annotations[i] = annotatables[i] instanceof Line.Part ? new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_PART_ANNOTATION_TYPE2, annotatables[i]) : new DebuggerAnnotation(DebuggerAnnotation.CURRENT_LINE_ANNOTATION_TYPE2, annotatables[i]);
        }
        currentLine = annotations;
        Utils.showLine(line);
    }

    static void unmarkCurrent() {
        if (currentLine != null) {
            int k = ((DebuggerAnnotation[])currentLine).length;
            for (int i = 0; i < k; ++i) {
                ((DebuggerAnnotation[])currentLine)[i].detach();
            }
            currentLine = null;
        }
    }

    static void showLine(Object line) {
        final Annotatable[] a = (Annotatable[])line;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (a[0] instanceof Line) {
                    ((Line)a[0]).show(2);
                } else if (a[0] instanceof Line.Part) {
                    ((Line.Part)a[0]).getLine().show(2);
                } else {
                    throw new InternalError();
                }
            }
        });
    }

    static int getLineNumber(Object line) {
        Annotatable[] a = (Annotatable[])line;
        if (a[0] instanceof Line) {
            return ((Line)a[0]).getLineNumber();
        }
        if (a[0] instanceof Line.Part) {
            return ((Line.Part)a[0]).getLine().getLineNumber();
        }
        throw new InternalError();
    }

    public static boolean contains(Object currentLine, Line line) {
        if (currentLine == null) {
            return false;
        }
        Annotatable[] a = (Annotatable[])currentLine;
        int k = a.length;
        for (int i = 0; i < k; ++i) {
            if (a[i].equals(line)) {
                return true;
            }
            if (!(a[i] instanceof Line.Part) || !((Line.Part)a[i]).getLine().equals(line)) continue;
            return true;
        }
        return false;
    }

    static Object getLine(AntEvent event) {
        File file = event.getScriptLocation();
        int lineNumber = event.getLine();
        if (file == null) {
            return null;
        }
        if (lineNumber < 0) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        try {
            DataObject d = DataObject.find((FileObject)fileObject);
            EditorCookie editor = (EditorCookie)d.getCookie(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)d.getCookie(LineCookie.class);
            if (!$assertionsDisabled && editor == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && lineCookie == null) {
                throw new AssertionError();
            }
            StyledDocument doc = editor.openDocument();
            InputSource in = Utils.createInputSource(fileObject, editor, doc);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            int[] line = new int[4];
            class Handler
            extends DefaultHandler {
                private Locator locator;
                private final /* synthetic */ int[] val$line;
                private final /* synthetic */ AntEvent val$event;
                private final /* synthetic */ int val$lineNumber;

                Handler(int[] nArray, AntEvent antEvent, int n) {
                    this.val$line = nArray;
                    this.val$event = antEvent;
                    this.val$lineNumber = n;
                }

                public void setDocumentLocator(Locator l) {
                    this.locator = l;
                }

                public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                    if (this.val$line[0] == 0 && qname.equals(this.val$event.getTaskName()) && this.locator.getLineNumber() == this.val$lineNumber) {
                        this.val$line[0] = this.locator.getLineNumber();
                        this.val$line[1] = this.locator.getColumnNumber() - 1;
                    }
                }

                public void endElement(String uri, String localname, String qname) throws SAXException {
                    if (this.val$line[0] != 0 && this.val$line[2] == 0 && qname.equals(this.val$event.getTaskName())) {
                        this.val$line[2] = this.locator.getLineNumber();
                        this.val$line[3] = this.locator.getColumnNumber() - 1;
                    }
                }
            }
            parser.parse(in, (DefaultHandler)new Handler(line, event, lineNumber));
            if (line[0] == 0) {
                return null;
            }
            Annotatable[] annotatables = new Annotatable[line[2] - line[0] + 1];
            int i = 0;
            for (int ln = line[0]; ln <= line[2]; ++ln) {
                Line l = lineCookie.getLineSet().getCurrent(ln - 1);
                annotatables[i++] = l;
            }
            return annotatables;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Object getLine(TargetLister.Target target, String nextTargetName) {
        LineCookie lineCookie;
        EditorCookie editor;
        FileObject fileObject = target.getScript().getFileObject();
        if (!$assertionsDisabled && fileObject == null) {
            throw new AssertionError((Object)("No build script for " + target.getName()));
        }
        try {
            DataObject d = DataObject.find((FileObject)fileObject);
            editor = (EditorCookie)d.getCookie(EditorCookie.class);
            lineCookie = (LineCookie)d.getCookie(LineCookie.class);
            if (!$assertionsDisabled && editor == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && lineCookie == null) {
                throw new AssertionError();
            }
        }
        catch (DataObjectNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        try {
            Line fLine;
            int inx;
            StyledDocument doc = editor.openDocument();
            InputSource in = Utils.createInputSource(fileObject, editor, doc);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            int[] line = new int[4];
            class Handler
            extends DefaultHandler {
                private Locator locator;
                private final /* synthetic */ int[] val$line;
                private final /* synthetic */ TargetLister.Target val$target;

                Handler(int[] nArray, TargetLister.Target target) {
                    this.val$line = nArray;
                    this.val$target = target;
                }

                public void setDocumentLocator(Locator l) {
                    this.locator = l;
                }

                public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                    if (this.val$line[0] == 0 && qname.equals("target") && this.val$target.getName().equals(attr.getValue("name"))) {
                        this.val$line[0] = this.locator.getLineNumber();
                        this.val$line[1] = this.locator.getColumnNumber();
                    }
                }

                public void endElement(String uri, String localname, String qname) throws SAXException {
                    if (this.val$line[0] != 0 && this.val$line[2] == 0 && qname.equals("target")) {
                        this.val$line[2] = this.locator.getLineNumber();
                        this.val$line[3] = this.locator.getColumnNumber();
                    }
                }
            }
            parser.parse(in, (DefaultHandler)new Handler(line, target));
            if (line[0] == 0) {
                return null;
            }
            int ln = line[0] - 1;
            ArrayList<Object> annotatables = new ArrayList<Object>();
            if (nextTargetName != null && (inx = Utils.findIndexOf((fLine = lineCookie.getLineSet().getCurrent(ln)).getText(), nextTargetName)) >= 0) {
                annotatables.add(fLine.createPart(inx, nextTargetName.length()));
                ++ln;
            }
            if (annotatables.size() < 1) {
                while (ln < line[2]) {
                    Line l = lineCookie.getLineSet().getCurrent(ln);
                    annotatables.add(l);
                    ++ln;
                }
            }
            return annotatables.toArray(new Annotatable[annotatables.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int findIndexOf(String text, String target) {
        int index = 0;
        while ((index = text.indexOf(target, index)) > 0) {
            char c = text.charAt(index - 1);
            if (!Character.isWhitespace(c) && c != ',' && c != '\"') {
                ++index;
                continue;
            }
            if (text.length() <= index + target.length() || Character.isWhitespace(c = text.charAt(index + target.length())) || c == ',' || c == '\"') break;
            ++index;
        }
        return index;
    }

    private static InputSource createInputSource(FileObject fo, EditorCookie editor, final StyledDocument document) throws IOException, BadLocationException {
        InputSource in;
        block5: {
            final StringWriter w = new StringWriter(document.getLength());
            final EditorKit kit = Utils.findKit(editor.getOpenedPanes());
            final IOException[] ioe = new IOException[1];
            final BadLocationException[] ble = new BadLocationException[1];
            document.render(new Runnable(){

                public void run() {
                    try {
                        kit.write(w, (Document)document, 0, document.getLength());
                    }
                    catch (IOException e) {
                        ioe[0] = e;
                    }
                    catch (BadLocationException e) {
                        ble[0] = e;
                    }
                }
            });
            if (ioe[0] != null) {
                throw ioe[0];
            }
            if (ble[0] != null) {
                throw ble[0];
            }
            in = new InputSource(new StringReader(w.toString()));
            if (fo != null) {
                try {
                    in.setSystemId(fo.getURL().toExternalForm());
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return in;
    }

    private static EditorKit findKit(JEditorPane[] panes) {
        EditorKit kit;
        if (panes != null) {
            kit = panes[0].getEditorKit();
        } else {
            kit = JEditorPane.createEditorKitForContentType("text/xml");
            if (kit == null) {
                kit = new DefaultEditorKit();
            }
        }
        if (!$assertionsDisabled && kit == null) {
            throw new AssertionError();
        }
        return kit;
    }

    static {
        $assertionsDisabled = !Utils.class.desiredAssertionStatus();
    }
}

