/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.generaleditor;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.options.generaleditor.Model;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class GeneralEditorPanel
extends JPanel
implements ActionListener {
    private JCheckBox cbShowCodeFolding = new JCheckBox();
    private JCheckBox cbFoldMethods = new JCheckBox();
    private JCheckBox cbFoldInnerClasses = new JCheckBox();
    private JCheckBox cbFoldImports = new JCheckBox();
    private JCheckBox cbFoldJavaDocComments = new JCheckBox();
    private JCheckBox cbFoldInitialComment = new JCheckBox();
    private JCheckBox cbAutoPopup = new JCheckBox();
    private JCheckBox cbInsertSingleProposals = new JCheckBox();
    private JCheckBox cbCaseSensitive = new JCheckBox();
    private JCheckBox cbShowDeprecated = new JCheckBox();
    private JCheckBox cbPairCharacterCompletion = new JCheckBox();
    private boolean changed = false;
    private boolean listen = false;
    private Model model;

    public GeneralEditorPanel() {
        GeneralEditorPanel.loc(this.cbShowCodeFolding, "Use_Folding");
        GeneralEditorPanel.loc(this.cbFoldMethods, "Fold_Methods");
        GeneralEditorPanel.loc(this.cbFoldInnerClasses, "Fold_Classes");
        GeneralEditorPanel.loc(this.cbFoldImports, "Fold_Imports");
        GeneralEditorPanel.loc(this.cbFoldJavaDocComments, "Fold_JavaDoc");
        GeneralEditorPanel.loc(this.cbFoldInitialComment, "Fold_Licence");
        GeneralEditorPanel.loc(this.cbAutoPopup, "Auto_Popup_Completion_Window");
        GeneralEditorPanel.loc(this.cbInsertSingleProposals, "Insert_Single_Proposals_Automatically");
        GeneralEditorPanel.loc(this.cbCaseSensitive, "Case_Sensitive_Code_Completion");
        GeneralEditorPanel.loc(this.cbShowDeprecated, "Show_Deprecated_Members");
        GeneralEditorPanel.loc(this.cbPairCharacterCompletion, "Pair_Character_Completion");
        FormLayout layout = new FormLayout("5dlu, p, 5dlu, p:g", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p,5dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.addSeparator(GeneralEditorPanel.loc("Code_Folding"), cc.xyw(1, 1, 4));
        builder.addLabel(GeneralEditorPanel.loc("Code_Folding_Section"), lc.xy(2, 3), (Component)this.cbShowCodeFolding, cc.xy(4, 3));
        builder.addLabel(GeneralEditorPanel.loc("Fold_by_Default"), lc.xy(2, 5), (Component)this.cbFoldMethods, cc.xy(4, 5));
        builder.add((Component)this.cbFoldInnerClasses, cc.xy(4, 7));
        builder.add((Component)this.cbFoldImports, cc.xy(4, 9));
        builder.add((Component)this.cbFoldJavaDocComments, cc.xy(4, 11));
        builder.add((Component)this.cbFoldInitialComment, cc.xy(4, 13));
        builder.addSeparator(GeneralEditorPanel.loc("Code_Completion"), cc.xyw(1, 15, 4));
        builder.addLabel(GeneralEditorPanel.loc("Code_Completion_Section"), lc.xy(2, 17), (Component)this.cbAutoPopup, cc.xy(4, 17));
        builder.add((Component)this.cbInsertSingleProposals, cc.xy(4, 19));
        builder.add((Component)this.cbCaseSensitive, cc.xy(4, 21));
        builder.add((Component)this.cbShowDeprecated, cc.xy(4, 23));
        builder.add((Component)this.cbPairCharacterCompletion, cc.xy(4, 25));
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)GeneralEditorPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (!(c instanceof JLabel)) {
            c.getAccessibleContext().setAccessibleName(GeneralEditorPanel.loc("AN_" + key));
            c.getAccessibleContext().setAccessibleDescription(GeneralEditorPanel.loc("AD_" + key));
        }
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)GeneralEditorPanel.loc("CTL_" + key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)GeneralEditorPanel.loc("CTL_" + key));
        }
    }

    void update() {
        this.listen = false;
        if (this.model == null) {
            this.model = new Model();
            this.cbShowCodeFolding.addActionListener(this);
            this.cbFoldMethods.addActionListener(this);
            this.cbFoldInnerClasses.addActionListener(this);
            this.cbFoldImports.addActionListener(this);
            this.cbFoldJavaDocComments.addActionListener(this);
            this.cbFoldInitialComment.addActionListener(this);
            this.cbAutoPopup.addActionListener(this);
            this.cbInsertSingleProposals.addActionListener(this);
            this.cbCaseSensitive.addActionListener(this);
            this.cbShowDeprecated.addActionListener(this);
            this.cbPairCharacterCompletion.addActionListener(this);
        }
        this.cbShowCodeFolding.setSelected(this.model.isShowCodeFolding());
        this.cbFoldImports.setSelected(this.model.isFoldImports());
        this.cbFoldInitialComment.setSelected(this.model.isFoldInitialComment());
        this.cbFoldInnerClasses.setSelected(this.model.isFoldInnerClasses());
        this.cbFoldJavaDocComments.setSelected(this.model.isFoldJavaDocComments());
        this.cbFoldMethods.setSelected(this.model.isFoldMethods());
        this.updateEnabledState();
        this.cbPairCharacterCompletion.setSelected(this.model.isPairCharacterCompletion());
        this.cbAutoPopup.setSelected(this.model.isCompletionAutoPopup());
        this.cbShowDeprecated.setSelected(this.model.isShowDeprecatedMembers());
        this.cbInsertSingleProposals.setSelected(this.model.isCompletionInstantSubstitution());
        this.cbCaseSensitive.setSelected(this.model.isCompletionCaseSensitive());
        this.listen = true;
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        this.model.setFoldingOptions(this.cbShowCodeFolding.isSelected(), this.cbFoldImports.isSelected(), this.cbFoldInitialComment.isSelected(), this.cbFoldInnerClasses.isSelected(), this.cbFoldJavaDocComments.isSelected(), this.cbFoldMethods.isSelected());
        this.model.setCompletionOptions(this.cbPairCharacterCompletion.isSelected(), this.cbAutoPopup.isSelected(), this.cbShowDeprecated.isSelected(), this.cbInsertSingleProposals.isSelected(), this.cbCaseSensitive.isSelected());
        this.changed = false;
    }

    void cancel() {
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        if (e.getSource() == this.cbShowCodeFolding) {
            this.updateEnabledState();
        }
        this.changed = true;
    }

    private void updateEnabledState() {
        boolean useCodeFolding = this.cbShowCodeFolding.isSelected();
        this.cbFoldImports.setEnabled(useCodeFolding);
        this.cbFoldInitialComment.setEnabled(useCodeFolding);
        this.cbFoldInnerClasses.setEnabled(useCodeFolding);
        this.cbFoldJavaDocComments.setEnabled(useCodeFolding);
        this.cbFoldMethods.setEnabled(useCodeFolding);
    }
}

