/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jmi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.Constant;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.Parameter;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import org.netbeans.lib.jmi.util.DebugException;
import org.netbeans.lib.jmi.util.Logger;

public class TagProvider {
    public static final String TAGID_PACKAGE_PREFIX = "javax.jmi.packagePrefix";
    public static final String TAGID_SUBSTITUTE_NAME = "javax.jmi.substituteName";
    public static final String TAGID_IGNORE_LIFECYCLE = "javax.jmi.ignoreLifecycle";
    public static final String TAGID_IMPL_PACKAGE_PREFIX = "org.netbeans.implPackagePrefix";
    public static final String TAGID_XMI_NAMESPACE = "org.omg.xmi.namespace";
    public static final int ASSOCIATION = 0;
    public static final int INSTANCE = 1;
    public static final int CLASS = 2;
    public static final int PACKAGE = 3;
    private static final String DT_ORDERED = "java.util.List";
    private static final String DT_MULTIVALUED = "java.util.Collection";
    private final HashMap valueCache = new HashMap();

    public Tag getTag(ModelElement element, String tagID) {
        Tag tag = null;
        List tags = ((ModelPackage)element.refImmediatePackage()).getAttachesTo().getTag(element);
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            Tag temp = (Tag)it.next();
            if (!tagID.equals(temp.getTagId())) continue;
            tag = temp;
            break;
        }
        return tag;
    }

    public Collection getTagValues(ModelElement element, String tagID) {
        Tag tag = this.getTag(element, tagID);
        if (tag == null) {
            return null;
        }
        return tag.getValues();
    }

    public String getTagValue(ModelElement element, String tagID) {
        Collection values;
        if (element == null) {
            return null;
        }
        String tagKey = element.refMofId() + ":" + tagID;
        String value = (String)this.valueCache.get(tagKey);
        if (value == null && (values = this.getTagValues(element, tagID)) != null && values.size() > 0) {
            value = (String)values.iterator().next();
            this.valueCache.put(tagKey, value);
        }
        return value;
    }

    public String getTagValue(ModelElement element, String tagID, String defaultValue) {
        String result = this.getTagValue(element, tagID);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public String getTypeFullName(ModelElement type) {
        return this.getTypePrefix(type, new StringBuffer(50)).append('.').append(this.getSubstName(type)).toString();
    }

    public String getDataTypeName(Parameter prm) {
        MultiplicityType mp = prm.getMultiplicity();
        if (mp.getUpper() > 1 || mp.getUpper() == -1) {
            return mp.isOrdered() ? DT_ORDERED : DT_MULTIVALUED;
        }
        return this.getDataTypeName(prm.getType());
    }

    public String getDataTypeName(Classifier type) {
        String result = type instanceof PrimitiveType ? "java.lang." + type.getName() : (type instanceof AliasType ? this.getDataTypeName(((AliasType)type).getType()) : (type instanceof CollectionType ? (((CollectionType)type).getMultiplicity().isOrdered() ? DT_ORDERED : DT_MULTIVALUED) : this.getTypeFullName((ModelElement)type)));
        return result;
    }

    public String getSubstName(ModelElement element) {
        String result = this.getTagValue(element, TAGID_SUBSTITUTE_NAME);
        if (result == null) {
            result = element.getName();
        }
        if (element instanceof Constant) {
            result = TagProvider.mapName(result, true, false);
        } else {
            boolean flag = element instanceof MofClass || element instanceof MofPackage || element instanceof Association || element instanceof MofException || element instanceof StructureType || element instanceof EnumerationType || element instanceof CollectionType || element instanceof Import;
            result = TagProvider.mapName(result, false, !flag);
        }
        if (element instanceof MofException && !result.endsWith("Exception")) {
            result = result + "Exception";
        }
        return result;
    }

    private static String mapName(String name, boolean toLiteral, boolean firstLower) {
        StringBuffer buffer = new StringBuffer(32);
        boolean wordRead = false;
        boolean lowerCharDetected = false;
        for (int x = 0; x < name.length(); ++x) {
            char c = name.charAt(x);
            if (c == '-' || c == '_' || Character.isWhitespace(c)) {
                if (!wordRead) continue;
                if (toLiteral) {
                    buffer.append('_');
                }
                wordRead = false;
                lowerCharDetected = false;
                continue;
            }
            if (lowerCharDetected && Character.isUpperCase(c)) {
                if (toLiteral) {
                    buffer.append('_');
                }
                wordRead = false;
                lowerCharDetected = false;
            } else if (Character.isLowerCase(c)) {
                lowerCharDetected = true;
            }
            if (!wordRead || toLiteral) {
                buffer.append(Character.toUpperCase(c));
            } else {
                buffer.append(Character.toLowerCase(c));
            }
            wordRead = true;
        }
        if (buffer.length() > 0) {
            if (toLiteral && !wordRead) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            if (firstLower) {
                buffer.replace(0, 1, new String(new char[]{Character.toLowerCase(buffer.charAt(0))}));
            }
        }
        return buffer.toString();
    }

    public static String mapEnumLiteral(String name) {
        return TagProvider.mapName(name, true, false);
    }

    public String getNamespaceName(MofPackage type) {
        String result = this.getTagValue((ModelElement)type, TAGID_XMI_NAMESPACE);
        if (result == null) {
            result = type.getName();
        }
        return result;
    }

    public String getTypePrefix(ModelElement metaObject) {
        return this.getTypePrefix(metaObject, new StringBuffer(50)).toString();
    }

    public String getImplFullName(ModelElement object, int type) {
        return this.getImplPrefix(object, new StringBuffer(50)).append('.').append(this.getSubstName(object)).append(type == 2 ? "Class" : (type == 3 ? "Package" : "")).append("Impl").toString();
    }

    private StringBuffer getImplPrefix(ModelElement object, StringBuffer sb) {
        try {
            ModelElement pckg = object;
            while (!(pckg instanceof MofPackage)) {
                pckg = pckg.getContainer();
            }
            Namespace container = pckg.getContainer();
            if (container == null) {
                String result = this.getTagValue(pckg, TAGID_IMPL_PACKAGE_PREFIX);
                if (result == null) {
                    result = this.getTagValue(pckg, TAGID_PACKAGE_PREFIX);
                    if (result == null) {
                        sb.append("impl");
                    } else if ("javax.jmi".equals(result = result.toLowerCase(Locale.US))) {
                        sb.append("org.netbeans.jmiimpl.mof");
                    } else if (result.startsWith("org.netbeans.jmi.")) {
                        sb.append("org.netbeans.jmiimpl").append(result.substring(16));
                    } else if (result.startsWith("org.omg")) {
                        if (result.length() == 7) {
                            sb.append("org.netbeans.jmiimpl.omg");
                        } else if (result.charAt(7) == '.') {
                            sb.append("org.netbeans.jmiimpl.omg").append(result.substring(7));
                        } else {
                            sb.append(result).append(".impl");
                        }
                    } else {
                        sb.append(result).append(".impl");
                    }
                } else {
                    sb.append(result.toLowerCase(Locale.US));
                }
            } else {
                this.getImplPrefix((ModelElement)container, sb);
            }
            String packageName = this.getTagValue(pckg, TAGID_SUBSTITUTE_NAME);
            if (packageName == null) {
                packageName = TagProvider.mapName(pckg.getName(), false, true);
            }
            sb.append('.').append(packageName.toLowerCase(Locale.US));
            return sb;
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    private StringBuffer getTypePrefix(ModelElement metaObject, StringBuffer sb) {
        ModelElement pckg = metaObject;
        while (!(pckg instanceof MofPackage)) {
            pckg = pckg.getContainer();
        }
        Namespace container = pckg.getContainer();
        if (container == null) {
            String result = this.getTagValue(pckg, TAGID_PACKAGE_PREFIX);
            if (result != null) {
                sb.append(result.toLowerCase(Locale.US)).append('.');
            }
        } else {
            this.getTypePrefix((ModelElement)container, sb).append('.');
        }
        String packageName = this.getTagValue(pckg, TAGID_SUBSTITUTE_NAME);
        if (packageName == null) {
            packageName = TagProvider.mapName(pckg.getName(), false, true);
        }
        return sb.append(packageName.toLowerCase(Locale.US));
    }
}

