/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.javacore.Cache;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.WeakListeners;

public class FilterClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener,
Cache.CachedElement {
    private static final boolean DEBUG = false;
    private final PropertyChangeSupport support;
    private final Object key;
    private final List resources;
    private boolean isUpToDate = true;
    private static HashMap resourceCache;
    private static HashMap instanceMap;
    private static HashMap implToCP;
    private static Cache cache;
    private static ClassPath validator;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FilterClassPathImplementation(List original, boolean preferSources) {
        if (!($assertionsDisabled || original != null && original.size() > 0)) {
            throw new AssertionError((Object)("Array of original classpaths can not be null or empty or contain nulls: " + original));
        }
        this.support = new PropertyChangeSupport(this);
        this.key = FilterClassPathImplementation.getKey(original, preferSources);
        this.resources = Collections.unmodifiableList(this.createResources(original, preferSources));
        instanceMap.put(this.key, this);
    }

    public void release() {
        implToCP.remove(this);
        instanceMap.remove(this.key);
    }

    public boolean isValid() {
        return this.isUpToDate;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.isUpToDate = false;
    }

    public List getResources() {
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private List createResources(List original, boolean preferSources) {
        ArrayList<PathResourceImplementation> list = new ArrayList<PathResourceImplementation>();
        JMManager manager = (JMManager)JMManager.getManager();
        if (validator == null) {
            validator = manager.getMergedClassPath();
        }
        HashSet<URL> visited = new HashSet<URL>();
        HashSet<URL> added = new HashSet<URL>();
        validator.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)PropertyChangeListener.class, (EventListener)this, (Object)validator));
        for (int j = 0; j < original.size(); ++j) {
            ClassPath origCP = (ClassPath)original.get(j);
            if (origCP == null) continue;
            Iterator it = origCP.entries().iterator();
            while (it.hasNext()) {
                ClassPath.Entry entry = (ClassPath.Entry)it.next();
                URL url = entry.getURL();
                if (!visited.add(url)) continue;
                FileObject root = entry.getRoot();
                boolean addBinary = false;
                boolean forceSource = root == null || !manager.mergedCPContainsRoot(root);
                FileObject[] sroots = SourceForBinaryQuery.findSourceRoots((URL)url).getRoots();
                if (sroots.length > 0) {
                    int i;
                    boolean cont = forceSource;
                    if (!forceSource) {
                        for (i = 0; i < sroots.length && manager.mergedCPContainsRoot(sroots[i]); ++i) {
                        }
                        boolean bl = cont = i >= sroots.length;
                    }
                    if (cont) {
                        for (i = 0; i < sroots.length; ++i) {
                            if (forceSource && !manager.mergedCPContainsRoot(sroots[i])) continue;
                            try {
                                URL surl = sroots[i].getURL();
                                if (visited.add(surl)) {
                                    if (preferSources || forceSource || sroots.length != 1 || !surl.getProtocol().equals("jar")) {
                                        PathResourceImplementation resource = (PathResourceImplementation)resourceCache.get(surl);
                                        if (resource == null) {
                                            resource = ClassPathSupport.createResource((URL)surl);
                                        }
                                        resourceCache.put(surl, resource);
                                        list.add(resource);
                                        added.add(surl);
                                        continue;
                                    }
                                    addBinary = true;
                                    continue;
                                }
                                if (added.contains(surl)) continue;
                                addBinary = true;
                                continue;
                            }
                            catch (FileStateInvalidException fsie) {
                                // empty catch block
                            }
                        }
                    } else {
                        addBinary = true;
                    }
                } else {
                    addBinary = true;
                }
                if (!addBinary || forceSource) continue;
                PathResourceImplementation resource = (PathResourceImplementation)resourceCache.get(url);
                if (resource == null) {
                    resource = ClassPathSupport.createResource((URL)url);
                }
                resourceCache.put(url, resource);
                list.add(resource);
            }
            origCP.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create((Class)(class$java$beans$PropertyChangeListener == null ? FilterClassPathImplementation.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener), (EventListener)this, (Object)origCP));
        }
        return list;
    }

    private static Object getKey(List original, boolean preferSources) {
        StringBuffer buf = new StringBuffer(1024);
        ClassPath mergedPath = ((JMManager)JMManager.getManager()).getMergedClassPath();
        Iterator it = original.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item == mergedPath) {
                buf.append("Merged");
                continue;
            }
            buf.append(item);
        }
        return buf.toString() + preferSources;
    }

    public static synchronized ClassPath createClassPath(List original, boolean preferSources) {
        ClassPath result;
        FilterClassPathImplementation instance = (FilterClassPathImplementation)instanceMap.get(FilterClassPathImplementation.getKey(original, preferSources));
        if (instance == null || !instance.isUpToDate) {
            instance = new FilterClassPathImplementation(original, preferSources);
            result = ClassPathFactory.createClassPath((ClassPathImplementation)instance);
            implToCP.put(instance, result);
        } else {
            result = (ClassPath)implToCP.get(instance);
        }
        cache.put(instance);
        return result;
    }

    static {
        $assertionsDisabled = !FilterClassPathImplementation.class.desiredAssertionStatus();
        resourceCache = new HashMap();
        instanceMap = new HashMap(15);
        implToCP = new HashMap(15);
        cache = new Cache(10);
    }
}

